/*
 * Decompiled with CFR 0.152.
 */
package org.drools.common;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.RuleBaseConfiguration;
import org.drools.base.evaluators.Operator;
import org.drools.common.BetaConstraints;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.reteoo.BetaMemory;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.LeftTupleMemory;
import org.drools.reteoo.RightTupleMemory;
import org.drools.rule.ContextEntry;
import org.drools.rule.VariableConstraint;
import org.drools.spi.BetaNodeFieldConstraint;
import org.drools.util.AbstractHashTable;
import org.drools.util.LeftTupleIndexHashTable;
import org.drools.util.LeftTupleList;
import org.drools.util.LinkedList;
import org.drools.util.LinkedListEntry;
import org.drools.util.RightTupleIndexHashTable;
import org.drools.util.RightTupleList;

public class SingleBetaConstraints
implements BetaConstraints {
    private static final long serialVersionUID = 400L;
    private BetaNodeFieldConstraint constraint;
    private boolean indexed;
    private RuleBaseConfiguration conf;

    public SingleBetaConstraints() {
    }

    public SingleBetaConstraints(BetaNodeFieldConstraint[] constraint, RuleBaseConfiguration conf) {
        this(constraint[0], conf, false);
    }

    public SingleBetaConstraints(BetaNodeFieldConstraint constraint, RuleBaseConfiguration conf) {
        this(constraint, conf, false);
    }

    public SingleBetaConstraints(BetaNodeFieldConstraint constraint, RuleBaseConfiguration conf, boolean disableIndex) {
        int depth;
        this.conf = conf;
        this.indexed = disableIndex || !conf.isIndexLeftBetaMemory() && !conf.isIndexRightBetaMemory() ? false : (depth = conf.getCompositeKeyDepth()) >= 1 && this.isIndexable(constraint);
        this.constraint = constraint;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.constraint = (BetaNodeFieldConstraint)in.readObject();
        this.indexed = in.readBoolean();
        this.conf = (RuleBaseConfiguration)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.constraint);
        out.writeBoolean(this.indexed);
        out.writeObject(this.conf);
    }

    private boolean isIndexable(BetaNodeFieldConstraint constraint) {
        if (constraint instanceof VariableConstraint) {
            VariableConstraint variableConstraint = (VariableConstraint)constraint;
            return variableConstraint.getEvaluator().getOperator() == Operator.EQUAL;
        }
        return false;
    }

    public ContextEntry[] createContext() {
        return new ContextEntry[]{this.constraint.createContextEntry()};
    }

    public void updateFromTuple(ContextEntry[] context, InternalWorkingMemory workingMemory, LeftTuple tuple) {
        context[0].updateFromTuple(workingMemory, tuple);
    }

    public void updateFromFactHandle(ContextEntry[] context, InternalWorkingMemory workingMemory, InternalFactHandle handle) {
        context[0].updateFromFactHandle(workingMemory, handle);
    }

    public boolean isAllowedCachedLeft(ContextEntry[] context, InternalFactHandle handle) {
        return this.indexed || this.constraint.isAllowedCachedLeft(context[0], handle);
    }

    public boolean isAllowedCachedRight(ContextEntry[] context, LeftTuple tuple) {
        return this.constraint.isAllowedCachedRight(tuple, context[0]);
    }

    public boolean isIndexed() {
        return this.indexed;
    }

    public int getIndexCount() {
        return this.indexed ? 1 : 0;
    }

    public boolean isEmpty() {
        return false;
    }

    public BetaMemory createBetaMemory(RuleBaseConfiguration config) {
        BetaMemory memory;
        if (this.indexed) {
            VariableConstraint variableConstraint = (VariableConstraint)this.constraint;
            AbstractHashTable.FieldIndex index = new AbstractHashTable.FieldIndex(variableConstraint.getFieldExtractor(), variableConstraint.getRequiredDeclarations()[0], variableConstraint.getEvaluator());
            LeftTupleMemory tupleMemory = this.conf.isIndexLeftBetaMemory() ? new LeftTupleIndexHashTable(new AbstractHashTable.FieldIndex[]{index}) : new LeftTupleList();
            RightTupleMemory factHandleMemory = this.conf.isIndexRightBetaMemory() ? new RightTupleIndexHashTable(new AbstractHashTable.FieldIndex[]{index}) : new RightTupleList();
            memory = new BetaMemory(config.isSequential() ? null : tupleMemory, factHandleMemory, this.createContext());
        } else {
            memory = new BetaMemory(config.isSequential() ? null : new LeftTupleList(), new RightTupleList(), this.createContext());
        }
        return memory;
    }

    public int hashCode() {
        return this.constraint.hashCode();
    }

    public LinkedList getConstraints() {
        LinkedList list = new LinkedList();
        list.add(new LinkedListEntry(this.constraint));
        return list;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        SingleBetaConstraints other = (SingleBetaConstraints)object;
        return this.constraint == other.constraint || this.constraint.equals(other.constraint);
    }

    public void resetFactHandle(ContextEntry[] context) {
        context[0].resetFactHandle();
    }

    public void resetTuple(ContextEntry[] context) {
        context[0].resetTuple();
    }
}

