/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import org.drools.RuleBaseConfiguration;
import org.drools.common.BaseNode;
import org.drools.common.BetaConstraints;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.NodeMemory;
import org.drools.common.PropagationContextImpl;
import org.drools.common.RuleBasePartitionId;
import org.drools.reteoo.AccumulateNode;
import org.drools.reteoo.BetaMemory;
import org.drools.reteoo.CollectNode;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.LeftTupleSink;
import org.drools.reteoo.LeftTupleSinkNode;
import org.drools.reteoo.LeftTupleSource;
import org.drools.reteoo.MemoryVisitor;
import org.drools.reteoo.ObjectSinkNode;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.ObjectTypeNode;
import org.drools.reteoo.ReteooBuilder;
import org.drools.reteoo.RightTuple;
import org.drools.reteoo.RightTupleSink;
import org.drools.reteoo.RuleRemovalContext;
import org.drools.reteoo.RuleTerminalNode;
import org.drools.rule.Behavior;
import org.drools.rule.BehaviorManager;
import org.drools.spi.BetaNodeFieldConstraint;
import org.drools.util.Iterator;
import org.drools.util.LinkedList;
import org.drools.util.LinkedListEntry;

public abstract class BetaNode
extends LeftTupleSource
implements LeftTupleSinkNode,
ObjectSinkNode,
RightTupleSink,
NodeMemory {
    protected LeftTupleSource leftInput;
    protected ObjectSource rightInput;
    protected BetaConstraints constraints;
    protected BehaviorManager behavior;
    private LeftTupleSinkNode previousTupleSinkNode;
    private LeftTupleSinkNode nextTupleSinkNode;
    private ObjectSinkNode previousObjectSinkNode;
    private ObjectSinkNode nextObjectSinkNode;
    protected boolean objectMemory = true;
    protected boolean tupleMemoryEnabled;

    public BetaNode() {
    }

    BetaNode(int id, RuleBasePartitionId partitionId, boolean partitionsEnabled, LeftTupleSource leftInput, ObjectSource rightInput, BetaConstraints constraints, Behavior[] behaviors) {
        super(id, partitionId, partitionsEnabled);
        this.leftInput = leftInput;
        this.rightInput = rightInput;
        this.constraints = constraints;
        this.behavior = new BehaviorManager(behaviors);
        if (this.constraints == null) {
            throw new RuntimeException("cannot have null constraints, must at least be an instance of EmptyBetaConstraints");
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.constraints = (BetaConstraints)in.readObject();
        this.behavior = (BehaviorManager)in.readObject();
        this.leftInput = (LeftTupleSource)in.readObject();
        this.rightInput = (ObjectSource)in.readObject();
        this.previousTupleSinkNode = (LeftTupleSinkNode)in.readObject();
        this.nextTupleSinkNode = (LeftTupleSinkNode)in.readObject();
        this.previousObjectSinkNode = (ObjectSinkNode)in.readObject();
        this.nextObjectSinkNode = (ObjectSinkNode)in.readObject();
        this.objectMemory = in.readBoolean();
        this.tupleMemoryEnabled = in.readBoolean();
        super.readExternal(in);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.constraints);
        out.writeObject(this.behavior);
        out.writeObject(this.leftInput);
        out.writeObject(this.rightInput);
        out.writeObject(this.previousTupleSinkNode);
        out.writeObject(this.nextTupleSinkNode);
        out.writeObject(this.previousObjectSinkNode);
        out.writeObject(this.nextObjectSinkNode);
        out.writeBoolean(this.objectMemory);
        out.writeBoolean(this.tupleMemoryEnabled);
        super.writeExternal(out);
    }

    public BetaNodeFieldConstraint[] getConstraints() {
        LinkedList constraints = this.constraints.getConstraints();
        BetaNodeFieldConstraint[] array = new BetaNodeFieldConstraint[constraints.size()];
        int i = 0;
        for (LinkedListEntry entry = (LinkedListEntry)constraints.getFirst(); entry != null; entry = (LinkedListEntry)entry.getNext()) {
            array[i++] = (BetaNodeFieldConstraint)entry.getObject();
        }
        return array;
    }

    public Behavior[] getBehaviors() {
        return this.behavior.getBehaviors();
    }

    public void attach() {
        this.rightInput.addObjectSink(this);
        this.leftInput.addTupleSink(this);
    }

    public void networkUpdated() {
        this.rightInput.networkUpdated();
        this.leftInput.networkUpdated();
    }

    public List getRules() {
        ArrayList<String> list = new ArrayList<String>();
        LeftTupleSink[] sinks = this.sink.getSinks();
        int length = sinks.length;
        for (int i = 0; i < length; ++i) {
            if (sinks[i] instanceof RuleTerminalNode) {
                list.add(((RuleTerminalNode)sinks[i]).getRule().getName());
                continue;
            }
            if (!(sinks[i] instanceof BetaNode)) continue;
            list.addAll(((BetaNode)sinks[i]).getRules());
        }
        return list;
    }

    public ObjectTypeNode getObjectTypeNode() {
        ObjectSource source = this.rightInput;
        while (!(source instanceof ObjectTypeNode)) {
            source = source.source;
        }
        return (ObjectTypeNode)source;
    }

    public void attach(InternalWorkingMemory[] workingMemories) {
        this.attach();
        for (InternalWorkingMemory workingMemory : workingMemories) {
            PropagationContextImpl propagationContext = new PropagationContextImpl(workingMemory.getNextPropagationIdCounter(), 3, null, null, null);
            this.rightInput.updateSink(this, propagationContext, workingMemory);
            this.leftInput.updateSink(this, propagationContext, workingMemory);
        }
    }

    protected void doRemove(RuleRemovalContext context, ReteooBuilder builder, BaseNode node, InternalWorkingMemory[] workingMemories) {
        context.visitTupleSource(this);
        if (!node.isInUse()) {
            this.removeTupleSink((LeftTupleSink)((Object)node));
        }
        if (!this.isInUse()) {
            int length = workingMemories.length;
            for (int i = 0; i < length; ++i) {
                BetaMemory memory = null;
                Object object = workingMemories[i].getNodeMemory(this);
                if (object instanceof CollectNode.CollectMemory) {
                    ((CollectNode)this).doRemove(workingMemories[i], (CollectNode.CollectMemory)object);
                    memory = ((CollectNode.CollectMemory)object).betaMemory;
                } else if (object instanceof AccumulateNode.AccumulateMemory) {
                    ((AccumulateNode)this).doRemove(workingMemories[i], (AccumulateNode.AccumulateMemory)object);
                    memory = ((AccumulateNode.AccumulateMemory)object).betaMemory;
                } else {
                    memory = (BetaMemory)object;
                }
                Iterator it = memory.getLeftTupleMemory().iterator();
                LeftTuple leftTuple = (LeftTuple)it.next();
                while (leftTuple != null) {
                    leftTuple.unlinkFromLeftParent();
                    leftTuple.unlinkFromRightParent();
                    leftTuple = (LeftTuple)it.next();
                }
                it = memory.getRightTupleMemory().iterator();
                RightTuple rightTuple = (RightTuple)it.next();
                while (rightTuple != null) {
                    if (rightTuple.getBlocked() != null) {
                        LeftTuple leftTuple2 = rightTuple.getBlocked();
                        while (leftTuple2 != null) {
                            LeftTuple temp = leftTuple2.getBlockedNext();
                            leftTuple2.setBlocker(null);
                            leftTuple2.setBlockedPrevious(null);
                            leftTuple2.setBlockedNext(null);
                            leftTuple2.unlinkFromLeftParent();
                            leftTuple2 = temp;
                        }
                    }
                    if (rightTuple.getRightTupleSink() == null) {
                        workingMemories[i].getFactHandleFactory().destroyFactHandle(rightTuple.getFactHandle());
                    }
                    rightTuple.unlinkFromRightParent();
                    rightTuple = (RightTuple)it.next();
                }
                workingMemories[i].clearNodeMemory(this);
            }
        }
        this.rightInput.remove(context, builder, this, workingMemories);
        if (!context.alreadyVisited(this.leftInput)) {
            this.leftInput.remove(context, builder, this, workingMemories);
        }
    }

    public boolean isObjectMemoryEnabled() {
        return this.objectMemory;
    }

    public void setObjectMemoryEnabled(boolean objectMemory) {
        this.objectMemory = objectMemory;
    }

    public boolean isLeftTupleMemoryEnabled() {
        return this.tupleMemoryEnabled;
    }

    public void setLeftTupleMemoryEnabled(boolean tupleMemoryEnabled) {
        this.tupleMemoryEnabled = tupleMemoryEnabled;
    }

    public String toString() {
        return "";
    }

    public void dumpMemory(InternalWorkingMemory workingMemory) {
        MemoryVisitor visitor = new MemoryVisitor(workingMemory);
        visitor.visit(this);
    }

    public int hashCode() {
        return this.leftInput.hashCode() ^ this.rightInput.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof BetaNode)) {
            return false;
        }
        BetaNode other = (BetaNode)object;
        return this.getClass() == other.getClass() && this.leftInput.equals(other.leftInput) && this.rightInput.equals(other.rightInput) && this.constraints.equals(other.constraints);
    }

    public Object createMemory(RuleBaseConfiguration config) {
        BetaMemory memory = this.constraints.createBetaMemory(config);
        memory.setBehaviorContext(this.behavior.createBehaviorContext());
        return memory;
    }

    public LeftTupleSinkNode getNextLeftTupleSinkNode() {
        return this.nextTupleSinkNode;
    }

    public void setNextLeftTupleSinkNode(LeftTupleSinkNode next) {
        this.nextTupleSinkNode = next;
    }

    public LeftTupleSinkNode getPreviousLeftTupleSinkNode() {
        return this.previousTupleSinkNode;
    }

    public void setPreviousLeftTupleSinkNode(LeftTupleSinkNode previous) {
        this.previousTupleSinkNode = previous;
    }

    public ObjectSinkNode getNextObjectSinkNode() {
        return this.nextObjectSinkNode;
    }

    public void setNextObjectSinkNode(ObjectSinkNode next) {
        this.nextObjectSinkNode = next;
    }

    public ObjectSinkNode getPreviousObjectSinkNode() {
        return this.previousObjectSinkNode;
    }

    public void setPreviousObjectSinkNode(ObjectSinkNode previous) {
        this.previousObjectSinkNode = previous;
    }
}

