/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.junit4;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import org.junit.After;
import org.junit.Assert;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.component.Component;
import org.mule.api.component.JavaComponent;
import org.mule.api.config.ConfigurationBuilder;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.registry.RegistrationException;
import org.mule.api.schedule.Scheduler;
import org.mule.api.schedule.Schedulers;
import org.mule.api.service.Service;
import org.mule.component.AbstractJavaComponent;
import org.mule.config.i18n.MessageFactory;
import org.mule.config.spring.SpringXmlConfigurationBuilder;
import org.mule.construct.AbstractPipeline;
import org.mule.construct.Flow;
import org.mule.construct.SimpleService;
import org.mule.processor.chain.SubflowInterceptingChainLifecycleWrapper;
import org.mule.tck.functional.FlowAssert;
import org.mule.tck.functional.FunctionalTestComponent;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.util.IOUtils;

public abstract class FunctionalTestCase
extends AbstractMuleContextTestCase {
    public FunctionalTestCase() {
        this.setStartContext(true);
    }

    @Deprecated
    protected String getConfigResources() {
        return null;
    }

    protected ConfigurationBuilder getBuilder() throws Exception {
        String configResources = this.getConfigResources();
        if (configResources != null) {
            return new SpringXmlConfigurationBuilder(configResources);
        }
        configResources = this.getConfigFile();
        if (configResources != null) {
            if (configResources.contains(",")) {
                throw new RuntimeException("Do not use this method when the config is composed of several files. Use getConfigFiles method instead.");
            }
            return new SpringXmlConfigurationBuilder(configResources);
        }
        String[] multipleConfigResources = this.getConfigFiles();
        return new SpringXmlConfigurationBuilder(multipleConfigResources);
    }

    protected String getConfigFile() {
        return null;
    }

    protected String[] getConfigFiles() {
        return null;
    }

    protected Object getComponent(String serviceName) throws Exception {
        FlowConstruct flowConstruct = (FlowConstruct)muleContext.getRegistry().lookupObject(serviceName);
        if (flowConstruct != null) {
            return this.getComponent(flowConstruct);
        }
        throw new RegistrationException(MessageFactory.createStaticMessage((String)("Service " + serviceName + " not found in Registry")));
    }

    protected Object getComponent(FlowConstruct flowConstruct) throws Exception {
        if (flowConstruct instanceof Service) {
            return this.getComponentObject(((Service)flowConstruct).getComponent());
        }
        if (flowConstruct instanceof SimpleService) {
            return this.getComponentObject(((SimpleService)flowConstruct).getComponent());
        }
        if (flowConstruct instanceof AbstractPipeline) {
            AbstractPipeline flow = (AbstractPipeline)flowConstruct;
            for (MessageProcessor processor : flow.getMessageProcessors()) {
                if (!(processor instanceof Component)) continue;
                return this.getComponentObject((Component)processor);
            }
        }
        throw new RegistrationException(MessageFactory.createStaticMessage((String)("Can't get component from flow construct " + flowConstruct.getName())));
    }

    protected FunctionalTestComponent getFunctionalTestComponent(String serviceName) throws Exception {
        return (FunctionalTestComponent)this.getComponent(serviceName);
    }

    protected FlowConstruct getFlowConstruct(String flowName) throws Exception {
        return muleContext.getRegistry().lookupFlowConstruct(flowName);
    }

    protected String loadResourceAsString(String resourceName) throws IOException {
        return IOUtils.getResourceAsString((String)resourceName, ((Object)((Object)this)).getClass());
    }

    protected InputStream loadResource(String resourceName) throws IOException {
        return IOUtils.getResourceAsStream((String)resourceName, ((Object)((Object)this)).getClass());
    }

    private Object getComponentObject(Component component) throws Exception {
        if (component instanceof JavaComponent) {
            return ((AbstractJavaComponent)component).getObjectFactory().getInstance(muleContext);
        }
        Assert.fail((String)"Component is not a JavaComponent and therefore has no component object instance");
        return null;
    }

    protected void stopFlowConstruct(String flowName) throws Exception {
        FlowConstruct flowConstruct = this.getFlowConstruct(flowName);
        if (flowConstruct instanceof Service) {
            Service service = (Service)flowConstruct;
            service.stop();
        } else {
            Flow flow = (Flow)flowConstruct;
            flow.stop();
        }
    }

    protected void testFlow(String flowName) throws Exception {
        this.testFlow(flowName, FunctionalTestCase.getTestEvent((Object)"data", (MessageExchangePattern)MessageExchangePattern.ONE_WAY));
    }

    protected void testFlow(String flowName, MuleEvent event) throws Exception {
        Flow flow = this.lookupFlowConstruct(flowName);
        flow.process(event);
        FlowAssert.verify(flowName);
    }

    protected MuleEvent runFlow(String flowName) throws Exception {
        return this.runFlow(flowName, null);
    }

    protected <T> MuleEvent runFlow(String flowName, T payload) throws Exception {
        Flow flow = this.lookupFlowConstruct(flowName);
        return flow.process(FunctionalTestCase.getTestEvent(payload));
    }

    protected <T> void runFlowAndExpect(String flowName, T expect) throws Exception {
        Assert.assertEquals(expect, (Object)this.runFlow(flowName).getMessage().getPayload());
    }

    protected <T> void runFlowAndExpectProperty(String flowName, String propertyName, T expect) throws Exception {
        Flow flow = this.lookupFlowConstruct(flowName);
        MuleEvent event = FunctionalTestCase.getTestEvent(null);
        MuleEvent responseEvent = flow.process(event);
        Assert.assertEquals(expect, (Object)responseEvent.getMessage().getOutboundProperty(propertyName));
    }

    protected <T, U> void runFlowWithPayloadAndExpect(String flowName, T expect, U payload) throws Exception {
        Assert.assertEquals(expect, (Object)this.runFlow(flowName).getMessage().getPayload());
    }

    protected Flow lookupFlowConstruct(String name) {
        return (Flow)muleContext.getRegistry().lookupFlowConstruct(name);
    }

    @After
    public final void clearFlowAssertions() throws Exception {
        FlowAssert.reset();
    }

    protected void stopFlowSchedulers(String flowName) throws MuleException {
        Collection schedulers = muleContext.getRegistry().lookupScheduler(Schedulers.flowConstructPollingSchedulers((String)flowName));
        for (Scheduler scheduler : schedulers) {
            scheduler.stop();
        }
    }

    protected SubflowInterceptingChainLifecycleWrapper getSubFlow(String subflowName) {
        return (SubflowInterceptingChainLifecycleWrapper)muleContext.getRegistry().lookupObject(subflowName);
    }

    protected void runSchedulersOnce(String flowConstructName) throws Exception {
        Collection schedulers = muleContext.getRegistry().lookupScheduler(Schedulers.flowConstructPollingSchedulers((String)flowConstructName));
        for (Scheduler scheduler : schedulers) {
            scheduler.schedule();
        }
    }
}

