/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.config.domain.query;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.mule.config.spring.parsers.AbstractMuleBeanDefinitionParser;
import org.mule.module.db.internal.config.domain.param.InputParamDefinitionDefinitionParser;
import org.mule.module.db.internal.config.domain.query.ParameterizedQueryDefinitionParser;
import org.mule.module.db.internal.config.domain.query.QueryTemplateFactoryBean;
import org.mule.module.db.internal.domain.param.InputQueryParam;
import org.mule.module.db.internal.domain.param.QueryParam;
import org.mule.module.db.internal.domain.query.QueryTemplate;
import org.mule.module.db.internal.domain.query.QueryType;
import org.mule.module.db.internal.parser.SimpleQueryTemplateParser;
import org.mule.util.IOUtils;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class QueryTemplateBeanDefinitionParser
extends AbstractMuleBeanDefinitionParser {
    public static final String PARAMETERIZED_QUERY = "parameterized-query";
    public static final String DYNAMIC_QUERY = "dynamic-query";
    public static final String TEMPLATE_QUERY_REF = "template-query-ref";
    public static final String IN_PARAM_ELEMENT = "in-param";
    public static final String FILE_ATTRIBUTE = "file";
    public static final String[] QUERY_DEFINITION_ELEMENTS = new String[]{"parameterized-query", "dynamic-query", "template-query-ref"};

    protected Class<?> getBeanClass(Element element) {
        return QueryTemplate.class;
    }

    protected boolean isSingleton() {
        return true;
    }

    protected void doParse(Element element, ParserContext context, BeanDefinitionBuilder builder) {
        builder.setScope(this.isSingleton() ? "singleton" : "prototype");
        ParserContext nestedCtx = new ParserContext(context.getReaderContext(), context.getDelegate(), (BeanDefinition)builder.getBeanDefinition());
        Element sqlElem = DomUtils.getChildElementByTagName((Element)element, (String)PARAMETERIZED_QUERY);
        if (sqlElem != null) {
            this.parseParameterizedQuery(element, builder, nestedCtx, sqlElem);
        } else {
            sqlElem = DomUtils.getChildElementByTagName((Element)element, (String)DYNAMIC_QUERY);
            if (sqlElem != null) {
                this.parseDynamicQuery(element, builder, sqlElem);
            } else {
                sqlElem = DomUtils.getChildElementByTagName((Element)element, (String)TEMPLATE_QUERY_REF);
                if (sqlElem != null) {
                    this.parseQueryTemplateRef(element, builder, nestedCtx, sqlElem);
                } else {
                    throw new IllegalArgumentException("Template must contain one of the following elements: " + Arrays.toString(QUERY_DEFINITION_ELEMENTS));
                }
            }
        }
    }

    private void parseDynamicQuery(Element element, BeanDefinitionBuilder builder, Element sqlElem) {
        String sqlText = sqlElem.getTextContent();
        QueryTemplate queryTemplate = new QueryTemplate(sqlText, QueryType.DDL, Collections.<QueryParam>emptyList(), true);
        builder.addConstructorArgValue((Object)queryTemplate);
        element.removeChild(sqlElem);
    }

    private void parseQueryTemplateRef(Element element, BeanDefinitionBuilder builder, ParserContext nestedCtx, Element template) {
        String queryTemplateRef = template.getAttribute("name");
        element.removeChild(template);
        List params = DomUtils.getChildElementsByTagName((Element)element, (String)IN_PARAM_ELEMENT);
        List<BeanDefinition> paramList = ParameterizedQueryDefinitionParser.parseParameterValues(params, nestedCtx);
        BeanDefinitionBuilder queryTemplateBuilder = BeanDefinitionBuilder.genericBeanDefinition(QueryTemplateFactoryBean.class);
        queryTemplateBuilder.addConstructorArgReference(queryTemplateRef);
        queryTemplateBuilder.addConstructorArgValue(paramList);
        builder.addConstructorArgValue((Object)queryTemplateBuilder.getBeanDefinition());
    }

    private void parseParameterizedQuery(Element element, BeanDefinitionBuilder builder, ParserContext nestedCtx, Element sqlElem) {
        String sqlText;
        boolean hasTextContent;
        boolean hasFileAttribute = sqlElem.hasAttribute(FILE_ATTRIBUTE);
        boolean bl = hasTextContent = !element.getTextContent().isEmpty();
        if (hasFileAttribute && hasTextContent) {
            throw new IllegalArgumentException(String.format("Element %s cannot contain attribute file and text content simultaneously", element.getTagName()));
        }
        if (hasFileAttribute) {
            String fileName = sqlElem.getAttribute(FILE_ATTRIBUTE);
            try {
                sqlText = IOUtils.getResourceAsString((String)fileName, ((Object)((Object)this)).getClass());
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to read query from file: " + fileName);
            }
        } else {
            Node node = sqlElem.getFirstChild();
            sqlText = node.getNextSibling() != null && node.getNextSibling().getNodeType() == 4 ? node.getNextSibling().getNodeValue() : node.getNodeValue();
        }
        SimpleQueryTemplateParser simpleQueryParser = new SimpleQueryTemplateParser();
        QueryTemplate queryTemplate = simpleQueryParser.parse(sqlText);
        if (queryTemplate.getParams().size() > 0 && !queryTemplate.usesNamedParameters()) {
            throw new IllegalArgumentException("Templates do not support inline parameters");
        }
        builder.addConstructorArgValue((Object)queryTemplate.getSqlText());
        builder.addConstructorArgValue((Object)queryTemplate.getType());
        element.removeChild(sqlElem);
        ManagedList params = new ManagedList();
        List childElementsByTagName = DomUtils.getChildElementsByTagName((Element)element, (String)IN_PARAM_ELEMENT);
        if (queryTemplate.usesNamedParameters()) {
            for (InputQueryParam inputSqlParam : queryTemplate.getInputParams()) {
                Element param = this.findOverriddenParamElement(inputSqlParam.getName(), childElementsByTagName);
                if (param == null) {
                    params.add(inputSqlParam);
                    continue;
                }
                BeanDefinition paramBean = this.parseParameter(nestedCtx, param);
                params.add(paramBean);
            }
        } else {
            for (Element param : childElementsByTagName) {
                BeanDefinition paramBean = this.parseParameter(nestedCtx, param);
                params.add(paramBean);
            }
        }
        builder.addConstructorArgValue((Object)params);
    }

    private BeanDefinition parseParameter(ParserContext nestedCtx, Element param) {
        InputParamDefinitionDefinitionParser paramParser = new InputParamDefinitionDefinitionParser();
        return paramParser.parse(param, nestedCtx);
    }

    private Element findOverriddenParamElement(String name, List<Element> paramElements) {
        if (name != null) {
            for (Element paramElement : paramElements) {
                if (!paramElement.hasAttribute("name") || !name.equals(paramElement.getAttribute("name"))) continue;
                return paramElement;
            }
        }
        return null;
    }
}

