/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.metadata;

import java.sql.PreparedStatement;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import org.mule.common.DefaultResult;
import org.mule.common.FailureType;
import org.mule.common.Result;
import org.mule.common.metadata.DefaultDefinedMapMetaDataModel;
import org.mule.common.metadata.DefaultListMetaDataModel;
import org.mule.common.metadata.DefaultMetaData;
import org.mule.common.metadata.MetaData;
import org.mule.common.metadata.MetaDataModel;
import org.mule.module.db.internal.domain.query.Query;
import org.mule.module.db.internal.metadata.AbstractQueryMetadataProvider;
import org.mule.module.db.internal.resolver.database.DbConfigResolver;
import org.mule.module.db.internal.result.resultset.ResultSetIterator;

public class SelectMetadataProvider
extends AbstractQueryMetadataProvider {
    private final boolean streaming;

    public SelectMetadataProvider(DbConfigResolver dbConfigResolver, Query query, boolean streaming) {
        super(dbConfigResolver, query);
        this.streaming = streaming;
    }

    @Override
    public Result<MetaData> getStaticOutputMetadata() {
        return null;
    }

    @Override
    public Result<MetaData> getDynamicOutputMetadata(PreparedStatement statement) {
        ResultSetMetaData statementMetaData;
        try {
            statementMetaData = statement.getMetaData();
        }
        catch (SQLException e) {
            return new DefaultResult(null, Result.Status.FAILURE, e.getMessage(), FailureType.UNSPECIFIED, (Throwable)e);
        }
        if (statementMetaData == null) {
            return new DefaultResult(null, Result.Status.FAILURE, "Driver did not return metadata for the provided SQL");
        }
        HashMap<String, MetaDataModel> recordModels = new HashMap<String, MetaDataModel>();
        try {
            for (int i = 1; i <= statementMetaData.getColumnCount(); ++i) {
                int columnType = statementMetaData.getColumnType(i);
                recordModels.put(statementMetaData.getColumnName(i), this.getDataTypeMetadataModel(columnType));
            }
        }
        catch (SQLException e) {
            return new DefaultResult(null, Result.Status.FAILURE, e.getMessage(), FailureType.UNSPECIFIED, (Throwable)e);
        }
        DefaultDefinedMapMetaDataModel recordModel = new DefaultDefinedMapMetaDataModel(recordModels);
        DefaultListMetaDataModel listModel = new DefaultListMetaDataModel((MetaDataModel)recordModel);
        if (this.streaming) {
            listModel.setImplementationClass(ResultSetIterator.class.getName());
        }
        DefaultMetaData defaultMetaData = new DefaultMetaData((MetaDataModel)listModel);
        return new DefaultResult((Object)defaultMetaData);
    }
}

