/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.resolver.param;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.module.db.internal.domain.connection.DbConnection;
import org.mule.module.db.internal.domain.query.QueryTemplate;
import org.mule.module.db.internal.domain.type.DbType;
import org.mule.module.db.internal.domain.type.DbTypeManager;
import org.mule.module.db.internal.domain.type.ResolvedDbType;
import org.mule.module.db.internal.domain.type.UnknownDbTypeException;
import org.mule.module.db.internal.resolver.param.ParamTypeResolver;

public class StoredProcedureParamTypeResolver
implements ParamTypeResolver {
    public static final int PARAM_NAME_COLUN_INDEX = 4;
    public static final int TYPE_ID_COLUMN_INDEX = 6;
    public static final int TYPE_NAME_COLUMN_INDEX = 7;
    private static final Log logger = LogFactory.getLog(StoredProcedureParamTypeResolver.class);
    private final Pattern storedProcedureMatcher = Pattern.compile("(?msi)(\\{\\s+)?call\\s* \\s*(\\w+)\\(.*");
    private final DbTypeManager dbTypeManager;

    public StoredProcedureParamTypeResolver(DbTypeManager dbTypeManager) {
        this.dbTypeManager = dbTypeManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Integer, DbType> getParameterTypes(DbConnection connection, QueryTemplate queryTemplate) throws SQLException {
        DatabaseMetaData dbMetaData = connection.getMetaData();
        String storedProcedureName = this.getStoredProcedureName(dbMetaData, queryTemplate.getSqlText());
        ResultSet procedureColumns = dbMetaData.getProcedureColumns(connection.getCatalog(), null, storedProcedureName, "%");
        try {
            Map<Integer, DbType> map = this.getStoredProcedureParamTypes(connection, storedProcedureName, procedureColumns);
            return map;
        }
        finally {
            if (procedureColumns != null) {
                procedureColumns.close();
            }
        }
    }

    private Map<Integer, DbType> getStoredProcedureParamTypes(DbConnection connection, String storedProcedureName, ResultSet procedureColumns) throws SQLException {
        HashMap<Integer, DbType> paramTypes = new HashMap<Integer, DbType>();
        int position = 1;
        while (procedureColumns.next()) {
            DbType dbType;
            int typeId = procedureColumns.getInt(6);
            String typeName = procedureColumns.getString(7);
            if (logger.isDebugEnabled()) {
                String name = procedureColumns.getString(4);
                logger.debug((Object)String.format("Resolved parameter type: Store procedure: %s Name: %s Index: %s Type ID: %s Type Name: %s", storedProcedureName, name, position, typeId, typeName));
            }
            try {
                dbType = this.dbTypeManager.lookup(connection, typeId, typeName);
            }
            catch (UnknownDbTypeException e) {
                dbType = new ResolvedDbType(typeId, typeName);
            }
            paramTypes.put(position, dbType);
            ++position;
        }
        return paramTypes;
    }

    private String getStoredProcedureName(DatabaseMetaData dbMetaData, String sqlText) throws SQLException {
        Matcher matcher = this.storedProcedureMatcher.matcher(sqlText);
        if (!matcher.matches()) {
            throw new SQLException("Unable to detect stored procedure name from " + sqlText);
        }
        String storedProcedureName = matcher.group(2);
        if (dbMetaData.storesUpperCaseIdentifiers()) {
            return storedProcedureName.toUpperCase();
        }
        return storedProcedureName;
    }
}

