/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jdbc.xa;

import java.util.Collection;
import java.util.LinkedList;
import javax.sql.DataSource;
import org.mule.api.MuleContext;
import org.mule.transport.jdbc.xa.DataSourceDecorator;
import org.mule.transport.jdbc.xa.DefaultDataSourceDecorator;

public class CompositeDataSourceDecorator
implements DataSourceDecorator {
    private LinkedList<DataSourceDecorator> decorators = new LinkedList();

    public CompositeDataSourceDecorator() {
        this.decorators.add(new DefaultDataSourceDecorator());
    }

    @Override
    public DataSource decorate(DataSource dataSource, String dataSourceName, MuleContext muleContext) {
        for (DataSourceDecorator decorator : this.decorators) {
            if (!decorator.appliesTo(dataSource, muleContext)) continue;
            return decorator.decorate(dataSource, dataSourceName, muleContext);
        }
        return dataSource;
    }

    @Override
    public boolean appliesTo(DataSource dataSource, MuleContext muleContext) {
        return true;
    }

    public void init(MuleContext muleContext) {
        Collection connectionFactoryDecorators = muleContext.getRegistry().lookupObjects(DataSourceDecorator.class);
        for (DataSourceDecorator connectionFactoryDecorator : connectionFactoryDecorators) {
            this.decorators.addFirst(connectionFactoryDecorator);
        }
    }
}

