/*
 * Decompiled with CFR 0.152.
 */
package org.mule.execution;

import org.mule.api.execution.ExecutionCallback;
import org.mule.api.transaction.Transaction;
import org.mule.api.transaction.TransactionConfig;
import org.mule.execution.ExecutionInterceptor;
import org.mule.transaction.TransactionCoordination;

public class IsolateCurrentTransactionInterceptor<T>
implements ExecutionInterceptor<T> {
    private ExecutionInterceptor<T> next;
    private TransactionConfig transactionConfig;

    public IsolateCurrentTransactionInterceptor(ExecutionInterceptor<T> nextProcessingInterceptor, TransactionConfig transactionConfig) {
        this.next = nextProcessingInterceptor;
        this.transactionConfig = transactionConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T execute(ExecutionCallback<T> muleEventProcessingCallback) throws Exception {
        boolean transactionIsolated = false;
        try {
            Transaction transaction;
            if (this.transactionConfig.getAction() == 7 && (transaction = TransactionCoordination.getInstance().getTransaction()) != null) {
                TransactionCoordination.getInstance().isolateTransaction();
                transactionIsolated = true;
            }
            T t = this.next.execute(muleEventProcessingCallback);
            return t;
        }
        finally {
            if (transactionIsolated) {
                TransactionCoordination.getInstance().restoreIsolatedTransaction();
            }
        }
    }
}

