/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.store;

import java.io.Serializable;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.store.ObjectStore;
import org.mule.config.i18n.CoreMessages;
import org.mule.util.UUID;
import org.mule.util.concurrent.DaemonThreadFactory;

public abstract class AbstractMonitoredObjectStore<T extends Serializable>
implements ObjectStore<T>,
Runnable,
MuleContextAware,
Initialisable,
Disposable {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected MuleContext context;
    protected ScheduledThreadPoolExecutor scheduler;
    protected int maxEntries = 4000;
    protected int entryTTL = -1;
    protected int expirationInterval = 1000;
    protected String name = null;

    @Override
    public void initialise() throws InitialisationException {
        if (this.name == null) {
            this.name = UUID.getUUID();
        }
        if (this.expirationInterval <= 0) {
            throw new IllegalArgumentException(CoreMessages.propertyHasInvalidValue("expirationInterval", new Integer(this.expirationInterval)).toString());
        }
        if (this.scheduler == null) {
            this.scheduler = new ScheduledThreadPoolExecutor(1);
            this.scheduler.setThreadFactory(new DaemonThreadFactory(this.name + "-Monitor", this.getClass().getClassLoader()));
            this.scheduler.scheduleWithFixedDelay(this, 0L, this.expirationInterval, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public final void run() {
        if (this.context == null || this.context.isPrimaryPollingInstance()) {
            this.expire();
        }
    }

    @Override
    public void dispose() {
        if (this.scheduler != null) {
            this.scheduler.shutdown();
        }
    }

    protected MuleContext getMuleContext() {
        return this.context;
    }

    public void setEntryTTL(int entryTTL) {
        this.entryTTL = entryTTL;
    }

    public void setExpirationInterval(int expirationInterval) {
        this.expirationInterval = expirationInterval;
    }

    public void setMaxEntries(int maxEntries) {
        this.maxEntries = maxEntries;
    }

    public void setScheduler(ScheduledThreadPoolExecutor scheduler) {
        this.scheduler = scheduler;
    }

    public void setName(String id) {
        this.name = id;
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.context = context;
    }

    public int getEntryTTL() {
        return this.entryTTL;
    }

    public int getExpirationInterval() {
        return this.expirationInterval;
    }

    public int getMaxEntries() {
        return this.maxEntries;
    }

    public String getName() {
        return this.name;
    }

    public ScheduledThreadPoolExecutor getScheduler() {
        return this.scheduler;
    }

    protected abstract void expire();
}

