/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.launcher.application;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.config.ConfigurationBuilder;
import org.mule.api.context.MuleContextBuilder;
import org.mule.api.context.notification.MuleContextListener;
import org.mule.config.builders.SimpleConfigurationBuilder;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.MessageFactory;
import org.mule.context.DefaultMuleContextFactory;
import org.mule.module.launcher.DeploymentInitException;
import org.mule.module.launcher.DeploymentListener;
import org.mule.module.launcher.DeploymentStartException;
import org.mule.module.launcher.DeploymentStopException;
import org.mule.module.launcher.DisposableClassLoader;
import org.mule.module.launcher.InstallException;
import org.mule.module.launcher.MuleDeploymentService;
import org.mule.module.launcher.application.Application;
import org.mule.module.launcher.application.ApplicationClassLoaderFactory;
import org.mule.module.launcher.application.ApplicationMuleContextBuilder;
import org.mule.module.launcher.application.ApplicationStatus;
import org.mule.module.launcher.application.ApplicationStatusMapper;
import org.mule.module.launcher.application.NullDeploymentListener;
import org.mule.module.launcher.artifact.ArtifactClassLoader;
import org.mule.module.launcher.artifact.MuleContextDeploymentListener;
import org.mule.module.launcher.descriptor.ApplicationDescriptor;
import org.mule.module.launcher.domain.Domain;
import org.mule.module.reboot.MuleContainerBootstrapUtils;
import org.mule.util.ClassUtils;
import org.mule.util.ExceptionUtils;
import org.mule.util.SplashScreen;

public class DefaultMuleApplication
implements Application {
    protected final transient Log logger = LogFactory.getLog(this.getClass());
    protected final transient Log deployLogger = LogFactory.getLog(MuleDeploymentService.class);
    protected final ApplicationDescriptor descriptor;
    protected final ApplicationClassLoaderFactory applicationClassLoaderFactory;
    protected MuleContext muleContext;
    protected ArtifactClassLoader deploymentClassLoader;
    private Domain domain;
    protected DeploymentListener deploymentListener;

    public DefaultMuleApplication(ApplicationDescriptor descriptor, ApplicationClassLoaderFactory applicationClassLoaderFactory, Domain domain) {
        this.descriptor = descriptor;
        this.applicationClassLoaderFactory = applicationClassLoaderFactory;
        this.deploymentListener = new NullDeploymentListener();
        this.domain = domain;
    }

    public void setDeploymentListener(DeploymentListener deploymentListener) {
        if (deploymentListener == null) {
            throw new IllegalArgumentException("Deployment listener cannot be null");
        }
        this.deploymentListener = deploymentListener;
    }

    @Override
    public void install() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)SplashScreen.miniSplash((String)String.format("New app '%s'", this.descriptor.getAppName())));
        }
        for (String configResourceAbsolutePatch : this.descriptor.getAbsoluteResourcePaths()) {
            File configResource = new File(configResourceAbsolutePatch);
            if (configResource.exists()) continue;
            String message = String.format("Config for app '%s' not found: %s", this.getArtifactName(), configResource);
            throw new InstallException(MessageFactory.createStaticMessage((String)message));
        }
        this.deploymentClassLoader = this.applicationClassLoaderFactory.create(this.descriptor);
    }

    @Override
    public ApplicationDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public Domain getDomain() {
        return this.domain;
    }

    public void setAppName(String appName) {
        this.descriptor.setAppName(appName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)SplashScreen.miniSplash((String)String.format("Starting app '%s'", this.descriptor.getAppName())));
        }
        try {
            this.muleContext.start();
            ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(null);
                this.deployLogger.info((Object)SplashScreen.miniSplash((String)String.format("Started app '%s'", this.descriptor.getAppName())));
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldCl);
            }
        }
        catch (MuleException e) {
            this.logger.error(null, ExceptionUtils.getRootCause((Throwable)e));
            throw new DeploymentStartException(CoreMessages.createStaticMessage((String)ExceptionUtils.getRootCauseMessage((Throwable)e)), e);
        }
    }

    @Override
    public void init() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)SplashScreen.miniSplash((String)String.format("Initializing app '%s'", this.descriptor.getAppName())));
        }
        try {
            ConfigurationBuilder cfgBuilder = this.domain.createApplicationConfigurationBuilder(this);
            if (!cfgBuilder.isConfigured()) {
                ArrayList<ConfigurationBuilder> builders = new ArrayList<ConfigurationBuilder>(3);
                builders.add(this.createConfigurationBuilderFromApplicationProperties());
                this.addAnnotationsConfigBuilderIfPresent(builders);
                builders.add(cfgBuilder);
                DefaultMuleContextFactory muleContextFactory = new DefaultMuleContextFactory();
                if (this.deploymentListener != null) {
                    muleContextFactory.addListener((MuleContextListener)new MuleContextDeploymentListener(this.getArtifactName(), this.deploymentListener));
                }
                ApplicationMuleContextBuilder applicationContextBuilder = new ApplicationMuleContextBuilder(this.descriptor);
                this.muleContext = muleContextFactory.createMuleContext(builders, (MuleContextBuilder)applicationContextBuilder);
            }
        }
        catch (Exception e) {
            this.logger.error(null, ExceptionUtils.getRootCause((Throwable)e));
            throw new DeploymentInitException(CoreMessages.createStaticMessage((String)ExceptionUtils.getRootCauseMessage((Throwable)e)), e);
        }
    }

    protected ConfigurationBuilder createConfigurationBuilderFromApplicationProperties() {
        Map<String, String> appProperties = this.descriptor.getAppProperties();
        File appPath = new File(MuleContainerBootstrapUtils.getMuleAppsDir(), this.getArtifactName());
        appProperties.put("app.home", appPath.getAbsolutePath());
        appProperties.put("app.name", this.getArtifactName());
        return new SimpleConfigurationBuilder(appProperties);
    }

    protected void addAnnotationsConfigBuilderIfPresent(List<ConfigurationBuilder> builders) throws Exception {
        if (ClassUtils.isClassOnPath((String)"org.mule.config.AnnotationsConfigurationBuilder", this.getClass())) {
            Object configBuilder = ClassUtils.instanciateClass((String)"org.mule.config.AnnotationsConfigurationBuilder", (Object[])ClassUtils.NO_ARGS, this.getClass());
            builders.add((ConfigurationBuilder)configBuilder);
        }
    }

    @Override
    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        try {
            ClassLoader appCl = null;
            if (this.getArtifactClassLoader() != null) {
                appCl = this.getArtifactClassLoader().getClassLoader();
            }
            if (appCl != null) {
                Thread.currentThread().setContextClassLoader(appCl);
            }
            this.doDispose();
            if (appCl != null && appCl instanceof DisposableClassLoader) {
                ((DisposableClassLoader)((Object)appCl)).dispose();
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(null);
        }
    }

    @Override
    public String getArtifactName() {
        return this.descriptor.getAppName();
    }

    @Override
    public File[] getResourceFiles() {
        return this.descriptor.getConfigResourcesFile();
    }

    @Override
    public ArtifactClassLoader getArtifactClassLoader() {
        return this.deploymentClassLoader;
    }

    @Override
    public void stop() {
        if (this.muleContext == null || !this.muleContext.getLifecycleManager().isDirectTransition("stop")) {
            return;
        }
        if (this.muleContext == null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)String.format("Stopping app '%s' with no mule context", this.descriptor.getAppName()));
            }
            return;
        }
        this.muleContext.getLifecycleManager().checkPhase("stop");
        try {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)SplashScreen.miniSplash((String)String.format("Stopping app '%s'", this.descriptor.getAppName())));
            }
            this.muleContext.stop();
        }
        catch (MuleException e) {
            throw new DeploymentStopException(MessageFactory.createStaticMessage((String)this.descriptor.getAppName()), e);
        }
    }

    @Override
    public ApplicationStatus getStatus() {
        if (this.muleContext != null) {
            return ApplicationStatusMapper.getApplicationStatus(this.muleContext.getLifecycleManager().getCurrentPhase());
        }
        return ApplicationStatusMapper.getApplicationStatus("not in lifecycle");
    }

    public String toString() {
        return String.format("%s[%s]@%s", this.getClass().getName(), this.descriptor.getAppName(), Integer.toHexString(System.identityHashCode(this)));
    }

    protected void doDispose() {
        if (this.muleContext == null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)String.format("App '%s' never started, nothing to dispose of", this.descriptor.getAppName()));
            }
            return;
        }
        if (this.muleContext.isStarted() && !this.muleContext.isDisposed()) {
            try {
                this.stop();
            }
            catch (DeploymentStopException e) {
                this.logger.error((Object)e);
            }
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)SplashScreen.miniSplash((String)String.format("Disposing app '%s'", this.descriptor.getAppName())));
        }
        this.muleContext.dispose();
        this.muleContext = null;
    }
}

