/*
 * Decompiled with CFR 0.152.
 */
package org.mule.common.metadata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mule.common.metadata.AbstractMetaDataModel;
import org.mule.common.metadata.DefaultMetaDataField;
import org.mule.common.metadata.DefaultSimpleMetaDataModel;
import org.mule.common.metadata.DefinedMapMetaDataModel;
import org.mule.common.metadata.MetaDataField;
import org.mule.common.metadata.MetaDataModel;
import org.mule.common.metadata.MetaDataModelVisitor;
import org.mule.common.metadata.datatype.DataType;

public class DefaultDefinedMapMetaDataModel
extends AbstractMetaDataModel
implements DefinedMapMetaDataModel {
    private List<MetaDataField> fields;
    private String name;

    @Deprecated
    public DefaultDefinedMapMetaDataModel(Map<String, ? extends MetaDataModel> metaDataModelMap, String name) {
        super(DataType.MAP);
        this.fields = this.convertMapToList(metaDataModelMap);
        this.name = name;
    }

    @Deprecated
    public DefaultDefinedMapMetaDataModel(Map<String, ? extends MetaDataModel> metaDataModelMap) {
        this(metaDataModelMap, null);
    }

    public DefaultDefinedMapMetaDataModel(List<MetaDataField> fields, String name) {
        super(DataType.MAP);
        this.fields = fields;
        this.name = name;
    }

    public DefaultDefinedMapMetaDataModel(List<MetaDataField> fields) {
        this(fields, null);
    }

    private List<MetaDataField> convertMapToList(Map<String, ? extends MetaDataModel> metaDataModelMap) {
        ArrayList<MetaDataField> mappedFields = new ArrayList<MetaDataField>();
        for (Map.Entry<String, ? extends MetaDataModel> entry : metaDataModelMap.entrySet()) {
            mappedFields.add(new DefaultMetaDataField(entry.getKey(), entry.getValue()));
        }
        return mappedFields;
    }

    @Override
    public Set<String> getKeys() {
        HashSet<String> result = new HashSet<String>();
        for (MetaDataField mdf : this.getFields()) {
            result.add(mdf.getName());
        }
        return result;
    }

    @Override
    public MetaDataModel getKeyMetaDataModel() {
        return new DefaultSimpleMetaDataModel(DataType.STRING);
    }

    @Override
    public MetaDataModel getValueMetaDataModel(String key) {
        for (MetaDataField mdf : this.getFields()) {
            if (!mdf.getName().equals(key)) continue;
            return mdf.getMetaDataModel();
        }
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<MetaDataField> getFields() {
        return Collections.unmodifiableList(this.fields);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.fields == null ? 0 : ((Object)this.fields).hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof DefaultDefinedMapMetaDataModel)) {
            return false;
        }
        DefaultDefinedMapMetaDataModel other = (DefaultDefinedMapMetaDataModel)obj;
        if (this.fields == null ? other.fields != null : !((Object)this.fields).equals(other.fields)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    @Override
    public void accept(MetaDataModelVisitor modelVisitor) {
        modelVisitor.visitDynamicMapModel(this);
    }
}

