/*
 * Decompiled with CFR 0.152.
 */
package com.envoisolutions.sxc.util;

import com.envoisolutions.sxc.util.XPathAssert;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import junit.framework.TestCase;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class XoTestCase
extends TestCase {
    private static String basedirPath;
    private Map<String, String> namespaces = new HashMap<String, String>();

    public void setUp() throws Exception {
        this.addNamespace("s", "http://schemas.xmlsoap.org/soap/envelope/");
        this.addNamespace("xsd", "http://www.w3.org/2001/XMLSchema");
        this.addNamespace("wsdl", "http://schemas.xmlsoap.org/wsdl/");
        this.addNamespace("wsdlsoap", "http://schemas.xmlsoap.org/wsdl/soap/");
        this.addNamespace("soap", "http://schemas.xmlsoap.org/soap/");
        this.addNamespace("soap12env", "http://www.w3.org/2003/05/soap-envelope");
        this.addNamespace("xml", "http://www.w3.org/XML/1998/namespace");
    }

    protected XMLStreamReader getXSR(String string) throws XMLStreamException {
        ByteArrayInputStream bis = new ByteArrayInputStream(string.getBytes());
        return XMLInputFactory.newInstance().createXMLStreamReader(bis);
    }

    protected XMLStreamReader getXSR(InputStream is) throws XMLStreamException {
        return XMLInputFactory.newInstance().createXMLStreamReader(is);
    }

    public Document readDocument(byte[] b) throws SAXException, IOException, ParserConfigurationException {
        return XoTestCase.readXml(new ByteArrayInputStream(b));
    }

    public static Document readXml(InputStream is) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(false);
        dbf.setIgnoringComments(false);
        dbf.setIgnoringElementContentWhitespace(true);
        dbf.setNamespaceAware(true);
        DocumentBuilder db = null;
        db = dbf.newDocumentBuilder();
        db.setEntityResolver(new NullResolver());
        return db.parse(is);
    }

    public NodeList assertValid(String xpath, Node node) throws Exception {
        return XPathAssert.assertValid(xpath, node, this.namespaces);
    }

    public NodeList assertInvalid(String xpath, Node node) throws Exception {
        return XPathAssert.assertInvalid(xpath, node, this.namespaces);
    }

    public void assertXPathEquals(String xpath, String value, Node node) throws Exception {
        XPathAssert.assertXPathEquals(xpath, value, node, this.namespaces);
    }

    public void assertNoFault(Node node) throws Exception {
        XPathAssert.assertNoFault(node);
    }

    public void addNamespace(String ns, String uri) {
        this.namespaces.put(ns, uri);
    }

    protected InputStream getResourceAsStream(String resource) {
        return ((Object)((Object)this)).getClass().getResourceAsStream(resource);
    }

    protected Reader getResourceAsReader(String resource) {
        return new InputStreamReader(this.getResourceAsStream(resource));
    }

    public File getTestFile(String relativePath) {
        return new File(XoTestCase.getBasedir(), relativePath);
    }

    public static String getBasedir() {
        if (basedirPath != null) {
            return basedirPath;
        }
        basedirPath = System.getProperty("basedir");
        if (basedirPath == null) {
            basedirPath = new File("").getAbsolutePath();
        }
        return basedirPath;
    }

    public static class NullResolver
    implements EntityResolver {
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            return new InputSource(new StringReader(""));
        }
    }
}

