/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.cal;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import org.jbpm.pvm.internal.cal.BusinessCalendarImpl;
import org.jbpm.pvm.internal.cal.Day;

public class DayPart
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected long oid = -1L;
    protected int version = 0;
    protected int fromHour = -1;
    protected int fromMinute = -1;
    protected int toHour = -1;
    protected int toMinute = -1;
    protected Day day = null;
    protected int index = -1;

    public Date add(Date date, long millis, boolean isBusinessTime) {
        Date end = null;
        BusinessCalendarImpl businessCalendarImpl = this.day.getBusinessCalendar();
        Calendar calendar = businessCalendarImpl.createCalendar();
        calendar.setTime(date);
        int hour = calendar.get(11);
        int minute = calendar.get(12);
        long dateMilliseconds = (hour * 60 + minute) * 60 * 1000;
        long dayPartEndMilleseconds = (this.toHour * 60 + this.toMinute) * 60 * 1000;
        long millisecondsInThisDayPart = dayPartEndMilleseconds - dateMilliseconds;
        if (millis <= millisecondsInThisDayPart) {
            end = new Date(date.getTime() + millis);
        } else {
            long remainderMillis = millis - millisecondsInThisDayPart;
            Date dayPartEndDate = new Date(date.getTime() + millis - remainderMillis);
            Object[] result = new Object[2];
            this.day.findNextDayPartStart(this.index + 1, dayPartEndDate, result);
            Date nextDayPartStart = (Date)result[0];
            DayPart nextDayPart = (DayPart)result[1];
            end = nextDayPart.add(nextDayPartStart, remainderMillis, isBusinessTime);
        }
        return end;
    }

    public boolean isStartAfter(Date date) {
        Calendar calendar = this.day.getBusinessCalendar().createCalendar();
        calendar.setTime(date);
        int hour = calendar.get(11);
        int minute = calendar.get(12);
        return hour < this.fromHour || hour == this.fromHour && minute <= this.fromMinute;
    }

    public boolean includes(Date date) {
        Calendar calendar = this.day.getBusinessCalendar().createCalendar();
        calendar.setTime(date);
        int hour = calendar.get(11);
        int minute = calendar.get(12);
        return (this.fromHour < hour || this.fromHour == hour && this.fromMinute <= minute) && (hour < this.toHour || hour == this.toHour && minute <= this.toMinute);
    }

    public Date getStartTime(Date date) {
        Calendar calendar = this.day.getBusinessCalendar().createCalendar();
        calendar.setTime(date);
        calendar.set(11, this.fromHour);
        calendar.set(12, this.fromMinute);
        return calendar.getTime();
    }

    public Day getDay() {
        return this.day;
    }

    public void setDay(Day day) {
        this.day = day;
    }

    public int getFromHour() {
        return this.fromHour;
    }

    public void setFromHour(int fromHour) {
        this.fromHour = fromHour;
    }

    public int getFromMinute() {
        return this.fromMinute;
    }

    public void setFromMinute(int fromMinute) {
        this.fromMinute = fromMinute;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getToHour() {
        return this.toHour;
    }

    public void setToHour(int toHour) {
        this.toHour = toHour;
    }

    public int getToMinute() {
        return this.toMinute;
    }

    public void setToMinute(int toMinute) {
        this.toMinute = toMinute;
    }
}

