/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.el;

import java.io.Serializable;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ExpressionFactory;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import org.jbpm.api.Execution;
import org.jbpm.api.JbpmException;
import org.jbpm.api.task.Task;
import org.jbpm.pvm.internal.el.JbpmElFactory;
import org.jbpm.pvm.internal.el.ScriptExpression;
import org.jbpm.pvm.internal.el.StaticTextExpression;
import org.jbpm.pvm.internal.el.UelMethodExpression;
import org.jbpm.pvm.internal.el.UelValueExpression;
import org.jbpm.pvm.internal.model.ScopeInstanceImpl;

public abstract class Expression
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String LANGUAGE_UEL = "uel";
    public static final String LANGUAGE_UEL_METHOD = "uel-method";
    public static final String LANGUAGE_UEL_VALUE = "uel-value";
    private static ExpressionFactory expressionFactory;
    private static ELContext elContext;

    public static Expression create(String expressionText) {
        return Expression.create(expressionText, null);
    }

    public static Expression create(String expressionText, String language) {
        if (expressionText == null) {
            throw new JbpmException("expressionText is null");
        }
        if (language == null || language.startsWith(LANGUAGE_UEL)) {
            block7: {
                if (expressionText.indexOf(123) == -1) {
                    return new StaticTextExpression(expressionText);
                }
                Expression.initExpressionObjects();
                if (language == null || LANGUAGE_UEL_VALUE.equals(language)) {
                    try {
                        ValueExpression valueExpression = expressionFactory.createValueExpression(elContext, expressionText, Object.class);
                        return new UelValueExpression(valueExpression);
                    }
                    catch (ELException e) {
                        if (language != null) break block7;
                        language = LANGUAGE_UEL_METHOD;
                    }
                }
            }
            if (LANGUAGE_UEL_METHOD.equals(language)) {
                MethodExpression methodExpression = expressionFactory.createMethodExpression(elContext, expressionText, null, new Class[0]);
                return new UelMethodExpression(methodExpression);
            }
        }
        return new ScriptExpression(expressionText, language);
    }

    protected static synchronized void initExpressionObjects() {
        if (elContext == null) {
            JbpmElFactory jbpmElFactory = JbpmElFactory.getJbpmElFactory();
            expressionFactory = jbpmElFactory.createExpressionFactory();
            elContext = jbpmElFactory.createElContext();
        }
    }

    public Object evaluate() {
        return this.evaluateInScope(null);
    }

    public Object evaluate(Execution execution) {
        return this.evaluateInScope((ScopeInstanceImpl)execution);
    }

    public Object evaluate(Task task) {
        return this.evaluateInScope((ScopeInstanceImpl)task);
    }

    public abstract Object evaluateInScope(ScopeInstanceImpl var1);

    protected ELContext getElContext(ScopeInstanceImpl scopeInstance) {
        if (scopeInstance == null) {
            return JbpmElFactory.getJbpmElFactory().createElContext();
        }
        ELContext elContext = (ELContext)scopeInstance.getElContext();
        if (elContext == null) {
            elContext = JbpmElFactory.getJbpmElFactory().createElContext(scopeInstance);
            scopeInstance.setElContext(elContext);
        }
        return elContext;
    }

    public abstract String getExpressionString();

    public abstract boolean isLiteralText();
}

