/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal.capability.xml.schema;

import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.TypeElement;
import org.mule.extension.introspection.DescribingContext;
import org.mule.extension.introspection.spi.DescriberPostProcessor;
import org.mule.module.extension.internal.capability.xml.schema.SchemaDocumenter;
import org.mule.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SchemaDocumenterPostProcessor
implements DescriberPostProcessor {
    private static Logger logger = LoggerFactory.getLogger(SchemaDocumenterPostProcessor.class);

    public void postProcess(DescribingContext context) {
        ProcessingEnvironment processingEnv = this.getCheckedParameter(context, "PROCESSING_ENVIRONMENT", ProcessingEnvironment.class);
        TypeElement extensionElement = this.getCheckedParameter(context, "EXTENSION_ELEMENT", TypeElement.class);
        RoundEnvironment roundEnvironment = this.getCheckedParameter(context, "ROUND_ENVIRONMENT", RoundEnvironment.class);
        if (processingEnv == null || extensionElement == null) {
            logger.debug("processing environment or extension element not provided. Skipping");
            return;
        }
        new SchemaDocumenter(processingEnv).document(context.getDeclarationConstruct().getDeclaration(), extensionElement, roundEnvironment);
    }

    private <T> T getCheckedParameter(DescribingContext context, String key, Class<T> expectedType) {
        Object parameter = context.getCustomParameters().get(key);
        if (parameter == null) {
            return null;
        }
        Preconditions.checkArgument((boolean)expectedType.isInstance(parameter), (String)String.format("Custom parameter '%s' was expected to be of class '%s' but got '%s' instead", key, expectedType.getName(), parameter.getClass().getName()));
        return (T)parameter;
    }
}

