/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import java.util.Collections;
import java.util.HashMap;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsNot;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.Transformer;
import org.mule.api.transport.PropertyScope;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.matcher.DataTypeMatcher;
import org.mule.tck.size.SmallTest;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.transport.NullPayload;

@SmallTest
public class MuleMessageDataTypePropagationTestCase
extends AbstractMuleTestCase {
    public static final String DEFAULT_ENCODING = "UTF-8";
    public static final String CUSTOM_ENCODING = "UTF-16";
    public static final String TEST_PROPERTY = "testProperty";
    public static final String TEST = "test";
    public static final String CUSTOM_MIME_TYPE = "text/plain";
    public static final String CUSTOM_CONTENT_TYPE = "text/plain; charset=UTF-16";
    private MuleContext muleContext = (MuleContext)Mockito.mock(MuleContext.class, (Answer)Mockito.RETURNS_DEEP_STUBS);

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.muleContext.getConfiguration().getDefaultEncoding()).thenReturn((Object)DEFAULT_ENCODING);
    }

    @Test
    public void usesDefaultEncodingWithNoProperty() throws Exception {
        DefaultMuleMessage muleMessage = new DefaultMuleMessage((Object)TEST, this.muleContext);
        MatcherAssert.assertThat((Object)muleMessage.getEncoding(), (Matcher)Matchers.equalTo((Object)DEFAULT_ENCODING));
        MatcherAssert.assertThat((Object)muleMessage.getPropertyNames(), (Matcher)IsNot.not((Matcher)Matchers.hasItem((Object)"MULE_ENCODING")));
    }

    @Test
    public void usesCustomEncodingWithProperty() throws Exception {
        DefaultMuleMessage muleMessage = new DefaultMuleMessage((Object)TEST, this.muleContext);
        muleMessage.setEncoding(CUSTOM_ENCODING);
        MatcherAssert.assertThat((Object)muleMessage.getEncoding(), (Matcher)Matchers.equalTo((Object)CUSTOM_ENCODING));
    }

    @Test
    public void updatesEncodingWithPropertyAndScope() throws Exception {
        DefaultMuleMessage muleMessage = new DefaultMuleMessage((Object)TEST, this.muleContext);
        muleMessage.setProperty("MULE_ENCODING", (Object)CUSTOM_ENCODING, PropertyScope.OUTBOUND);
        MatcherAssert.assertThat((Object)muleMessage.getEncoding(), (Matcher)Matchers.equalTo((Object)CUSTOM_ENCODING));
        MatcherAssert.assertThat((Object)muleMessage.getPropertyNames(), (Matcher)Matchers.hasItem((Object)"MULE_ENCODING"));
        MatcherAssert.assertThat((Object)muleMessage.getProperty("MULE_ENCODING"), (Matcher)Matchers.equalTo((Object)CUSTOM_ENCODING));
    }

    @Test
    public void updatesEncodingWithProperty() throws Exception {
        DefaultMuleMessage muleMessage = new DefaultMuleMessage((Object)TEST, this.muleContext);
        muleMessage.setProperty("MULE_ENCODING", (Object)CUSTOM_ENCODING);
        MatcherAssert.assertThat((Object)muleMessage.getEncoding(), (Matcher)Matchers.equalTo((Object)CUSTOM_ENCODING));
        MatcherAssert.assertThat((Object)muleMessage.getPropertyNames(), (Matcher)Matchers.hasItem((Object)"MULE_ENCODING"));
        MatcherAssert.assertThat((Object)muleMessage.getProperty("MULE_ENCODING"), (Matcher)Matchers.equalTo((Object)CUSTOM_ENCODING));
    }

    @Test
    public void setsDefaultDataTypeOnCreation() throws Exception {
        this.assertDefaultDataType((MuleMessage)new DefaultMuleMessage((Object)TEST, this.muleContext));
        this.assertDefaultDataType((MuleMessage)new DefaultMuleMessage((Object)TEST, Collections.emptyMap(), this.muleContext));
        this.assertDefaultDataType((MuleMessage)new DefaultMuleMessage((Object)TEST, Collections.emptyMap(), Collections.emptyMap(), this.muleContext));
        this.assertDefaultDataType((MuleMessage)new DefaultMuleMessage((Object)TEST, Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), this.muleContext));
    }

    @Test
    public void setsDataTypeFromPreviousMessageOnCreation() throws Exception {
        DefaultMuleMessage previousMuleMessage = new DefaultMuleMessage((Object)1, this.muleContext);
        DataType dataType = DataTypeFactory.create(Long.class, (String)"application/xml");
        dataType.setEncoding(CUSTOM_ENCODING);
        previousMuleMessage.setDataType(dataType);
        this.assertDataType((MuleMessage)new DefaultMuleMessage((MuleMessage)previousMuleMessage), previousMuleMessage.getDataType());
    }

    @Test
    public void overridesDataTypeFromPreviousMessageOnCreation() throws Exception {
        DefaultMuleMessage previousMuleMessage = new DefaultMuleMessage((Object)1, this.muleContext);
        previousMuleMessage.setEncoding(CUSTOM_ENCODING);
        previousMuleMessage.setMimeType("application/xml");
        this.assertDataType((MuleMessage)new DefaultMuleMessage((Object)TEST, (MuleMessage)previousMuleMessage, this.muleContext), String.class, "application/xml", CUSTOM_ENCODING);
    }

    @Test
    public void updatesDataTypeWhenPayloadIsNullified() throws Exception {
        DefaultMuleMessage muleMessage = new DefaultMuleMessage((Object)TEST, this.muleContext);
        muleMessage.setEncoding(CUSTOM_ENCODING);
        muleMessage.setMimeType("application/xml");
        muleMessage.setPayload(null);
        this.assertDataType((MuleMessage)muleMessage, Object.class, "application/xml", CUSTOM_ENCODING);
    }

    @Test
    public void setsNullPayloadWithDataType() throws Exception {
        DefaultMuleMessage muleMessage = new DefaultMuleMessage((Object)TEST, this.muleContext);
        DataType newDataType = DataTypeFactory.create(Integer.class, (String)"application/xml");
        newDataType.setEncoding(CUSTOM_ENCODING);
        muleMessage.setPayload(null, newDataType);
        MatcherAssert.assertThat((Object)muleMessage.getPayload(), (Matcher)Matchers.equalTo((Object)NullPayload.getInstance()));
        this.assertDataType((MuleMessage)muleMessage, Integer.class, "application/xml", CUSTOM_ENCODING);
    }

    @Test
    public void setsPayloadWithDataType() throws Exception {
        DefaultMuleMessage muleMessage = new DefaultMuleMessage((Object)TEST, this.muleContext);
        DataType newDataType = DataTypeFactory.create(Integer.class, (String)"application/xml");
        newDataType.setEncoding(CUSTOM_ENCODING);
        muleMessage.setPayload((Object)TEST, newDataType);
        MatcherAssert.assertThat((Object)muleMessage.getPayload(), (Matcher)Matchers.equalTo((Object)TEST));
        this.assertDataType((MuleMessage)muleMessage, Integer.class, "application/xml", CUSTOM_ENCODING);
    }

    @Test
    public void updatesDataTypeWhenPayloadChanges() throws Exception {
        DefaultMuleMessage muleMessage = new DefaultMuleMessage((Object)TEST, this.muleContext);
        muleMessage.setEncoding(CUSTOM_ENCODING);
        muleMessage.setMimeType("application/xml");
        muleMessage.setPayload((Object)1);
        this.assertDataType((MuleMessage)muleMessage, Integer.class, "application/xml", CUSTOM_ENCODING);
    }

    @Test
    public void updatesTypeOnTransformation() throws Exception {
        DefaultMuleMessage muleMessage = new DefaultMuleMessage((Object)TEST, this.muleContext);
        muleMessage.setMimeType("application/xml");
        Transformer transformer = (Transformer)Mockito.mock(Transformer.class);
        Mockito.when((Object)transformer.isSourceDataTypeSupported((DataType)org.mockito.Matchers.any())).thenReturn((Object)true);
        DataType outputDataType = DataTypeFactory.create(Integer.class, (String)"*/*");
        outputDataType.setEncoding(null);
        Mockito.when((Object)transformer.getReturnDataType()).thenReturn((Object)outputDataType);
        MuleEvent muleEvent = (MuleEvent)Mockito.mock(MuleEvent.class);
        muleMessage.applyAllTransformers(muleEvent, Collections.singletonList(transformer));
        this.assertDataType((MuleMessage)muleMessage, Integer.class, "application/xml", DEFAULT_ENCODING);
    }

    @Test
    public void updatesEncodingOnTransformation() throws Exception {
        DefaultMuleMessage muleMessage = new DefaultMuleMessage((Object)TEST, this.muleContext);
        muleMessage.setMimeType("application/xml");
        Transformer transformer = (Transformer)Mockito.mock(Transformer.class);
        Mockito.when((Object)transformer.isSourceDataTypeSupported((DataType)org.mockito.Matchers.any())).thenReturn((Object)true);
        DataType outputDataType = DataTypeFactory.create(Integer.class, null);
        outputDataType.setEncoding(CUSTOM_ENCODING);
        Mockito.when((Object)transformer.getReturnDataType()).thenReturn((Object)outputDataType);
        MuleEvent muleEvent = (MuleEvent)Mockito.mock(MuleEvent.class);
        muleMessage.applyAllTransformers(muleEvent, Collections.singletonList(transformer));
        this.assertDataType((MuleMessage)muleMessage, Integer.class, "application/xml", CUSTOM_ENCODING);
    }

    @Test
    public void updatesMimeTypeOnTransformation() throws Exception {
        DefaultMuleMessage muleMessage = new DefaultMuleMessage((Object)TEST, this.muleContext);
        muleMessage.setMimeType("*/*");
        muleMessage.setEncoding(CUSTOM_ENCODING);
        Transformer transformer = (Transformer)Mockito.mock(Transformer.class);
        Mockito.when((Object)transformer.isSourceDataTypeSupported((DataType)org.mockito.Matchers.any())).thenReturn((Object)true);
        DataType outputDataType = DataTypeFactory.create(Integer.class, (String)"application/xml");
        outputDataType.setEncoding(null);
        Mockito.when((Object)transformer.getReturnDataType()).thenReturn((Object)outputDataType);
        MuleEvent muleEvent = (MuleEvent)Mockito.mock(MuleEvent.class);
        muleMessage.applyAllTransformers(muleEvent, Collections.singletonList(transformer));
        this.assertDataType((MuleMessage)muleMessage, Integer.class, "application/xml", CUSTOM_ENCODING);
    }

    @Test
    public void maintainsCurrentDataTypeClassWhenTransformerOutputTypeIsObject() throws Exception {
        DefaultMuleMessage muleMessage = new DefaultMuleMessage((Object)TEST, this.muleContext);
        DataType originalDataType = muleMessage.getDataType();
        Transformer transformer = (Transformer)Mockito.mock(Transformer.class);
        Mockito.when((Object)transformer.isSourceDataTypeSupported((DataType)org.mockito.Matchers.any())).thenReturn((Object)true);
        DataType outputDataType = DataTypeFactory.create(Object.class, (String)"*/*");
        Mockito.when((Object)transformer.getReturnDataType()).thenReturn((Object)outputDataType);
        Mockito.when((Object)transformer.transform((Object)muleMessage)).thenReturn((Object)TEST);
        MuleEvent muleEvent = (MuleEvent)Mockito.mock(MuleEvent.class);
        muleMessage.applyAllTransformers(muleEvent, Collections.singletonList(transformer));
        this.assertDataType((MuleMessage)muleMessage, originalDataType);
    }

    @Test
    public void setsDataType() throws Exception {
        DataType dataType = DataTypeFactory.create(Integer.class);
        DefaultMuleMessage muleMessage = new DefaultMuleMessage((Object)TEST, this.muleContext);
        muleMessage.setDataType(dataType);
        MatcherAssert.assertThat((Object)muleMessage.getDataType(), DataTypeMatcher.like(dataType));
    }

    @Test
    public void setsDefaultPropertyDataType() throws Exception {
        DefaultMuleMessage muleMessage = new DefaultMuleMessage((Object)TEST, this.muleContext);
        muleMessage.setProperty(TEST_PROPERTY, (Object)TEST);
        this.assertDefaultPropertyDataType(muleMessage, PropertyScope.OUTBOUND);
    }

    @Test
    public void setsDefaultOutboundPropertyDataType() throws Exception {
        DefaultMuleMessage muleMessage = new DefaultMuleMessage((Object)TEST, this.muleContext);
        muleMessage.setOutboundProperty(TEST_PROPERTY, (Object)TEST);
        this.assertDefaultPropertyDataType(muleMessage, PropertyScope.OUTBOUND);
    }

    @Test
    public void setsCustomOutboundPropertyDataType() throws Exception {
        DefaultMuleMessage muleMessage = new DefaultMuleMessage((Object)TEST, this.muleContext);
        DataType dataType = DataTypeFactory.create(String.class, (String)"application/xml");
        dataType.setEncoding(CUSTOM_ENCODING);
        muleMessage.setOutboundProperty(TEST_PROPERTY, (Object)TEST, dataType);
        this.assertPropertyDataType(muleMessage, PropertyScope.OUTBOUND, dataType);
    }

    @Test
    public void setsDefaultOutboundScopePropertyDataType() throws Exception {
        DefaultMuleMessage muleMessage = new DefaultMuleMessage((Object)TEST, this.muleContext);
        muleMessage.setProperty(TEST_PROPERTY, (Object)TEST, PropertyScope.OUTBOUND);
        this.assertDefaultPropertyDataType(muleMessage, PropertyScope.OUTBOUND);
    }

    @Test
    public void setsDefaultInboundPropertyDataType() throws Exception {
        DefaultMuleMessage muleMessage = new DefaultMuleMessage((Object)TEST, this.muleContext);
        muleMessage.setInboundProperty(TEST_PROPERTY, (Object)TEST);
        this.assertDefaultPropertyDataType(muleMessage, PropertyScope.INBOUND);
    }

    @Test
    public void setsCustomInboundPropertyDataType() throws Exception {
        DefaultMuleMessage muleMessage = new DefaultMuleMessage((Object)TEST, this.muleContext);
        DataType dataType = DataTypeFactory.create(String.class, (String)"application/xml");
        dataType.setEncoding(CUSTOM_ENCODING);
        muleMessage.setInboundProperty(TEST_PROPERTY, (Object)TEST, dataType);
        this.assertPropertyDataType(muleMessage, PropertyScope.INBOUND, dataType);
    }

    @Test
    public void setsDefaultInboundScopePropertyDataType() throws Exception {
        DefaultMuleMessage muleMessage = new DefaultMuleMessage((Object)TEST, this.muleContext);
        muleMessage.setProperty(TEST_PROPERTY, (Object)TEST, PropertyScope.INBOUND);
        this.assertDefaultPropertyDataType(muleMessage, PropertyScope.INBOUND);
    }

    @Test
    public void setsDefaultInvocationPropertyDataType() throws Exception {
        DefaultMuleMessage muleMessage = new DefaultMuleMessage((Object)TEST, this.muleContext);
        muleMessage.setInvocationProperty(TEST_PROPERTY, (Object)TEST);
        this.assertDefaultPropertyDataType(muleMessage, PropertyScope.INVOCATION);
    }

    @Test
    public void setsCustomInvocationPropertyDataType() throws Exception {
        DefaultMuleMessage muleMessage = new DefaultMuleMessage((Object)TEST, this.muleContext);
        DataType dataType = DataTypeFactory.create(String.class, (String)"application/xml");
        dataType.setEncoding(CUSTOM_ENCODING);
        muleMessage.setInvocationProperty(TEST_PROPERTY, (Object)TEST, dataType);
        this.assertPropertyDataType(muleMessage, PropertyScope.INVOCATION, dataType);
    }

    @Test
    public void setsDefaultInvocationScopePropertyDataType() throws Exception {
        DefaultMuleMessage muleMessage = new DefaultMuleMessage((Object)TEST, this.muleContext);
        muleMessage.setProperty(TEST_PROPERTY, (Object)TEST, PropertyScope.INVOCATION);
        this.assertDefaultPropertyDataType(muleMessage, PropertyScope.INVOCATION);
    }

    @Test
    public void setsDefaultSessionPropertyDataType() throws Exception {
        DefaultMuleMessage muleMessage = new DefaultMuleMessage((Object)TEST, this.muleContext);
        muleMessage.setSessionProperties(new HashMap());
        muleMessage.setProperty(TEST_PROPERTY, (Object)TEST, PropertyScope.SESSION);
        this.assertDefaultPropertyDataType(muleMessage, PropertyScope.SESSION);
    }

    @Test
    public void setsDataTypeWhenCreatesInboundMessage() throws Exception {
        DefaultMuleMessage muleMessage = new DefaultMuleMessage((Object)TEST, this.muleContext);
        DataType dataType = DataTypeFactory.create(String.class, (String)"application/xml");
        dataType.setEncoding(CUSTOM_ENCODING);
        muleMessage.setProperty(TEST_PROPERTY, (Object)TEST, PropertyScope.OUTBOUND, dataType);
        DefaultMuleMessage inboundMessage = (DefaultMuleMessage)muleMessage.createInboundMessage();
        this.assertPropertyDataType(inboundMessage, PropertyScope.INBOUND, dataType);
    }

    @Test
    public void setsCustomPropertyDataType() throws Exception {
        DefaultMuleMessage muleMessage = new DefaultMuleMessage((Object)TEST, this.muleContext);
        DataType dataType = DataTypeFactory.create(String.class, (String)"application/xml");
        dataType.setEncoding(CUSTOM_ENCODING);
        muleMessage.setProperty(TEST_PROPERTY, (Object)TEST, PropertyScope.OUTBOUND, dataType);
        this.assertPropertyDataType(muleMessage, PropertyScope.OUTBOUND, dataType);
    }

    @Test
    public void updatesDataTypeWithContentTypeProperty() throws Exception {
        DefaultMuleMessage muleMessage = new DefaultMuleMessage((Object)TEST, this.muleContext);
        muleMessage.setProperty("Content-Type", (Object)CUSTOM_CONTENT_TYPE);
        this.assertDataType((MuleMessage)muleMessage, String.class, CUSTOM_MIME_TYPE, CUSTOM_ENCODING);
    }

    @Test
    public void updatesDataTypeWithContentTypePropertyAndScope() throws Exception {
        DefaultMuleMessage muleMessage = new DefaultMuleMessage((Object)TEST, this.muleContext);
        muleMessage.setProperty("Content-Type", (Object)CUSTOM_CONTENT_TYPE, PropertyScope.OUTBOUND);
        this.assertDataType((MuleMessage)muleMessage, String.class, CUSTOM_MIME_TYPE, CUSTOM_ENCODING);
    }

    @Test
    public void updatesDataTypeWithContentTypeInProperties() throws Exception {
        DefaultMuleMessage muleMessage = new DefaultMuleMessage((Object)TEST, this.muleContext);
        muleMessage.addProperties(Collections.singletonMap("Content-Type", CUSTOM_CONTENT_TYPE));
        this.assertDataType((MuleMessage)muleMessage, String.class, CUSTOM_MIME_TYPE, CUSTOM_ENCODING);
    }

    @Test
    public void updatesDataTypeWithContentTypeInInboundProperties() throws Exception {
        DefaultMuleMessage muleMessage = new DefaultMuleMessage((Object)TEST, this.muleContext);
        muleMessage.addInboundProperties(Collections.singletonMap("Content-Type", CUSTOM_CONTENT_TYPE));
        this.assertDataType((MuleMessage)muleMessage, String.class, CUSTOM_MIME_TYPE, CUSTOM_ENCODING);
    }

    private void assertDefaultDataType(MuleMessage muleMessage) {
        this.assertDataType(muleMessage, String.class, "*/*", DEFAULT_ENCODING);
    }

    private void assertDataType(MuleMessage muleMessage, Class type, String mimeType, String encoding) {
        MatcherAssert.assertThat((Object)muleMessage.getDataType(), DataTypeMatcher.like(type, mimeType, encoding));
    }

    private void assertDataType(MuleMessage muleMessage, DataType<?> dataType) {
        MatcherAssert.assertThat((Object)muleMessage.getDataType(), DataTypeMatcher.like(dataType));
    }

    private void assertDefaultPropertyDataType(DefaultMuleMessage muleMessage, PropertyScope scope) {
        this.assertPropertyDataType(muleMessage, scope, DataType.STRING_DATA_TYPE);
    }

    private void assertPropertyDataType(DefaultMuleMessage muleMessage, PropertyScope scope, DataType dataType) {
        DataType actualDataType = muleMessage.getPropertyDataType(TEST_PROPERTY, scope);
        MatcherAssert.assertThat((Object)actualDataType, DataTypeMatcher.like(dataType));
    }
}

