/*
 * Decompiled with CFR 0.152.
 */
package org.mule.el.context;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.activation.DataHandler;
import org.apache.commons.collections.keyvalue.DefaultMapEntry;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.transport.PropertyScope;
import org.mule.el.context.AbstractELTestCase;

public class MessagePropertiesTestCase
extends AbstractELTestCase {
    public MessagePropertiesTestCase(AbstractELTestCase.Variant variant, String mvelOptimizer) {
        super(variant, mvelOptimizer);
    }

    @Test
    public void inboundPropertyMap() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        message.setProperty("foo", (Object)"bar", PropertyScope.INBOUND);
        Assert.assertTrue((boolean)(this.evaluate("message.inboundProperties", (MuleMessage)message) instanceof Map));
    }

    @Test
    public void assignToInboundPropertyMap() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        this.assertFinalProperty("message.inboundProperties='foo'", (MuleMessage)message);
    }

    @Test
    public void inboundProperty() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        message.setProperty("foo", (Object)"bar", PropertyScope.INBOUND);
        Assert.assertEquals((Object)"bar", (Object)this.evaluate("message.inboundProperties['foo']", (MuleMessage)message));
    }

    @Test
    public void assignValueToInboundProperty() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        message.setProperty("foo", (Object)"bar", PropertyScope.INBOUND);
        this.assertUnsupportedOperation("message.inboundProperties['foo']='bar'", (MuleMessage)message);
    }

    @Test
    public void assignValueToNewInboundProperty() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        this.assertUnsupportedOperation("message.inboundProperties['foo_new']='bar'", (MuleMessage)message);
    }

    @Test
    public void outboundPropertyMap() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        message.setProperty("foo", (Object)"bar", PropertyScope.OUTBOUND);
        Assert.assertTrue((boolean)(this.evaluate("message.outboundProperties", (MuleMessage)message) instanceof Map));
    }

    @Test
    public void assignToOutboundPropertyMap() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        this.assertFinalProperty("message.outboundProperties='foo'", (MuleMessage)message);
    }

    @Test
    public void outboundProperty() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        message.setOutboundProperty("foo", (Object)"bar");
        Assert.assertEquals((Object)"bar", (Object)this.evaluate("message.outboundProperties['foo']", (MuleMessage)message));
    }

    @Test
    public void assignValueToOutboundProperty() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        message.setOutboundProperty("foo", (Object)"bar_old");
        this.evaluate("message.outboundProperties['foo']='bar'", (MuleMessage)message);
        Assert.assertEquals((Object)"bar", (Object)message.getOutboundProperty("foo"));
    }

    @Test
    public void assignValueToNewOutboundProperty() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        this.evaluate("message.outboundProperties['foo']='bar'", (MuleMessage)message);
        Assert.assertEquals((Object)"bar", (Object)message.getOutboundProperty("foo"));
    }

    @Test
    public void inboundClear() throws Exception {
        this.assertUnsupportedOperation("message.inboundProperties.clear())", (MuleMessage)Mockito.mock(MuleMessage.class));
    }

    @Test
    public void inboundSize() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        Mockito.mock(DataHandler.class);
        message.setInboundProperty("foo", (Object)"abc");
        message.setInboundProperty("bar", (Object)"xyz");
        Assert.assertEquals((Object)2, (Object)this.evaluate("message.inboundProperties.size()", (MuleMessage)message));
    }

    @Test
    public void inboundKeySet() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        Mockito.mock(DataHandler.class);
        message.setInboundProperty("foo", (Object)"abc");
        message.setInboundProperty("bar", (Object)"xyz");
        Assert.assertEquals((Object)"foo", (Object)this.evaluate("message.inboundProperties.keySet().toArray()[0]", (MuleMessage)message));
        Assert.assertEquals((Object)"bar", (Object)this.evaluate("message.inboundProperties.keySet().toArray()[1]", (MuleMessage)message));
    }

    @Test
    public void inboundContainsKey() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        Mockito.mock(DataHandler.class);
        message.setInboundProperty("foo", (Object)"abc");
        junit.framework.Assert.assertTrue((boolean)((Boolean)this.evaluate("message.inboundProperties.containsKey('foo')", (MuleMessage)message)));
        junit.framework.Assert.assertFalse((boolean)((Boolean)this.evaluate("message.inboundProperties.containsKey('bar')", (MuleMessage)message)));
    }

    @Test
    public void inboundContainsValue() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        message.setInboundProperty("foo", (Object)"abc");
        junit.framework.Assert.assertTrue((boolean)((Boolean)this.evaluate("message.inboundProperties.containsValue('abc')", (MuleMessage)message)));
        junit.framework.Assert.assertFalse((boolean)((Boolean)this.evaluate("message.inboundProperties.containsValue('xyz')", (MuleMessage)message)));
    }

    @Test
    public void inboundEntrySet() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        message.setInboundProperty("foo", (Object)"abc");
        message.setInboundProperty("bar", (Object)"xyz");
        Set entrySet = (Set)this.evaluate("message.inboundProperties.entrySet()", (MuleMessage)message);
        Assert.assertEquals((long)2L, (long)entrySet.size());
        entrySet.contains(new DefaultMapEntry((Object)"foo", (Object)"abc"));
        entrySet.contains(new DefaultMapEntry((Object)"bar", (Object)"xyz"));
    }

    @Test
    public void inboundValues() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        message.setInboundProperty("foo", (Object)"abc");
        message.setInboundProperty("bar", (Object)"xyz");
        Collection values = (Collection)this.evaluate("message.inboundProperties.values()", (MuleMessage)message);
        Assert.assertEquals((long)2L, (long)values.size());
        values.contains("abc");
        values.contains("xyz");
    }

    @Test
    public void inboundIsEmpty() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        junit.framework.Assert.assertTrue((boolean)((Boolean)this.evaluate("message.inboundProperties.isEmpty()", (MuleMessage)message)));
        message.setInboundProperty("foo", (Object)"abc");
        message.setInboundProperty("bar", (Object)"xyz");
        junit.framework.Assert.assertFalse((boolean)((Boolean)this.evaluate("message.inboundProperties.isEmpty()", (MuleMessage)message)));
    }

    @Test
    public void inboundPutAll() throws Exception {
        this.assertUnsupportedOperation("message.inboundProperties.putAll(['foo': 'abc','bar': 'xyz'])", (MuleMessage)Mockito.mock(MuleMessage.class));
    }

    @Test
    public void inboundRemove() throws Exception {
        this.assertUnsupportedOperation("message.inboundProperties.remove('foo')", (MuleMessage)Mockito.mock(MuleMessage.class));
    }

    @Test
    public void outboundClear() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        message.setOutboundProperty("foo", (Object)"abc");
        message.setOutboundProperty("bar", (Object)"xyz");
        this.evaluate("message.outboundProperties.clear()", (MuleMessage)message);
        Assert.assertEquals((long)0L, (long)message.getOutboundPropertyNames().size());
    }

    @Test
    public void outboundSize() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        message.setOutboundProperty("foo", (Object)"abc");
        message.setOutboundProperty("bar", (Object)"xyz");
        Assert.assertEquals((Object)2, (Object)this.evaluate("message.outboundProperties.size()", (MuleMessage)message));
    }

    @Test
    public void outboundKeySet() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        message.setOutboundProperty("foo", (Object)"abc");
        message.setOutboundProperty("bar", (Object)"xyz");
        Assert.assertEquals((Object)"foo", (Object)this.evaluate("message.outboundProperties.keySet().toArray()[0]", (MuleMessage)message));
        Assert.assertEquals((Object)"bar", (Object)this.evaluate("message.outboundProperties.keySet().toArray()[1]", (MuleMessage)message));
    }

    @Test
    public void outboundContainsKey() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        message.setOutboundProperty("foo", (Object)"abc");
        junit.framework.Assert.assertTrue((boolean)((Boolean)this.evaluate("message.outboundProperties.containsKey('foo')", (MuleMessage)message)));
        junit.framework.Assert.assertFalse((boolean)((Boolean)this.evaluate("message.outboundProperties.containsKey('bar')", (MuleMessage)message)));
    }

    @Test
    public void outboundContainsValue() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        message.setOutboundProperty("foo", (Object)"abc");
        junit.framework.Assert.assertTrue((boolean)((Boolean)this.evaluate("message.outboundProperties.containsValue('abc')", (MuleMessage)message)));
        junit.framework.Assert.assertFalse((boolean)((Boolean)this.evaluate("message.outboundProperties.containsValue('xyz')", (MuleMessage)message)));
    }

    @Test
    public void outboundEntrySet() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        message.setOutboundProperty("foo", (Object)"abc");
        message.setOutboundProperty("bar", (Object)"xyz");
        Set entrySet = (Set)this.evaluate("message.outboundProperties.entrySet()", (MuleMessage)message);
        Assert.assertEquals((long)2L, (long)entrySet.size());
        entrySet.contains(new DefaultMapEntry((Object)"foo", (Object)"abc"));
        entrySet.contains(new DefaultMapEntry((Object)"bar", (Object)"xyz"));
    }

    @Test
    public void outboundValues() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        message.setOutboundProperty("foo", (Object)"abc");
        message.setOutboundProperty("bar", (Object)"xyz");
        Collection values = (Collection)this.evaluate("message.outboundProperties.values()", (MuleMessage)message);
        Assert.assertEquals((long)2L, (long)values.size());
        values.contains("abc");
        values.contains("xyz");
    }

    @Test
    public void outboundIsEmpty() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        junit.framework.Assert.assertTrue((boolean)((Boolean)this.evaluate("message.outboundProperties.isEmpty()", (MuleMessage)message)));
        message.setOutboundProperty("foo", (Object)"abc");
        message.setOutboundProperty("bar", (Object)"xyz");
        junit.framework.Assert.assertFalse((boolean)((Boolean)this.evaluate("message.outboundProperties.isEmpty()", (MuleMessage)message)));
    }

    @Test
    public void outboundPutAll() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        this.evaluate("message.outboundProperties.putAll(['foo': 'abc','bar': 'xyz'])", (MuleMessage)message);
        Assert.assertEquals((Object)"abc", (Object)this.evaluate("message.outboundProperties['foo']", (MuleMessage)message));
        Assert.assertEquals((Object)"xyz", (Object)this.evaluate("message.outboundProperties['bar']", (MuleMessage)message));
    }

    @Test
    public void outboundInboundRemove() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        message.setOutboundProperty("foo", (Object)"abc");
        junit.framework.Assert.assertFalse((boolean)((Boolean)this.evaluate("message.outboundProperties.isEmpty()", (MuleMessage)message)));
        this.evaluate("message.outboundProperties.remove('foo')", (MuleMessage)message);
        junit.framework.Assert.assertTrue((boolean)((Boolean)this.evaluate("message.outboundProperties.isEmpty()", (MuleMessage)message)));
    }
}

