/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.mule.util.StringUtils;

public class ZipUtils {
    private ZipUtils() {
    }

    public static void compress(File targetFile, ZipResource[] resources) throws IOException {
        try (ZipOutputStream out = new ZipOutputStream(new FileOutputStream(targetFile));){
            for (ZipResource zipResource : resources) {
                try (FileInputStream in = new FileInputStream(zipResource.getFile());){
                    int count;
                    out.putNextEntry(new ZipEntry(zipResource.getName()));
                    byte[] buffer = new byte[1024];
                    while ((count = in.read(buffer)) > 0) {
                        out.write(buffer, 0, count);
                    }
                }
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException("Error compressing file " + targetFile.getName(), e);
        }
    }

    public static class ZipResource {
        private final File file;
        private final String alias;

        public ZipResource(File file) {
            this(file, null);
        }

        public ZipResource(File file, String alias) {
            this.file = file;
            this.alias = alias;
        }

        public String getName() {
            return StringUtils.isEmpty((String)this.alias) ? this.file.getName() : this.alias;
        }

        public File getFile() {
            return this.file;
        }
    }
}

