/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.lock;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Answers;
import org.mockito.Mockito;
import org.mockito.internal.verification.VerificationModeFactory;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.mule.api.store.ObjectAlreadyExistsException;
import org.mule.api.store.ObjectStore;
import org.mule.api.store.ObjectStoreException;
import org.mule.config.i18n.CoreMessages;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.util.concurrent.Latch;
import org.mule.util.lock.InstanceLockGroup;
import org.mule.util.lock.LockProvider;
import org.mule.util.lock.SingleServerLockProvider;

public class InstanceLockGroupTestCase
extends AbstractMuleTestCase {
    public static final int THREAD_COUNT = 100;
    public static final int ITERATIONS_PER_THREAD = 100;
    private Latch threadStartLatch = new Latch();
    private String sharedKeyA = "A";
    private String sharedKeyB = "B";
    private InstanceLockGroup instanceLockGroup = new InstanceLockGroup((LockProvider)new SingleServerLockProvider());
    private InMemoryObjectStore objectStore = new InMemoryObjectStore();
    private LockProvider mockLockProvider;

    @Test
    @Ignore(value="MULE-6926: Flaky Test")
    public void testLockUnlock() throws Exception {
        this.testHighConcurrency(false);
    }

    @Test
    @Ignore(value="MULE-6926: Flaky Test")
    public void testTryLockUnlock() throws Exception {
        this.testHighConcurrency(true);
    }

    @Test
    @Ignore(value="MULE-6926: Flaky Test")
    public void testWhenUnlockThenDestroy() throws Exception {
        this.lockUnlockThenDestroy(1);
    }

    @Test
    @Ignore(value="MULE-6926: Flaky Test")
    public void testWhenSeveralLockOneUnlockThenDestroy() throws Exception {
        this.lockUnlockThenDestroy(5);
    }

    private void lockUnlockThenDestroy(int lockTimes) {
        this.mockLockProvider = (LockProvider)Mockito.mock(LockProvider.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());
        InstanceLockGroup instanceLockGroup = new InstanceLockGroup(this.mockLockProvider);
        for (int i = 0; i < lockTimes; ++i) {
            instanceLockGroup.lock("lockId");
        }
        instanceLockGroup.unlock("lockId");
        ((LockProvider)Mockito.verify((Object)this.mockLockProvider, (VerificationMode)VerificationModeFactory.times((int)1))).createLock("lockId");
    }

    private void testHighConcurrency(boolean useTryLock) throws InterruptedException, ObjectStoreException {
        ArrayList<IncrementKeyValueThread> threads = new ArrayList<IncrementKeyValueThread>(100);
        for (int i = 0; i < 100; ++i) {
            IncrementKeyValueThread incrementKeyValueThread = new IncrementKeyValueThread(this.sharedKeyA, useTryLock);
            threads.add(incrementKeyValueThread);
            incrementKeyValueThread.start();
            IncrementKeyValueThread incrementKeyValueThread2 = new IncrementKeyValueThread(this.sharedKeyB, useTryLock);
            threads.add(incrementKeyValueThread2);
            incrementKeyValueThread2.start();
        }
        this.threadStartLatch.release();
        for (Thread thread : threads) {
            thread.join();
        }
        Assert.assertThat((Object)this.objectStore.retrieve((Serializable)((Object)this.sharedKeyA)), (Matcher)Is.is((Object)10000));
        Assert.assertThat((Object)this.objectStore.retrieve((Serializable)((Object)this.sharedKeyB)), (Matcher)Is.is((Object)10000));
    }

    public static class InMemoryObjectStore
    implements ObjectStore<Integer> {
        private Map<Serializable, Integer> store = new HashMap<Serializable, Integer>();

        public boolean contains(Serializable key) throws ObjectStoreException {
            return this.store.containsKey(key);
        }

        public void store(Serializable key, Integer value) throws ObjectStoreException {
            if (this.store.containsKey(key)) {
                throw new ObjectAlreadyExistsException(CoreMessages.createStaticMessage((String)""));
            }
            this.store.put(key, value);
        }

        public Integer retrieve(Serializable key) throws ObjectStoreException {
            return this.store.get(key);
        }

        public Integer remove(Serializable key) throws ObjectStoreException {
            return this.store.remove(key);
        }

        public void clear() throws ObjectStoreException {
            this.store.clear();
        }

        public boolean isPersistent() {
            return false;
        }
    }

    public class IncrementKeyValueThread
    extends Thread {
        private String key;
        private boolean useTryLock;

        private IncrementKeyValueThread(String key, boolean useTryLock) {
            super("Thread-" + key);
            this.key = key;
            this.useTryLock = useTryLock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                InstanceLockGroupTestCase.this.threadStartLatch.await(5000L, TimeUnit.MILLISECONDS);
                for (int i = 0; i < 100 && !Thread.interrupted(); ++i) {
                    if (this.useTryLock) {
                        while (!InstanceLockGroupTestCase.this.instanceLockGroup.tryLock(this.key, 100L, TimeUnit.MILLISECONDS)) {
                        }
                    } else {
                        InstanceLockGroupTestCase.this.instanceLockGroup.lock(this.key);
                    }
                    try {
                        Integer value;
                        if (InstanceLockGroupTestCase.this.objectStore.contains((Serializable)((Object)this.key))) {
                            value = InstanceLockGroupTestCase.this.objectStore.retrieve((Serializable)((Object)this.key));
                            InstanceLockGroupTestCase.this.objectStore.remove((Serializable)((Object)this.key));
                        } else {
                            value = 0;
                        }
                        InstanceLockGroupTestCase.this.objectStore.store((Serializable)((Object)this.key), value + 1);
                        continue;
                    }
                    finally {
                        InstanceLockGroupTestCase.this.instanceLockGroup.unlock(this.key);
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

