/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.ws.construct;

import java.net.URI;
import java.net.UnknownHostException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MessageExchangePattern;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.construct.FlowConstructInvalidException;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.expression.ExpressionManager;
import org.mule.api.expression.ExpressionRuntimeException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.processor.MessageProcessorChainBuilder;
import org.mule.api.source.MessageSource;
import org.mule.config.i18n.MessageFactory;
import org.mule.construct.AbstractConfigurationPattern;
import org.mule.endpoint.DynamicOutboundEndpoint;
import org.mule.processor.ResponseMessageProcessorAdapter;
import org.mule.transformer.TransformerTemplate;
import org.mule.transport.http.construct.HttpProxy;
import org.mule.transport.http.construct.support.CopyInboundToOutboundPropertiesTransformerCallback;
import org.mule.util.NetworkUtils;
import org.mule.util.ObjectUtils;
import org.mule.util.StringUtils;

public class WSProxy
extends AbstractConfigurationPattern {
    private final AbstractProxyRequestProcessor proxyMessageProcessor;
    private final OutboundEndpoint outboundEndpoint;

    public WSProxy(String name, MuleContext muleContext, MessageSource messageSource, OutboundEndpoint outboundEndpoint, List<MessageProcessor> transformers, List<MessageProcessor> responseTransformers) throws MuleException {
        this(name, muleContext, messageSource, outboundEndpoint, transformers, responseTransformers, new DynamicWsdlProxyRequestProcessor(outboundEndpoint));
    }

    public WSProxy(String name, MuleContext muleContext, MessageSource messageSource, OutboundEndpoint outboundEndpoint, List<MessageProcessor> transformers, List<MessageProcessor> responseTransformers, String wsdlContents) throws MuleException {
        this(name, muleContext, messageSource, outboundEndpoint, transformers, responseTransformers, new StaticWsdlProxyRequestProcessor(wsdlContents));
    }

    public WSProxy(String name, MuleContext muleContext, MessageSource messageSource, OutboundEndpoint outboundEndpoint, List<MessageProcessor> transformers, List<MessageProcessor> responseTransformers, URI wsdlUri) throws MuleException {
        this(name, muleContext, messageSource, outboundEndpoint, transformers, responseTransformers, new DynamicWsdlProxyRequestProcessor(wsdlUri));
    }

    private WSProxy(String name, MuleContext muleContext, MessageSource messageSource, OutboundEndpoint outboundEndpoint, List<MessageProcessor> transformers, List<MessageProcessor> responseTransformers, AbstractProxyRequestProcessor proxyMessageProcessor) throws MuleException {
        super(name, muleContext, transformers, responseTransformers);
        if (messageSource == null) {
            throw new FlowConstructInvalidException(MessageFactory.createStaticMessage((String)("messageSource can't be null on: " + this.toString())), (FlowConstruct)this);
        }
        super.setMessageSource(messageSource);
        if (outboundEndpoint == null) {
            throw new FlowConstructInvalidException(MessageFactory.createStaticMessage((String)("outboundEndpoint can't be null on: " + this.toString())), (FlowConstruct)this);
        }
        this.outboundEndpoint = outboundEndpoint;
        proxyMessageProcessor.setOutboundAddress(outboundEndpoint.getAddress());
        this.proxyMessageProcessor = proxyMessageProcessor;
    }

    protected void configureMessageProcessorsBeforeTransformation(MessageProcessorChainBuilder builder) {
        builder.chain(new MessageProcessor[]{this.proxyMessageProcessor});
        HttpProxy.configureContentLengthRemover((AbstractConfigurationPattern)this, (MessageProcessorChainBuilder)builder);
    }

    protected void configureMessageProcessorsAfterTransformation(MessageProcessorChainBuilder builder) {
        TransformerTemplate copyInboundToOutboundPropertiesTransformer = new TransformerTemplate((TransformerTemplate.TransformerCallback)new CopyInboundToOutboundPropertiesTransformerCallback());
        builder.chain(new MessageProcessor[]{copyInboundToOutboundPropertiesTransformer});
        builder.chain(new MessageProcessor[]{new ResponseMessageProcessorAdapter((MessageProcessor)copyInboundToOutboundPropertiesTransformer)});
        builder.chain(new MessageProcessor[]{this.outboundEndpoint});
    }

    protected void validateConstruct() throws FlowConstructInvalidException {
        super.validateConstruct();
        if (this.messageSource instanceof InboundEndpoint && !((InboundEndpoint)this.messageSource).getExchangePattern().equals((Object)MessageExchangePattern.REQUEST_RESPONSE)) {
            throw new FlowConstructInvalidException(MessageFactory.createStaticMessage((String)"WSProxy only works with a request-response inbound endpoint."), (FlowConstruct)this);
        }
        if (!this.outboundEndpoint.getExchangePattern().equals((Object)MessageExchangePattern.REQUEST_RESPONSE)) {
            throw new FlowConstructInvalidException(MessageFactory.createStaticMessage((String)"WSProxy only works with a request-response outbound endpoint."), (FlowConstruct)this);
        }
    }

    public String toString() {
        return ObjectUtils.toString((Object)((Object)this));
    }

    public String getConstructType() {
        return "Web-Service-Proxy";
    }

    private static class DynamicWsdlProxyRequestProcessor
    extends AbstractProxyRequestProcessor {
        private final WsdlAddressProvider wsdlAddressProvider;

        DynamicWsdlProxyRequestProcessor(URI wsdlUri) throws FlowConstructInvalidException {
            if (wsdlUri == null) {
                throw new FlowConstructInvalidException(MessageFactory.createStaticMessage((String)"wsdlUri can't be null"));
            }
            final String wsdlAddress = wsdlUri.toString();
            this.wsdlAddressProvider = new WsdlAddressProvider(){

                @Override
                public String get(MuleEvent event) {
                    return wsdlAddress;
                }
            };
            this.logger.info((Object)("Using url " + wsdlAddress + " as WSDL"));
        }

        DynamicWsdlProxyRequestProcessor(OutboundEndpoint outboundEndpoint) throws FlowConstructInvalidException {
            if (outboundEndpoint == null) {
                throw new FlowConstructInvalidException(MessageFactory.createStaticMessage((String)"outboundEndpoint can't be null"));
            }
            final String wsAddress = outboundEndpoint.getAddress();
            if (outboundEndpoint instanceof DynamicOutboundEndpoint) {
                this.wsdlAddressProvider = new WsdlAddressProvider(){

                    @Override
                    public String get(MuleEvent event) {
                        String resolvedWsAddress = event.getMuleContext().getExpressionManager().parse(wsAddress, event, true);
                        return DynamicWsdlProxyRequestProcessor.makeWsdlOrXSDAddress(resolvedWsAddress, event.getMessage());
                    }
                };
                this.logger.info((Object)("Using dynamic WSDL with service address: " + wsAddress));
            } else {
                this.wsdlAddressProvider = new WsdlAddressProvider(){

                    @Override
                    public String get(MuleEvent event) {
                        return DynamicWsdlProxyRequestProcessor.makeWsdlOrXSDAddress(wsAddress, event.getMessage());
                    }
                };
                this.logger.info((Object)("Setting WSDL address for: " + wsAddress));
            }
        }

        private static String makeWsdlOrXSDAddress(String wsAddress, MuleMessage message) {
            String request = (String)message.getInboundProperty("http.request");
            String address = StringUtils.substringBefore((String)wsAddress, (String)"?") + "?";
            if (request != null && request.indexOf("?") > -1) {
                String queryString = StringUtils.substringAfter((String)request, (String)"?");
                return address.concat(queryString);
            }
            return address.concat("wsdl");
        }

        @Override
        protected String getWsdlContents(MuleEvent event) throws Exception {
            String wsdlAddress = this.wsdlAddressProvider.get(event);
            MuleContext muleContext = event.getMuleContext();
            InboundEndpoint webServiceEndpoint = muleContext.getEndpointFactory().getInboundEndpoint(wsdlAddress);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Retrieving WSDL from web service with: " + webServiceEndpoint));
            }
            MuleMessage replyWSDL = webServiceEndpoint.request((long)event.getTimeout());
            String wsdlString = replyWSDL.getPayloadAsString();
            return wsdlString;
        }

        private static interface WsdlAddressProvider {
            public String get(MuleEvent var1);
        }
    }

    private static class StaticWsdlProxyRequestProcessor
    extends AbstractProxyRequestProcessor {
        private final String wsdlContents;

        StaticWsdlProxyRequestProcessor(String wsdlContents) throws FlowConstructInvalidException {
            if (StringUtils.isBlank((String)wsdlContents)) {
                throw new FlowConstructInvalidException(MessageFactory.createStaticMessage((String)"wsdlContents can't be empty"));
            }
            this.wsdlContents = wsdlContents;
        }

        @Override
        protected String getWsdlContents(MuleEvent event) throws Exception {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Serving static WSDL");
            }
            return this.wsdlContents;
        }
    }

    private static abstract class AbstractProxyRequestProcessor
    implements MessageProcessor {
        private static final String HTTP_REQUEST = "http.request";
        private static final String WSDL_PARAM_1 = "?wsdl";
        private static final String WSDL_PARAM_2 = "&wsdl";
        private static final String XSD_PARAM_1 = "?xsd=";
        private static final String XSD_PARAM_2 = "&xsd=";
        private static final String LOCALHOST = "localhost";
        private static final String LOCALHOST_LOCALDOMAIN = "localhost.localdomain";
        protected final Log logger = LogFactory.getLog(WSProxy.class);
        private String outboundAddress;

        private AbstractProxyRequestProcessor() {
        }

        protected void setOutboundAddress(String outboundAddress) {
            this.outboundAddress = outboundAddress;
        }

        public MuleEvent process(MuleEvent event) throws MuleException {
            if (this.isWsdlOrXSDRequest(event)) {
                return this.buildWsdlOrXSDResult(event);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Forwarding SOAP message");
            }
            return event;
        }

        private MuleEvent buildWsdlOrXSDResult(MuleEvent event) throws MuleException {
            try {
                String wsdlContents = this.getWsdlContents(event);
                wsdlContents = this.modifyServiceAddress(wsdlContents, event);
                event.getMessage().setPayload((Object)wsdlContents);
                event.setStopFurtherProcessing(true);
                return event;
            }
            catch (Exception e) {
                throw new MessagingException(MessageFactory.createStaticMessage((String)"Impossible to retrieve WSDL for proxied service"), event, (Throwable)e, (MessageProcessor)this);
            }
        }

        private String modifyServiceAddress(String wsdlContents, MuleEvent event) throws UnknownHostException {
            String inboundAddress = event.getMessageSourceURI().toASCIIString();
            try {
                String substitutedAddress = this.outboundAddress;
                ExpressionManager expressionManager = event.getMuleContext().getExpressionManager();
                if (expressionManager.isValidExpression(this.outboundAddress)) {
                    substitutedAddress = expressionManager.parse(this.outboundAddress, event, true);
                }
                wsdlContents = wsdlContents.replaceAll(substitutedAddress, inboundAddress);
            }
            catch (ExpressionRuntimeException ex) {
                this.logger.warn((Object)("Unable to construct outbound address for WSDL request to proxied dynamic endpoint " + this.outboundAddress));
            }
            if (wsdlContents.contains(LOCALHOST_LOCALDOMAIN)) {
                wsdlContents = wsdlContents.replaceAll(LOCALHOST_LOCALDOMAIN, NetworkUtils.getLocalHost().getHostName());
            } else if (wsdlContents.contains(LOCALHOST)) {
                wsdlContents = wsdlContents.replaceAll(LOCALHOST, NetworkUtils.getLocalHost().getHostName());
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"WSDL modified successfully");
            }
            return wsdlContents;
        }

        private boolean isWsdlOrXSDRequest(MuleEvent event) throws MuleException {
            String httpRequest = (String)event.getMessage().getInboundProperty(HTTP_REQUEST);
            if (httpRequest == null) {
                this.logger.warn((Object)("WS Proxy can't rewrite WSDL for non-HTTP " + event));
                return false;
            }
            String lowerHttpRequest = httpRequest.toLowerCase();
            return lowerHttpRequest.indexOf(WSDL_PARAM_1) != -1 || lowerHttpRequest.indexOf(WSDL_PARAM_2) != -1 || lowerHttpRequest.indexOf(XSD_PARAM_1) != -1 || lowerHttpRequest.indexOf(XSD_PARAM_2) != -1;
        }

        protected abstract String getWsdlContents(MuleEvent var1) throws Exception;
    }
}

