/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.quartz;

import java.io.OutputStream;
import java.util.Date;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.EndpointException;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.transport.Connector;
import org.mule.api.transport.PropertyScope;
import org.mule.config.i18n.CoreMessages;
import org.mule.transport.AbstractMessageReceiver;
import org.mule.transport.quartz.QuartzConnector;
import org.mule.transport.quartz.config.JobConfig;
import org.mule.transport.quartz.i18n.QuartzMessages;
import org.mule.transport.quartz.jobs.CustomJobConfig;
import org.mule.transport.quartz.jobs.EventGeneratorJobConfig;
import org.quartz.CronScheduleBuilder;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.ObjectAlreadyExistsException;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.StatefulJob;
import org.quartz.TriggerBuilder;

public class QuartzMessageReceiver
extends AbstractMessageReceiver {
    public static final String QUARTZ_RECEIVER_PROPERTY = "mule.quartz.receiver";
    public static final String QUARTZ_CONNECTOR_PROPERTY = "mule.quartz.connector";
    private final QuartzConnector connector;
    private boolean isStateful;

    public QuartzMessageReceiver(Connector connector, FlowConstruct flowConstruct, InboundEndpoint endpoint) throws CreateException {
        super(connector, flowConstruct, endpoint);
        this.connector = (QuartzConnector)connector;
    }

    protected void doDispose() {
    }

    protected MuleEvent createMuleEvent(MuleMessage message, OutputStream outputStream) throws MuleException {
        if (this.isStateful) {
            message.setProperty("MULE_FORCE_SYNC", (Object)Boolean.TRUE, PropertyScope.INBOUND);
        }
        return super.createMuleEvent(message, outputStream);
    }

    protected void doStart() throws MuleException {
        try {
            Scheduler scheduler = this.connector.getQuartzScheduler();
            JobConfig jobConfig = (JobConfig)this.endpoint.getProperty((Object)"jobConfig");
            if (jobConfig == null) {
                throw new IllegalArgumentException(CoreMessages.objectIsNull((String)"jobConfig").getMessage());
            }
            Class<? extends Job> jobClass = jobConfig.getJobClass();
            JobBuilder jobBuilder = JobBuilder.newJob(jobClass);
            this.isStateful = StatefulJob.class.isAssignableFrom(jobClass);
            JobDataMap jobDataMap = new JobDataMap();
            jobDataMap.put(QUARTZ_RECEIVER_PROPERTY, this.getReceiverKey());
            jobDataMap.put(QUARTZ_CONNECTOR_PROPERTY, this.connector.getName());
            jobDataMap.putAll(this.endpoint.getProperties());
            if (jobConfig instanceof EventGeneratorJobConfig) {
                jobDataMap.put("payload", ((EventGeneratorJobConfig)jobConfig).getPayload());
            }
            jobDataMap.put("jobConfig", (Object)jobConfig);
            Job job = null;
            if (jobConfig instanceof CustomJobConfig) {
                job = ((CustomJobConfig)jobConfig).getJob();
            }
            if (job != null) {
                jobDataMap.put("jobObject", (Object)job);
            }
            jobBuilder.usingJobData(jobDataMap);
            String cronExpression = (String)this.endpoint.getProperty((Object)"cronExpression");
            String repeatInterval = (String)this.endpoint.getProperty((Object)"repeatInterval");
            String repeatCount = (String)this.endpoint.getProperty((Object)"repeatCount");
            String startDelay = (String)this.endpoint.getProperty((Object)"startDelay");
            String groupName = jobConfig.getGroupName();
            String jobGroupName = jobConfig.getJobGroupName();
            if (groupName == null) {
                groupName = "mule";
            }
            if (jobGroupName == null) {
                jobGroupName = groupName;
            }
            jobBuilder.withIdentity(this.endpoint.getEndpointURI().getAddress(), groupName);
            TriggerBuilder triggerBuilder = TriggerBuilder.newTrigger().withIdentity(this.endpoint.getEndpointURI().getAddress(), groupName).forJob(this.endpoint.getEndpointURI().getAddress(), jobGroupName);
            if (cronExpression != null) {
                triggerBuilder.withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronExpression));
            } else if (repeatInterval != null) {
                triggerBuilder.withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInMilliseconds(Long.parseLong(repeatInterval)).withRepeatCount(repeatCount != null ? Integer.parseInt(repeatCount) : -1));
            } else {
                throw new IllegalArgumentException(QuartzMessages.cronExpressionOrIntervalMustBeSet().getMessage());
            }
            long start = System.currentTimeMillis();
            if (startDelay != null) {
                start += Long.parseLong(startDelay);
            }
            triggerBuilder.startAt(new Date(start));
            try {
                scheduler.scheduleJob(jobBuilder.build(), triggerBuilder.build());
            }
            catch (ObjectAlreadyExistsException oaee) {
                this.logger.warn((Object)("A quartz Job with name: " + this.endpoint.getEndpointURI().getAddress() + " has already been registered. Cannot register again"));
            }
        }
        catch (Exception e) {
            throw new EndpointException(CoreMessages.failedToStart((String)"Quartz receiver"), (Throwable)e);
        }
    }

    protected void doConnect() throws Exception {
    }

    protected void doDisconnect() throws Exception {
    }
}

