/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.resource.spi.work.WorkListener;
import javax.transaction.TransactionManager;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DataTypeConversionResolver;
import org.mule.DynamicDataTypeConversionResolver;
import org.mule.api.Injector;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.MuleRuntimeException;
import org.mule.api.SingleResourceTransactionFactoryManager;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.config.MuleConfiguration;
import org.mule.api.config.ThreadingProfile;
import org.mule.api.context.MuleContextAware;
import org.mule.api.context.WorkManager;
import org.mule.api.context.notification.ServerNotification;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.api.el.ExpressionLanguage;
import org.mule.api.endpoint.EndpointFactory;
import org.mule.api.exception.MessagingExceptionHandler;
import org.mule.api.exception.RollbackSourceCallback;
import org.mule.api.exception.SystemExceptionHandler;
import org.mule.api.expression.ExpressionManager;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.LifecycleManager;
import org.mule.api.registry.MuleRegistry;
import org.mule.api.registry.RegistrationException;
import org.mule.api.registry.Registry;
import org.mule.api.security.SecurityManager;
import org.mule.api.serialization.ObjectSerializer;
import org.mule.api.store.ListableObjectStore;
import org.mule.api.store.ObjectStoreManager;
import org.mule.api.transaction.TransactionManagerFactory;
import org.mule.api.util.StreamCloserService;
import org.mule.client.DefaultLocalMuleClient;
import org.mule.config.ClusterConfiguration;
import org.mule.config.NullClusterConfiguration;
import org.mule.config.i18n.CoreMessages;
import org.mule.context.notification.MuleContextNotification;
import org.mule.context.notification.NotificationException;
import org.mule.context.notification.ServerNotificationManager;
import org.mule.exception.DefaultMessagingExceptionStrategy;
import org.mule.exception.DefaultSystemExceptionStrategy;
import org.mule.expression.DefaultExpressionManager;
import org.mule.extension.ExtensionManager;
import org.mule.lifecycle.MuleContextLifecycleManager;
import org.mule.management.stats.AllStatistics;
import org.mule.management.stats.ProcessingTimeWatcher;
import org.mule.registry.DefaultRegistryBroker;
import org.mule.registry.MuleRegistryHelper;
import org.mule.transport.DefaultPollingController;
import org.mule.transport.PollingController;
import org.mule.util.ApplicationShutdownSplashScreen;
import org.mule.util.ApplicationStartupSplashScreen;
import org.mule.util.JdkVersionUtils;
import org.mule.util.ServerShutdownSplashScreen;
import org.mule.util.ServerStartupSplashScreen;
import org.mule.util.SplashScreen;
import org.mule.util.SystemUtils;
import org.mule.util.UUID;
import org.mule.util.concurrent.Latch;
import org.mule.util.lock.LockFactory;
import org.mule.util.queue.QueueManager;

public class DefaultMuleContext
implements MuleContext {
    public static final String LOCAL_TRANSIENT_OBJECT_STORE_KEY = "_localInMemoryObjectStore";
    public static final String LOCAL_PERSISTENT_OBJECT_STORE_KEY = "_localPersistentObjectStore";
    public static final String LOCAL_OBJECT_STORE_MANAGER_KEY = "_localObjectStoreManager";
    public static final String LOCAL_QUEUE_MANAGER_KEY = "_localQueueManager";
    private transient Log logger = LogFactory.getLog(DefaultMuleContext.class);
    private DefaultRegistryBroker registryBroker;
    private MuleRegistry muleRegistryHelper;
    private Injector injector;
    private AllStatistics stats = new AllStatistics();
    private WorkManager workManager;
    private WorkListener workListener;
    protected MuleContextLifecycleManager lifecycleManager;
    protected ServerNotificationManager notificationManager;
    private MuleConfiguration config;
    private long startDate;
    private ExpressionManager expressionManager;
    private StreamCloserService streamCloserService;
    private ClassLoader executionClassLoader;
    protected LocalMuleClient localMuleClient;
    protected SystemExceptionHandler exceptionListener;
    private PollingController pollingController = new DefaultPollingController();
    private ClusterConfiguration clusterConfiguration = new NullClusterConfiguration();
    private Map<QName, Set<Object>> configurationAnnotations = new HashMap<QName, Set<Object>>();
    private SingleResourceTransactionFactoryManager singleResourceTransactionFactoryManager = new SingleResourceTransactionFactoryManager();
    private TransactionManager transactionManager;
    private LockFactory lockFactory;
    private ExpressionLanguage expressionLanguage;
    private ProcessingTimeWatcher processingTimeWatcher;
    private final Latch startLatch = new Latch();
    private QueueManager queueManager;
    private ExtensionManager extensionManager;
    private ObjectSerializer objectSerializer;
    private DataTypeConversionResolver dataTypeConversionResolver;

    @Deprecated
    public DefaultMuleContext(MuleConfiguration config, WorkManager workManager, WorkListener workListener, MuleContextLifecycleManager lifecycleManager, ServerNotificationManager notificationManager) {
        this.config = config;
        ((MuleContextAware)((Object)config)).setMuleContext(this);
        this.workManager = workManager;
        this.workListener = workListener;
        this.lifecycleManager = lifecycleManager;
        this.notificationManager = notificationManager;
        this.notificationManager.setMuleContext(this);
        this.expressionManager = new DefaultExpressionManager();
        ((MuleContextAware)((Object)this.expressionManager)).setMuleContext(this);
        this.registryBroker = this.createRegistryBroker();
        this.muleRegistryHelper = this.createRegistryHelper(this.registryBroker);
        this.localMuleClient = new DefaultLocalMuleClient(this);
        this.exceptionListener = new DefaultSystemExceptionStrategy(this);
    }

    public DefaultMuleContext() {
    }

    protected DefaultRegistryBroker createRegistryBroker() {
        return new DefaultRegistryBroker(this);
    }

    protected MuleRegistry createRegistryHelper(DefaultRegistryBroker registry) {
        return new MuleRegistryHelper(registry, this);
    }

    @Override
    public synchronized void initialise() throws InitialisationException {
        this.lifecycleManager.checkPhase("initialise");
        if (this.getNotificationManager() == null) {
            throw new MuleRuntimeException(CoreMessages.objectIsNull("_muleNotificationManager"));
        }
        if (this.workManager == null) {
            throw new MuleRuntimeException(CoreMessages.objectIsNull("workManager"));
        }
        try {
            JdkVersionUtils.validateJdk();
        }
        catch (RuntimeException e) {
            throw new InitialisationException(CoreMessages.invalidJdk(SystemUtils.JAVA_VERSION, JdkVersionUtils.getSupportedJdks()), (Initialisable)this);
        }
        try {
            this.muleRegistryHelper.initialise();
            if (this.workManager instanceof MuleContextAware) {
                MuleContextAware contextAware = (MuleContextAware)((Object)this.workManager);
                contextAware.setMuleContext(this);
            }
            this.workManager.start();
            this.getNotificationManager().start(this.workManager, this.workListener);
            this.fireNotification(new MuleContextNotification((MuleContext)this, 101));
            this.getLifecycleManager().fireLifecycle("initialise");
            if (this.expressionManager instanceof Initialisable) {
                ((Initialisable)((Object)this.expressionManager)).initialise();
            }
            this.fireNotification(new MuleContextNotification((MuleContext)this, 102));
        }
        catch (Exception e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    @Override
    public synchronized void start() throws MuleException {
        this.getLifecycleManager().checkPhase("start");
        if (this.getQueueManager() == null) {
            throw new MuleRuntimeException(CoreMessages.objectIsNull("queueManager"));
        }
        this.startDate = System.currentTimeMillis();
        this.fireNotification(new MuleContextNotification((MuleContext)this, 103));
        this.getLifecycleManager().fireLifecycle("start");
        this.overridePollingController();
        this.overrideClusterConfiguration();
        this.fireNotification(new MuleContextNotification((MuleContext)this, 104));
        this.startLatch.release();
        if (this.logger.isInfoEnabled()) {
            SplashScreen startupScreen = this.buildStartupSplash();
            this.logger.info((Object)startupScreen.toString());
        }
    }

    @Override
    public synchronized void stop() throws MuleException {
        this.startLatch.release();
        this.getLifecycleManager().checkPhase("stop");
        this.fireNotification(new MuleContextNotification((MuleContext)this, 105));
        this.getLifecycleManager().fireLifecycle("stop");
        this.fireNotification(new MuleContextNotification((MuleContext)this, 106));
    }

    @Override
    public synchronized void dispose() {
        if (this.isStarted()) {
            try {
                this.stop();
            }
            catch (MuleException e) {
                this.logger.error((Object)"Failed to stop Mule context", (Throwable)e);
            }
        }
        this.getLifecycleManager().checkPhase("dispose");
        this.fireNotification(new MuleContextNotification((MuleContext)this, 107));
        try {
            this.getLifecycleManager().fireLifecycle("dispose");
            this.muleRegistryHelper.dispose();
        }
        catch (Exception e) {
            this.logger.debug((Object)("Failed to cleanly dispose Mule: " + e.getMessage()), (Throwable)e);
        }
        this.notificationManager.fireNotification(new MuleContextNotification((MuleContext)this, 108));
        this.notificationManager.dispose();
        this.workManager.dispose();
        if (this.expressionManager != null && this.expressionManager instanceof Disposable) {
            ((Disposable)((Object)this.expressionManager)).dispose();
        }
        if (this.getStartDate() > 0L && this.logger.isInfoEnabled()) {
            SplashScreen shutdownScreen = this.buildShutdownSplash();
            this.logger.info((Object)shutdownScreen.toString());
        }
        this.setExecutionClassLoader(null);
    }

    @Override
    public boolean isInitialised() {
        return this.getLifecycleManager().getState().isInitialised();
    }

    @Override
    public boolean isInitialising() {
        return this.getLifecycleManager().getState().isInitialising();
    }

    @Override
    public boolean isStopped() {
        return this.getLifecycleManager().getState().isStopped();
    }

    @Override
    public boolean isStopping() {
        return this.getLifecycleManager().getState().isStopping();
    }

    @Override
    public boolean isStarted() {
        return this.getLifecycleManager().isPhaseComplete("start");
    }

    @Override
    public boolean isStarting() {
        return this.getLifecycleManager().getState().isStarting();
    }

    @Override
    public boolean isDisposed() {
        return this.getLifecycleManager().getState().isDisposed();
    }

    @Override
    public boolean isDisposing() {
        return this.getLifecycleManager().getState().isDisposing();
    }

    @Override
    public LifecycleManager getLifecycleManager() {
        return this.lifecycleManager;
    }

    @Override
    public AllStatistics getStatistics() {
        return this.stats;
    }

    @Override
    public void registerListener(ServerNotificationListener l) throws NotificationException {
        this.registerListener(l, null);
    }

    @Override
    public void registerListener(ServerNotificationListener l, String resourceIdentifier) throws NotificationException {
        ServerNotificationManager notificationManager = this.getNotificationManager();
        if (notificationManager == null) {
            throw new MuleRuntimeException(CoreMessages.serverNotificationManagerNotEnabled());
        }
        notificationManager.addListenerSubscription(l, resourceIdentifier);
    }

    @Override
    public void unregisterListener(ServerNotificationListener l) {
        ServerNotificationManager notificationManager = this.getNotificationManager();
        if (notificationManager != null) {
            notificationManager.removeListener(l);
        }
    }

    @Override
    public void fireNotification(ServerNotification notification) {
        ServerNotificationManager notificationManager = this.getNotificationManager();
        if (notificationManager != null) {
            notificationManager.fireNotification(notification);
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("MuleEvent Manager is not enabled, ignoring notification: " + notification));
        }
    }

    @Override
    public void setSecurityManager(SecurityManager securityManager) throws RegistrationException {
        this.checkLifecycleForPropertySet("_muleSecurityManager", "initialise");
        this.registryBroker.registerObject("_muleSecurityManager", securityManager);
    }

    @Override
    public SecurityManager getSecurityManager() {
        Collection<SecurityManager> temp;
        SecurityManager securityManager = (SecurityManager)this.registryBroker.lookupObject("_muleSecurityManager");
        if (securityManager == null && (temp = this.registryBroker.lookupObjects(SecurityManager.class)).size() > 0) {
            securityManager = temp.iterator().next();
        }
        if (securityManager == null) {
            throw new MuleRuntimeException(CoreMessages.objectIsNull("securityManager"));
        }
        return securityManager;
    }

    @Override
    public WorkManager getWorkManager() {
        return this.workManager;
    }

    @Override
    public WorkListener getWorkListener() {
        return this.workListener;
    }

    @Override
    public QueueManager getQueueManager() {
        if (this.queueManager == null) {
            Collection<QueueManager> temp;
            this.queueManager = (QueueManager)this.registryBroker.lookupObject("_muleQueueManager");
            if (this.queueManager == null && (temp = this.registryBroker.lookupObjects(QueueManager.class)).size() > 0) {
                this.queueManager = temp.iterator().next();
            }
        }
        return this.queueManager;
    }

    @Override
    public ExtensionManager getExtensionManager() {
        return this.extensionManager;
    }

    @Override
    public ObjectStoreManager getObjectStoreManager() {
        return (ObjectStoreManager)this.getRegistry().lookupObject("_muleObjectStoreManager");
    }

    @Override
    public ObjectSerializer getObjectSerializer() {
        return this.objectSerializer;
    }

    public ObjectStoreManager getLocalObjectStoreManager() {
        return (ObjectStoreManager)this.getRegistry().lookupObject(LOCAL_OBJECT_STORE_MANAGER_KEY);
    }

    public QueueManager getLocalQueueManager() {
        return (QueueManager)this.getRegistry().lookupObject(LOCAL_QUEUE_MANAGER_KEY);
    }

    @Override
    public void setQueueManager(QueueManager queueManager) throws RegistrationException {
        this.getRegistry().registerObject("_muleQueueManager", queueManager);
        this.queueManager = queueManager;
    }

    @Override
    public MuleConfiguration getConfiguration() {
        return this.config;
    }

    @Override
    public ServerNotificationManager getNotificationManager() {
        return this.notificationManager;
    }

    @Override
    public void setTransactionManager(TransactionManager manager) throws RegistrationException {
        this.registryBroker.registerObject("_muleTransactionManager", manager);
    }

    @Override
    public TransactionManager getTransactionManager() {
        if (this.transactionManager == null) {
            this.transactionManager = (TransactionManager)this.registryBroker.lookupObject("_muleTransactionManager");
            if (this.transactionManager == null) {
                Collection<TransactionManagerFactory> temp = this.registryBroker.lookupObjects(TransactionManagerFactory.class);
                if (temp.size() > 1) {
                    throw new MuleRuntimeException(CoreMessages.createStaticMessage("More than one TX manager has been configured - Only one TX manager can be defined per application. Validate your app configuration or if your app belongs to a domain and the domains defines a TX manager then you should use that one."));
                }
                if (temp.size() > 0) {
                    try {
                        this.transactionManager = temp.iterator().next().create(this.config);
                        this.registryBroker.registerObject("_muleTransactionManager", this.transactionManager);
                    }
                    catch (Exception e) {
                        throw new MuleRuntimeException(CoreMessages.failedToCreate("transaction manager"), (Throwable)e);
                    }
                } else {
                    temp = this.registryBroker.lookupObjects(TransactionManager.class);
                    if (temp.size() > 0) {
                        this.transactionManager = (TransactionManager)temp.iterator().next();
                    }
                }
            }
        }
        return this.transactionManager;
    }

    protected void checkLifecycleForPropertySet(String propertyName, String phase) throws IllegalStateException {
        if (this.lifecycleManager.isPhaseComplete(phase)) {
            throw new IllegalStateException("Cannot set property: '" + propertyName + "' once the server has already been through the " + phase + " phase.");
        }
    }

    @Override
    public MuleRegistry getRegistry() {
        return this.muleRegistryHelper;
    }

    @Override
    public Injector getInjector() {
        return this.injector;
    }

    @Override
    public ThreadingProfile getDefaultMessageDispatcherThreadingProfile() {
        return (ThreadingProfile)this.getRegistry().lookupObject("_defaultMessageDispatcherThreadingProfile");
    }

    @Override
    public ThreadingProfile getDefaultMessageRequesterThreadingProfile() {
        return (ThreadingProfile)this.getRegistry().lookupObject("_defaultMessageRequesterThreadingProfile");
    }

    @Override
    public ThreadingProfile getDefaultMessageReceiverThreadingProfile() {
        return (ThreadingProfile)this.getRegistry().lookupObject("_defaultMessageReceiverThreadingProfile");
    }

    @Override
    public ThreadingProfile getDefaultServiceThreadingProfile() {
        return (ThreadingProfile)this.getRegistry().lookupObject("_defaultServiceThreadingProfile");
    }

    @Override
    public StreamCloserService getStreamCloserService() {
        if (this.streamCloserService == null) {
            this.streamCloserService = (StreamCloserService)this.getRegistry().lookupObject("_muleStreamCloserService");
        }
        return this.streamCloserService;
    }

    @Override
    public ThreadingProfile getDefaultThreadingProfile() {
        return (ThreadingProfile)this.getRegistry().lookupObject("_defaultThreadingProfile");
    }

    @Override
    public long getStartDate() {
        return this.startDate;
    }

    @Override
    public ExpressionManager getExpressionManager() {
        return this.expressionManager;
    }

    @Override
    public void setExecutionClassLoader(ClassLoader cl) {
        this.executionClassLoader = cl;
    }

    @Override
    public ClassLoader getExecutionClassLoader() {
        return this.executionClassLoader;
    }

    @Override
    @Deprecated
    public void addRegistry(Registry registry) {
        this.registryBroker.addRegistry(registry);
    }

    @Override
    @Deprecated
    public void removeRegistry(Registry registry) {
        this.registryBroker.removeRegistry(registry);
    }

    protected SplashScreen buildStartupSplash() {
        SplashScreen startupScreen = this.config.isContainerMode() ? new ApplicationStartupSplashScreen() : new ServerStartupSplashScreen();
        startupScreen.setHeader(this);
        startupScreen.setFooter(this);
        return startupScreen;
    }

    protected SplashScreen buildShutdownSplash() {
        SplashScreen shutdownScreen = this.config.isContainerMode() ? new ApplicationShutdownSplashScreen() : new ServerShutdownSplashScreen();
        shutdownScreen.setHeader(this);
        return shutdownScreen;
    }

    @Override
    public LocalMuleClient getClient() {
        return this.localMuleClient;
    }

    @Override
    public void handleException(Exception e, RollbackSourceCallback rollbackMethod) {
        this.getExceptionListener().handleException(e, rollbackMethod);
    }

    @Override
    public void handleException(Exception e) {
        this.handleException(e, null);
    }

    @Override
    public SystemExceptionHandler getExceptionListener() {
        return this.exceptionListener;
    }

    @Override
    public void setExceptionListener(SystemExceptionHandler exceptionListener) {
        this.exceptionListener = exceptionListener;
    }

    @Override
    public EndpointFactory getEndpointFactory() {
        return (EndpointFactory)this.registryBroker.lookupObject("_muleEndpointFactory");
    }

    @Override
    public void setObjectStore(String name, ListableObjectStore<Serializable> store) throws RegistrationException {
        this.checkLifecycleForPropertySet(name, "initialise");
        this.registryBroker.registerObject(name, store);
    }

    @Override
    public String getClusterId() {
        return this.clusterConfiguration.getClusterId();
    }

    @Override
    public int getClusterNodeId() {
        return this.clusterConfiguration.getClusterNodeId();
    }

    public void setPollingController(PollingController pollingController) {
        this.pollingController = pollingController;
    }

    @Override
    public boolean isPrimaryPollingInstance() {
        return this.pollingController.isPrimaryPollingInstance();
    }

    @Override
    public String getUniqueIdString() {
        return this.clusterConfiguration.getClusterNodeId() + "-" + UUID.getUUID();
    }

    @Override
    public Map<QName, Set<Object>> getConfigurationAnnotations() {
        return this.configurationAnnotations;
    }

    @Override
    public MessagingExceptionHandler getDefaultExceptionStrategy() {
        MessagingExceptionHandler defaultExceptionStrategy;
        if (this.config.getDefaultExceptionStrategyName() != null) {
            defaultExceptionStrategy = (MessagingExceptionHandler)this.getRegistry().lookupObject(this.config.getDefaultExceptionStrategyName());
            if (defaultExceptionStrategy == null) {
                throw new MuleRuntimeException(CoreMessages.createStaticMessage(String.format("No global exception strategy named %s", this.config.getDefaultExceptionStrategyName())));
            }
        } else {
            defaultExceptionStrategy = new DefaultMessagingExceptionStrategy(this);
        }
        return defaultExceptionStrategy;
    }

    @Override
    public SingleResourceTransactionFactoryManager getTransactionFactoryManager() {
        return this.singleResourceTransactionFactoryManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataTypeConversionResolver getDataTypeConverterResolver() {
        if (this.dataTypeConversionResolver == null) {
            DefaultMuleContext defaultMuleContext = this;
            synchronized (defaultMuleContext) {
                if (this.dataTypeConversionResolver == null) {
                    this.dataTypeConversionResolver = (DataTypeConversionResolver)this.getRegistry().lookupObject("_converterResolver");
                    if (this.dataTypeConversionResolver == null) {
                        this.dataTypeConversionResolver = new DynamicDataTypeConversionResolver(this);
                        try {
                            this.getRegistry().registerObject("_converterResolver", this.dataTypeConversionResolver);
                        }
                        catch (RegistrationException e) {
                            throw new IllegalStateException(e);
                        }
                    }
                }
            }
        }
        return this.dataTypeConversionResolver;
    }

    @Override
    public ExpressionLanguage getExpressionLanguage() {
        if (this.expressionLanguage == null) {
            this.expressionLanguage = (ExpressionLanguage)this.registryBroker.lookupObject("_muleExpressionLanguage");
        }
        return this.expressionLanguage;
    }

    @Override
    public LockFactory getLockFactory() {
        if (this.lockFactory == null) {
            this.lockFactory = (LockFactory)this.registryBroker.get("_muleLockFactory");
        }
        return this.lockFactory;
    }

    @Override
    public ProcessingTimeWatcher getProcessorTimeWatcher() {
        if (this.processingTimeWatcher == null) {
            this.processingTimeWatcher = (ProcessingTimeWatcher)this.registryBroker.get("_muleProcessingTimeWatcher");
        }
        return this.processingTimeWatcher;
    }

    @Override
    public boolean waitUntilStarted(int timeout) throws InterruptedException {
        return this.startLatch.await(timeout, TimeUnit.MILLISECONDS);
    }

    private void overrideClusterConfiguration() {
        ClusterConfiguration overriddenClusterConfiguration = (ClusterConfiguration)this.getRegistry().get("_muleClusterConfiguration");
        if (overriddenClusterConfiguration != null) {
            this.clusterConfiguration = overriddenClusterConfiguration;
        }
    }

    private void overridePollingController() {
        PollingController overriddenPollingController = (PollingController)this.getRegistry().get("_mulePollingController");
        if (overriddenPollingController != null) {
            this.pollingController = overriddenPollingController;
        }
    }

    public void setMuleConfiguration(MuleConfiguration muleConfiguration) {
        this.config = muleConfiguration;
    }

    public void setWorkManager(WorkManager workManager) {
        this.workManager = workManager;
    }

    public void setworkListener(WorkListener workListener) {
        this.workListener = workListener;
    }

    public void setNotificationManager(ServerNotificationManager notificationManager) {
        this.notificationManager = notificationManager;
    }

    public void setLifecycleManager(MuleContextLifecycleManager lifecyleManager) {
        this.lifecycleManager = lifecyleManager;
    }

    public void setExpressionManager(DefaultExpressionManager expressionManager) {
        this.expressionManager = expressionManager;
    }

    public void setRegistryBroker(DefaultRegistryBroker registryBroker) {
        this.registryBroker = registryBroker;
    }

    public void setInjector(Injector injector) {
        this.injector = injector;
    }

    public void setMuleRegistry(MuleRegistryHelper muleRegistry) {
        this.muleRegistryHelper = muleRegistry;
    }

    public void setLocalMuleClient(DefaultLocalMuleClient localMuleContext) {
        this.localMuleClient = localMuleContext;
    }

    public void setExtensionManager(ExtensionManager extensionManager) {
        this.extensionManager = extensionManager;
    }

    public void setObjectSerializer(ObjectSerializer objectSerializer) {
        this.objectSerializer = objectSerializer;
    }
}

