/*
 * Decompiled with CFR 0.152.
 */
package org.mule.endpoint;

import java.beans.ExceptionListener;
import java.util.List;
import java.util.Map;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.construct.FlowConstructAware;
import org.mule.api.context.MuleContextAware;
import org.mule.api.endpoint.EndpointMessageProcessorChainFactory;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.exception.MessagingExceptionHandler;
import org.mule.api.exception.MessagingExceptionHandlerAcceptor;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.LifecycleException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.retry.RetryPolicyTemplate;
import org.mule.api.transaction.TransactionConfig;
import org.mule.api.transport.Connector;
import org.mule.config.MuleManifest;
import org.mule.config.i18n.CoreMessages;
import org.mule.endpoint.AbstractEndpoint;
import org.mule.exception.ChoiceMessagingExceptionStrategy;
import org.mule.exception.RollbackMessagingExceptionStrategy;
import org.mule.processor.AbstractRedeliveryPolicy;
import org.mule.transport.ConnectException;

public class DefaultInboundEndpoint
extends AbstractEndpoint
implements InboundEndpoint {
    private static final long serialVersionUID = -4752772777414636142L;
    private MessageProcessor listener;
    private FlowConstruct flowConstruct;
    private ExceptionListener exceptionListener;

    public DefaultInboundEndpoint(Connector connector, EndpointURI endpointUri, String name, Map properties, TransactionConfig transactionConfig, boolean deleteUnacceptedMessage, MessageExchangePattern messageExchangePattern, int responseTimeout, String initialState, String endpointEncoding, String endpointBuilderName, MuleContext muleContext, RetryPolicyTemplate retryPolicyTemplate, AbstractRedeliveryPolicy redeliveryPolicy, EndpointMessageProcessorChainFactory messageProcessorsFactory, List<MessageProcessor> messageProcessors, List<MessageProcessor> responseMessageProcessors, boolean disableTransportTransformer, String mimeType) {
        super(connector, endpointUri, name, properties, transactionConfig, deleteUnacceptedMessage, messageExchangePattern, responseTimeout, initialState, endpointEncoding, endpointBuilderName, muleContext, retryPolicyTemplate, redeliveryPolicy, messageProcessorsFactory, messageProcessors, responseMessageProcessors, disableTransportTransformer, mimeType);
    }

    @Override
    public MuleMessage request(long timeout) throws Exception {
        if (this.getConnector() != null) {
            return this.getConnector().request(this, timeout);
        }
        throw new IllegalStateException("The connector on the endpoint: " + this.toString() + " is null. Please contact " + MuleManifest.getDevListEmail());
    }

    @Override
    public void setListener(MessageProcessor listener) {
        this.listener = listener;
    }

    @Override
    public void start() throws MuleException {
        try {
            if (this.getMessageProcessorChain(this.flowConstruct) instanceof Startable) {
                ((Startable)((Object)this.getMessageProcessorChain(this.flowConstruct))).start();
            }
            this.getConnector().registerListener(this, this.getMessageProcessorChain(this.flowConstruct), this.flowConstruct);
            MessageProcessor polledMp = this.getPolledMessageProcessor();
            if (polledMp instanceof Startable) {
                ((Startable)((Object)polledMp)).start();
            }
        }
        catch (ConnectException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new LifecycleException(CoreMessages.failedToStartInboundEndpoint(this), e, this);
        }
    }

    @Override
    public void stop() throws MuleException {
        try {
            MessageProcessor polledMp;
            this.getConnector().unregisterListener(this, this.flowConstruct);
            if (this.getMessageProcessorChain(this.flowConstruct) instanceof Stoppable) {
                ((Stoppable)((Object)this.getMessageProcessorChain(this.flowConstruct))).stop();
            }
            if ((polledMp = this.getPolledMessageProcessor()) instanceof Stoppable) {
                ((Stoppable)((Object)polledMp)).stop();
            }
        }
        catch (Exception e) {
            throw new LifecycleException(CoreMessages.failedToStopInboundEndpoint(this), e, this);
        }
    }

    @Override
    public MessageProcessor createMessageProcessorChain(FlowConstruct flowContruct) throws MuleException {
        MessageProcessor polledMp;
        EndpointMessageProcessorChainFactory factory = this.getMessageProcessorsFactory();
        MessageProcessor processorChain = factory.createInboundMessageProcessorChain(this, this.flowConstruct, this.listener);
        if (processorChain instanceof MuleContextAware) {
            ((MuleContextAware)((Object)processorChain)).setMuleContext(this.getMuleContext());
        }
        if (processorChain instanceof FlowConstructAware) {
            ((FlowConstructAware)((Object)processorChain)).setFlowConstruct(flowContruct);
        }
        if (processorChain instanceof Initialisable) {
            ((Initialisable)((Object)processorChain)).initialise();
        }
        if ((polledMp = this.getPolledMessageProcessor()) instanceof MuleContextAware) {
            ((MuleContextAware)((Object)polledMp)).setMuleContext(this.getMuleContext());
        }
        if (polledMp instanceof FlowConstructAware) {
            ((FlowConstructAware)((Object)polledMp)).setFlowConstruct(flowContruct);
        }
        if (polledMp instanceof Initialisable) {
            ((Initialisable)((Object)polledMp)).initialise();
        }
        return processorChain;
    }

    protected MessageProcessor getPolledMessageProcessor() {
        return (MessageProcessor)this.getProperty("MULE_ENDPOINT__sourceMessageProcessor");
    }

    @Override
    public void setFlowConstruct(FlowConstruct flowConstruct) {
        this.flowConstruct = flowConstruct;
    }

    public ExceptionListener getExceptionListener() {
        return this.exceptionListener;
    }

    public void setExceptionListener(ExceptionListener exceptionListener) {
        this.exceptionListener = exceptionListener;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.flowConstruct = null;
        this.listener = null;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public AbstractRedeliveryPolicy getRedeliveryPolicy() {
        AbstractRedeliveryPolicy redeliveryPolicy = super.getRedeliveryPolicy();
        RollbackMessagingExceptionStrategy rollbackMessagingExceptionStrategy = null;
        if (this.flowConstruct != null && this.flowConstruct.getExceptionListener() != null) {
            MessagingExceptionHandler exceptionListener = this.flowConstruct.getExceptionListener();
            if (exceptionListener instanceof RollbackMessagingExceptionStrategy) {
                rollbackMessagingExceptionStrategy = (RollbackMessagingExceptionStrategy)exceptionListener;
            } else if (exceptionListener instanceof ChoiceMessagingExceptionStrategy) {
                ChoiceMessagingExceptionStrategy choiceMessagingExceptionStrategy = (ChoiceMessagingExceptionStrategy)exceptionListener;
                for (MessagingExceptionHandlerAcceptor messagingExceptionHandlerAcceptor : choiceMessagingExceptionStrategy.getExceptionListeners()) {
                    if (!(messagingExceptionHandlerAcceptor instanceof RollbackMessagingExceptionStrategy) || !((RollbackMessagingExceptionStrategy)messagingExceptionHandlerAcceptor).hasMaxRedeliveryAttempts()) continue;
                    rollbackMessagingExceptionStrategy = (RollbackMessagingExceptionStrategy)messagingExceptionHandlerAcceptor;
                    break;
                }
            }
        }
        if (rollbackMessagingExceptionStrategy != null && rollbackMessagingExceptionStrategy.hasMaxRedeliveryAttempts()) {
            if (redeliveryPolicy == null) {
                redeliveryPolicy = this.createDefaultRedeliveryPolicy(rollbackMessagingExceptionStrategy.getMaxRedeliveryAttempts());
            } else {
                redeliveryPolicy.setMaxRedeliveryCount(rollbackMessagingExceptionStrategy.getMaxRedeliveryAttempts());
            }
        }
        return redeliveryPolicy;
    }

    @Override
    public AbstractRedeliveryPolicy createDefaultRedeliveryPolicy(int maxRedelivery) {
        return this.getConnector().createDefaultRedeliveryPolicy(maxRedelivery);
    }

    public FlowConstruct getFlowConstruct() {
        return this.flowConstruct;
    }
}

