/*
 * Decompiled with CFR 0.152.
 */
package org.mule.processor;

import java.util.List;
import org.mule.DefaultMuleEvent;
import org.mule.OptimizedRequestContext;
import org.mule.VoidMuleEvent;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.NonBlockingSupported;
import org.mule.api.processor.InterceptingMessageProcessor;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.processor.MessageProcessorContainer;
import org.mule.api.transport.ReplyToHandler;
import org.mule.execution.MessageProcessorExecutionTemplate;
import org.mule.processor.BlockingProcessorExecutor;
import org.mule.processor.NonBlockingMessageProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NonBlockingProcessorExecutor
extends BlockingProcessorExecutor {
    private static final Logger logger = LoggerFactory.getLogger(NonBlockingProcessorExecutor.class);
    private final ReplyToHandler replyToHandler;

    public NonBlockingProcessorExecutor(MuleEvent event, List<MessageProcessor> processors, MessageProcessorExecutionTemplate executionTemplate, boolean copyOnVoidEvent) {
        super(event, processors, executionTemplate, copyOnVoidEvent);
        this.replyToHandler = event.getReplyToHandler();
    }

    @Override
    protected void preProcess(MessageProcessor processor) {
        if (this.event.isAllowNonBlocking() && this.replyToHandler != null) {
            if (!this.processorSupportsNonBlocking(processor)) {
                logger.info("The message processor {} does not currently support non-blocking execution and processing will now fall back to blocking.  The 'non-blocking' processing strategy is not recommended if unsupported message processors are being used.  ", processor.getClass());
                this.event = new DefaultMuleEvent(this.event.getMessage(), this.event, true);
            }
            if (processor instanceof NonBlockingMessageProcessor) {
                this.event = new DefaultMuleEvent(this.event, new NonBlockingProcessorExecutorReplyToHandler());
            }
            OptimizedRequestContext.unsafeSetEvent(this.event);
        }
    }

    private boolean processorSupportsNonBlocking(MessageProcessor processor) {
        if (processor instanceof NonBlockingSupported) {
            return true;
        }
        return !(processor instanceof MessageProcessorContainer) && !(processor instanceof InterceptingMessageProcessor);
    }

    private void resume() throws MessagingException {
        MuleEvent result = this.execute();
        if (result != null && !(result instanceof VoidMuleEvent)) {
            try {
                this.replyToHandler.processReplyTo(result, null, null);
            }
            catch (MuleException e) {
                this.replyToHandler.processExceptionReplyTo(new MessagingException(this.event, (Throwable)e), null);
            }
        }
    }

    class NonBlockingProcessorExecutorReplyToHandler
    implements ReplyToHandler {
        NonBlockingProcessorExecutorReplyToHandler() {
        }

        @Override
        public void processReplyTo(MuleEvent event, MuleMessage returnMessage, Object replyTo) throws MuleException {
            NonBlockingProcessorExecutor.this.event = new DefaultMuleEvent(event, NonBlockingProcessorExecutor.this.replyToHandler);
            OptimizedRequestContext.unsafeSetEvent(event);
            try {
                NonBlockingProcessorExecutor.this.resume();
            }
            catch (MessagingException e) {
                this.processExceptionReplyTo(e, replyTo);
            }
        }

        @Override
        public void processExceptionReplyTo(MessagingException exception, Object replyTo) {
            NonBlockingProcessorExecutor.this.replyToHandler.processExceptionReplyTo(exception, replyTo);
        }
    }
}

