/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.queue;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleRuntimeException;
import org.mule.util.queue.QueueFileProvider;

public class QueueControlDataFile {
    private final Log logger = LogFactory.getLog(this.getClass());
    public static final int INTEGER_SIZE_IN_BYTES = 4;
    private final QueueFileProvider queueFileProvider;
    private File currentReadFilePath;
    private File currentWriteFilePath;

    public QueueControlDataFile(QueueFileProvider queueFileProvider, File firstFile, File secondFile) {
        this.queueFileProvider = queueFileProvider;
        if (queueFileProvider.isNewFile()) {
            this.currentWriteFilePath = firstFile;
            this.currentReadFilePath = firstFile;
            this.writeControlData(this.currentWriteFilePath, this.currentReadFilePath);
        } else {
            try {
                this.currentWriteFilePath = this.getStoredFile();
                this.currentReadFilePath = this.getStoredFile();
            }
            catch (Exception e) {
                File lastUpdatedFile;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("failure reading queue control data from file " + queueFileProvider.getFile().getAbsolutePath()), (Throwable)e);
                }
                this.currentWriteFilePath = lastUpdatedFile = firstFile.lastModified() > secondFile.lastModified() ? firstFile : secondFile;
                this.currentReadFilePath = firstFile == lastUpdatedFile ? secondFile : firstFile;
            }
        }
    }

    public void writeControlData(File writeFile, File readFile) {
        try {
            this.queueFileProvider.getRandomAccessFile().seek(0L);
            String writeFilePath = writeFile.getAbsolutePath();
            String readFilePath = readFile.getAbsolutePath();
            ByteBuffer controlDataBuffer = ByteBuffer.allocate(writeFilePath.length() + 4 + readFilePath.length() + 4);
            controlDataBuffer.putInt(writeFilePath.length());
            controlDataBuffer.put(writeFilePath.getBytes());
            controlDataBuffer.putInt(readFilePath.length());
            controlDataBuffer.put(readFilePath.getBytes());
            this.queueFileProvider.getRandomAccessFile().write(controlDataBuffer.array());
            this.currentReadFilePath = readFile;
            this.currentWriteFilePath = writeFile;
        }
        catch (IOException e) {
            throw new MuleRuntimeException(e);
        }
    }

    public File getCurrentReadFile() {
        return this.currentReadFilePath;
    }

    public File getCurrentWriteFile() {
        return this.currentWriteFilePath;
    }

    private File getStoredFile() throws IOException {
        return new File(this.readStringFromFile());
    }

    private String readStringFromFile() throws IOException {
        int stringSize = this.queueFileProvider.getRandomAccessFile().readInt();
        byte[] stringAsBytes = new byte[stringSize];
        this.queueFileProvider.getRandomAccessFile().read(stringAsBytes);
        return new String(stringAsBytes);
    }

    QueueFileProvider getQueueFileProvider() {
        return this.queueFileProvider;
    }

    public void close() {
        block2: {
            try {
                this.queueFileProvider.close();
            }
            catch (IOException e) {
                this.logger.warn((Object)("failure closing queue data control file: " + e.getMessage()));
                if (!this.logger.isDebugEnabled()) break block2;
                this.logger.debug((Object)e);
            }
        }
    }
}

