/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.config.resolver.query;

import org.mule.api.MuleContext;
import org.mule.api.context.MuleContextAware;
import org.mule.module.db.internal.domain.query.Query;
import org.mule.module.db.internal.parser.SimpleQueryTemplateParser;
import org.mule.module.db.internal.resolver.database.DbConfigResolver;
import org.mule.module.db.internal.resolver.param.ParamValueResolver;
import org.mule.module.db.internal.resolver.query.DynamicQueryResolver;
import org.mule.module.db.internal.resolver.query.ParametrizedQueryResolver;
import org.mule.module.db.internal.resolver.query.QueryResolver;
import org.mule.module.db.internal.resolver.query.StaticQueryResolver;
import org.springframework.beans.factory.FactoryBean;

public class QueryResolverFactoryBean
implements FactoryBean<QueryResolver>,
MuleContextAware {
    private final Query query;
    private final ParamValueResolver paramValueResolver;
    private final DbConfigResolver dbConfigResolver;
    private MuleContext muleContext;

    public QueryResolverFactoryBean(Query query, ParamValueResolver paramValueResolver, DbConfigResolver dbConfigResolver) {
        this.query = query;
        this.paramValueResolver = paramValueResolver;
        this.dbConfigResolver = dbConfigResolver;
    }

    public QueryResolver getObject() throws Exception {
        if (this.isDynamic(this.query)) {
            return new DynamicQueryResolver(this.query, new SimpleQueryTemplateParser(), this.muleContext.getExpressionManager());
        }
        if (this.hasParameters(this.query)) {
            return new ParametrizedQueryResolver(this.query, this.paramValueResolver);
        }
        return new StaticQueryResolver(this.query);
    }

    private boolean isDynamic(Query query) {
        return query.getQueryTemplate().isDynamic();
    }

    private boolean hasParameters(Query query) {
        return query.getQueryTemplate().getParams().size() > 0;
    }

    public Class<?> getObjectType() {
        return QueryResolver.class;
    }

    public boolean isSingleton() {
        return false;
    }

    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }
}

