/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.internal.listener.grizzly;

import java.io.IOException;
import java.net.InetSocketAddress;
import javax.net.ssl.SSLSession;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.util.HttpStatus;
import org.mule.module.http.api.HttpConstants;
import org.mule.module.http.internal.domain.InputStreamHttpEntity;
import org.mule.module.http.internal.domain.request.ClientConnection;
import org.mule.module.http.internal.domain.request.HttpRequestContext;
import org.mule.module.http.internal.domain.response.HttpResponse;
import org.mule.module.http.internal.listener.RequestHandlerProvider;
import org.mule.module.http.internal.listener.async.HttpResponseReadyCallback;
import org.mule.module.http.internal.listener.async.RequestHandler;
import org.mule.module.http.internal.listener.async.ResponseStatusCallback;
import org.mule.module.http.internal.listener.grizzly.GrizzlyHttpRequestAdapter;
import org.mule.module.http.internal.listener.grizzly.ResponseCompletionHandler;
import org.mule.module.http.internal.listener.grizzly.ResponseStreamingCompletionHandler;

public class GrizzlyRequestDispatcherFilter
extends BaseFilter {
    private final RequestHandlerProvider requestHandlerProvider;

    GrizzlyRequestDispatcherFilter(RequestHandlerProvider requestHandlerProvider) {
        this.requestHandlerProvider = requestHandlerProvider;
    }

    public NextAction handleRead(final FilterChainContext ctx) throws IOException {
        String scheme = ctx.getAttributes().getAttribute(HttpConstants.Protocols.HTTPS.getScheme()) == null ? HttpConstants.Protocols.HTTP.getScheme() : HttpConstants.Protocols.HTTPS.getScheme();
        String ip = ((InetSocketAddress)ctx.getConnection().getLocalAddress()).getAddress().getHostAddress();
        int port = ((InetSocketAddress)ctx.getConnection().getLocalAddress()).getPort();
        HttpContent httpContent = (HttpContent)ctx.getMessage();
        final HttpRequestPacket request = (HttpRequestPacket)httpContent.getHttpHeader();
        if (request.requiresAcknowledgement()) {
            HttpResponsePacket.Builder responsePacketBuilder = HttpResponsePacket.builder((HttpRequestPacket)request);
            if ("100-continue".equalsIgnoreCase(request.getHeader("Expect"))) {
                responsePacketBuilder.status(HttpStatus.CONINTUE_100.getStatusCode());
                HttpResponsePacket packet = responsePacketBuilder.build();
                packet.setAcknowledgement(true);
                ctx.write((Object)packet);
                return ctx.getStopAction();
            }
            responsePacketBuilder.status(HttpStatus.EXPECTATION_FAILED_417.getStatusCode());
            ctx.write((Object)responsePacketBuilder.build());
            return ctx.getStopAction();
        }
        GrizzlyHttpRequestAdapter httpRequest = new GrizzlyHttpRequestAdapter(ctx, httpContent);
        HttpRequestContext requestContext = this.createRequestContext(ctx, scheme, httpRequest);
        RequestHandler requestHandler = this.requestHandlerProvider.getRequestHandler(ip, port, httpRequest);
        requestHandler.handleRequest(requestContext, new HttpResponseReadyCallback(){

            @Override
            public void responseReady(HttpResponse httpResponse, ResponseStatusCallback responseStatusCallback) {
                try {
                    if (httpResponse.getEntity() instanceof InputStreamHttpEntity) {
                        new ResponseStreamingCompletionHandler(ctx, request, httpResponse, responseStatusCallback).start();
                    } else {
                        new ResponseCompletionHandler(ctx, request, httpResponse, responseStatusCallback).start();
                    }
                }
                catch (Exception e) {
                    responseStatusCallback.responseSendFailure(e);
                }
            }
        });
        return ctx.getSuspendAction();
    }

    private HttpRequestContext createRequestContext(FilterChainContext ctx, String scheme, GrizzlyHttpRequestAdapter httpRequest) {
        SSLSession sslSession = (SSLSession)ctx.getAttributes().getAttribute("muleSslSession");
        ClientConnection clientConnection = sslSession != null ? new ClientConnection(sslSession, (InetSocketAddress)ctx.getConnection().getPeerAddress()) : new ClientConnection((InetSocketAddress)ctx.getConnection().getPeerAddress());
        return new HttpRequestContext(httpRequest, clientConnection, scheme);
    }
}

