/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.servlet.jetty;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.continuation.Continuation;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.execution.EndPhaseTemplate;
import org.mule.transport.AbstractMessageReceiver;
import org.mule.transport.servlet.jetty.JettyMessageProcessTemplate;

public class JettyContinuationsMessageProcessTemplate
extends JettyMessageProcessTemplate
implements EndPhaseTemplate {
    private final Continuation continuation;
    private MuleEvent responseForClient;
    private MessagingException failureResponseForClient;
    private boolean emptyResponseReceived;
    private boolean discardMessage;

    public JettyContinuationsMessageProcessTemplate(HttpServletRequest request, HttpServletResponse response, AbstractMessageReceiver messageReceiver, MuleContext muleContext, Continuation continuation) {
        super(request, response, messageReceiver, muleContext);
        this.continuation = continuation;
    }

    @Override
    public void sendResponseToClient(MuleEvent muleEvent) throws MuleException {
        if (muleEvent == null) {
            this.emptyResponseReceived = true;
        } else {
            this.responseForClient = muleEvent;
        }
    }

    @Override
    public void sendFailureResponseToClient(MessagingException messagingException) throws MuleException {
        this.failureResponseForClient = messagingException;
    }

    public void completeProcessingRequest() {
        try {
            if (this.discardMessage) {
                super.discardMessageOnThrottlingExceeded();
            } else if (this.emptyResponseReceived) {
                this.getServletResponseWriter().writeEmptyResponse(this.getServletResponse(), null);
            } else if (this.responseForClient != null) {
                super.sendResponseToClient(this.responseForClient);
            } else {
                super.sendFailureResponseToClient(this.failureResponseForClient);
            }
        }
        catch (Exception e) {
            this.getMuleContext().getExceptionListener().handleException(e);
        }
    }

    @Override
    public void discardMessageOnThrottlingExceeded() throws MuleException {
        this.discardMessage = true;
    }

    public void messageProcessingEnded() {
        this.continuation.resume();
    }
}

