/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.sftp;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleRuntimeException;
import org.mule.transport.sftp.SftpInputStream;
import org.mule.transport.sftp.SftpStream;
import org.mule.util.FileUtils;

public class SftpFileArchiveInputStream
extends FileInputStream
implements SftpStream {
    private static final Log logger = LogFactory.getLog(SftpFileArchiveInputStream.class);
    private File file;
    private File archiveFile;
    private final SftpInputStream remoteStream;
    private boolean errorOccured = false;
    private boolean postProcessOnClose = false;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private static final int LOG_BYTE_INTERVAL = 10000000;
    private long bytesRead = 0L;
    private long nextLevelToLogBytesRead = 10000000L;

    public SftpFileArchiveInputStream(File file, SftpInputStream remoteStream) throws FileNotFoundException {
        super(file);
        this.file = file;
        this.archiveFile = null;
        this.remoteStream = remoteStream;
    }

    public SftpFileArchiveInputStream(File file, File archiveFile, SftpInputStream sftpInputStream) throws FileNotFoundException {
        this(file, sftpInputStream);
        this.archiveFile = archiveFile;
    }

    @Override
    public int read() throws IOException {
        this.logReadBytes(1);
        return super.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.logReadBytes(len);
        return super.read(b, off, len);
    }

    @Override
    public int read(byte[] b) throws IOException {
        this.logReadBytes(b.length);
        return super.read(b);
    }

    @Override
    public void close() throws IOException {
        if (!this.closed.compareAndSet(false, true)) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Closing the stream for the file " + this.file));
        }
        super.close();
        this.remoteStream.close();
        if (this.postProcessOnClose) {
            try {
                this.postProcess();
            }
            catch (Exception e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed.get();
    }

    @Override
    public void postProcess() throws Exception {
        if (!this.errorOccured) {
            this.remoteStream.postProcess();
        } else {
            this.remoteStream.releaseConnection();
        }
        if (!this.errorOccured && this.archiveFile != null) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Move archiveTmpSendingFile (" + this.file + ") to archiveFolder (" + this.archiveFile + ")..."));
            }
            FileUtils.moveFile((File)this.file, (File)this.archiveFile);
        }
    }

    @Override
    public void setErrorOccurred() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"setErrorOccurred() called");
        }
        this.errorOccured = true;
    }

    @Override
    public void performPostProcessingOnClose(boolean postProcessOnClose) {
        this.postProcessOnClose = postProcessOnClose;
    }

    private void logReadBytes(int newBytesRead) {
        if (!logger.isDebugEnabled()) {
            return;
        }
        this.bytesRead += (long)newBytesRead;
        if (this.bytesRead >= this.nextLevelToLogBytesRead) {
            logger.debug((Object)("Read " + this.bytesRead + " bytes and couting..."));
            this.nextLevelToLogBytesRead += 10000000L;
        }
    }
}

