/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.sftp;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.transport.sftp.ErrorOccurredDecorator;
import org.mule.transport.sftp.SftpClient;
import org.mule.transport.sftp.SftpConnector;

public class SftpUtil {
    private static final Logger logger = Logger.getLogger(SftpUtil.class);
    private SftpConnector connector;
    private ImmutableEndpoint endpoint;
    private static final String DUPLICATE_HANDLING_DEFAULT = "throwException";
    private static final boolean KEEP_FILE_ON_ERROR_DEFAULT = true;
    private static final boolean USE_TEMP_FILE_TIMESTAMP_SUFFIX_DEFAULT = false;
    private static final long SIZE_CHECK_WAIT_TIME_DEFAULT = -1L;
    private static final Object lock = new Object();

    public SftpUtil(ImmutableEndpoint endpoint) {
        this.endpoint = endpoint;
        this.connector = (SftpConnector)endpoint.getConnector();
    }

    public String createUniqueSuffix(String filename) {
        SimpleDateFormat timestampFormatter = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        String timstampStr = '_' + timestampFormatter.format(new Date());
        int fileTypeIdx = filename.lastIndexOf(46);
        if (fileTypeIdx != -1) {
            String fileType = filename.substring(fileTypeIdx);
            filename = filename.substring(0, fileTypeIdx);
            return filename + timstampStr + fileType;
        }
        return filename + timstampStr;
    }

    public String getTempDirInbound() {
        String endpointValue = (String)this.endpoint.getProperty((Object)"tempDir");
        if (endpointValue != null) {
            return endpointValue;
        }
        String connectorValue = this.connector.getTempDirInbound();
        if (connectorValue != null) {
            return connectorValue;
        }
        return null;
    }

    public boolean isUseTempDirInbound() {
        return this.getTempDirInbound() != null;
    }

    public String getTempDirOutbound() {
        String endpointValue = (String)this.endpoint.getProperty((Object)"tempDir");
        if (endpointValue != null) {
            return endpointValue;
        }
        String connectorValue = this.connector.getTempDirOutbound();
        if (connectorValue != null) {
            return connectorValue;
        }
        return null;
    }

    public boolean isUseTempDirOutbound() {
        return this.getTempDirOutbound() != null;
    }

    public void cleanupTempDir(SftpClient sftpClient, String transferFileName, String tempDir) {
        String tempDirAbs = sftpClient.getAbsolutePath(this.endpoint.getEndpointURI().getPath() + "/" + tempDir);
        try {
            sftpClient.changeWorkingDirectory(tempDirAbs);
            sftpClient.deleteFile(transferFileName);
        }
        catch (Exception e) {
            logger.error((Object)("Could not delete the file '" + transferFileName + "' from the temp directory '" + tempDirAbs + "'"), (Throwable)e);
        }
    }

    public long getSizeCheckWaitTime() {
        Object endpointValue = this.endpoint.getProperty((Object)"sizeCheckWaitTime");
        if (endpointValue != null) {
            return Long.valueOf((String)endpointValue);
        }
        Long connectorValue = this.connector.getSizeCheckWaitTime();
        if (connectorValue != null) {
            return connectorValue;
        }
        return -1L;
    }

    public String getArchiveDir() {
        String endpointValue = (String)this.endpoint.getProperty((Object)"archiveDir");
        if (endpointValue != null) {
            return endpointValue;
        }
        String connectorValue = this.connector.getArchiveDir();
        if (connectorValue != null) {
            return connectorValue;
        }
        return null;
    }

    public String getArchiveTempReceivingDir() {
        String endpointValue = (String)this.endpoint.getProperty((Object)"archiveTempReceivingDir");
        if (endpointValue != null) {
            return endpointValue;
        }
        String connectorValue = this.connector.getArchiveTempReceivingDir();
        if (connectorValue != null) {
            return connectorValue;
        }
        return null;
    }

    public String getArchiveTempSendingDir() {
        String endpointValue = (String)this.endpoint.getProperty((Object)"archiveTempSendingDir");
        if (endpointValue != null) {
            return endpointValue;
        }
        String connectorValue = this.connector.getArchiveTempSendingDir();
        if (connectorValue != null) {
            return connectorValue;
        }
        return null;
    }

    public boolean isUseTempFileTimestampSuffix() {
        Object endpointValue = this.endpoint.getProperty((Object)"useTempFileTimestampSuffix");
        if (endpointValue != null) {
            return Boolean.valueOf((String)endpointValue);
        }
        Boolean connectorValue = this.connector.isUseTempFileTimestampSuffix();
        if (connectorValue != null) {
            return connectorValue;
        }
        return false;
    }

    public String getDuplicateHandling() {
        String endpointValue = (String)this.endpoint.getProperty((Object)"duplicateHandling");
        if (endpointValue != null) {
            return endpointValue;
        }
        String connectorValue = this.connector.getDuplicateHandling();
        if (connectorValue != null) {
            return connectorValue;
        }
        return DUPLICATE_HANDLING_DEFAULT;
    }

    public String getIdentityFile() {
        String endpointValue = (String)this.endpoint.getProperty((Object)"identityFile");
        if (endpointValue != null) {
            return endpointValue;
        }
        String connectorValue = this.connector.getIdentityFile();
        if (connectorValue != null) {
            return connectorValue;
        }
        return null;
    }

    public String getPassphrase() {
        String endpointValue = (String)this.endpoint.getProperty((Object)"passphrase");
        if (endpointValue != null) {
            return endpointValue;
        }
        String connectorValue = this.connector.getPassphrase();
        if (connectorValue != null) {
            return connectorValue;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cwdToTempDirOnOutbound(SftpClient sftpClient, String endpointDir) throws IOException {
        String tempDir = this.getTempDirOutbound();
        String tempDirAbs = sftpClient.getAbsolutePath(endpointDir + "/" + tempDir);
        Object object = lock;
        synchronized (object) {
            try {
                sftpClient.changeWorkingDirectory(tempDirAbs);
            }
            catch (IOException e) {
                logger.info((Object)("Got an exception when trying to change the working directory to the temp dir. Will try to create the directory " + tempDirAbs));
                sftpClient.changeWorkingDirectory(endpointDir);
                sftpClient.mkdir(tempDir);
                sftpClient.changeWorkingDirectory(tempDirAbs);
            }
        }
    }

    public boolean isKeepFileOnError() {
        Object endpointValue = this.endpoint.getProperty((Object)"keepFileOnError");
        if (endpointValue != null) {
            return Boolean.valueOf((String)endpointValue);
        }
        Boolean connectorValue = this.connector.isKeepFileOnError();
        if (connectorValue != null) {
            return connectorValue;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void copyStreamToFile(InputStream input, File destination) throws IOException {
        try {
            File folder = destination.getParentFile();
            if (!folder.exists()) {
                throw new IOException("Destination folder does not exist: " + folder);
            }
            if (!folder.canWrite()) {
                throw new IOException("Destination folder is not writeable: " + folder);
            }
            try (FileOutputStream output = new FileOutputStream(destination);){
                IOUtils.copy((InputStream)input, (OutputStream)output);
            }
        }
        catch (IOException ex) {
            this.setErrorOccurredOnInputStream(input);
            throw ex;
        }
        catch (RuntimeException ex) {
            this.setErrorOccurredOnInputStream(input);
            throw ex;
        }
        finally {
            if (input != null) {
                input.close();
            }
        }
    }

    public void setErrorOccurredOnInputStream(InputStream inputStream) {
        if (this.isKeepFileOnError() && inputStream != null) {
            if (inputStream instanceof ErrorOccurredDecorator) {
                ((ErrorOccurredDecorator)((Object)inputStream)).setErrorOccurred();
            } else {
                logger.warn((Object)("Class " + inputStream.getClass().getName() + " did not implement the 'ErrorOccurred' decorator, errorOccured=true could not be set."));
            }
        }
    }
}

