/*
 * Decompiled with CFR 0.152.
 */
package org.mule.el.mvel;

import java.util.HashMap;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleEvent;
import org.mule.api.el.ExpressionLanguage;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class MVELMapHandlingTestCase
extends AbstractMuleContextTestCase {
    private static final String KEY = "Name";
    private static final String VALUE = "MG";
    private ExpressionLanguage el;

    @Override
    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.el = muleContext.getExpressionLanguage();
    }

    @Test
    public void keyWithNonNullValue() throws Exception {
        HashMap<String, String> payload = new HashMap<String, String>();
        payload.put(KEY, VALUE);
        this.assertMapKey(payload, KEY, (Object)VALUE);
    }

    @Test
    public void keyWithNullValue() throws Exception {
        HashMap payload = new HashMap();
        this.assertMapKey(payload, KEY, null);
    }

    @Test
    public void keyWithNullableValue() throws Exception {
        HashMap<String, String> payload = new HashMap<String, String>();
        payload.put(KEY, VALUE);
        MuleEvent event = MVELMapHandlingTestCase.getTestEvent(payload);
        this.assertMapKey(event, KEY, (Object)VALUE);
        payload.remove(KEY);
        this.assertMapKey(event, KEY, (Object)null);
    }

    @Test
    public void nullKeyWhichGetsValueLater() throws Exception {
        HashMap<String, String> payload = new HashMap<String, String>();
        MuleEvent event = MVELMapHandlingTestCase.getTestEvent(payload);
        this.assertMapKey(event, KEY, (Object)null);
        payload.put(KEY, VALUE);
        this.assertMapKey(event, KEY, (Object)VALUE);
    }

    private void assertMapKey(Object payload, String key, Object expectedValue) throws Exception {
        this.assertMapKey(MVELMapHandlingTestCase.getTestEvent(payload), key, expectedValue);
    }

    private void assertMapKey(MuleEvent event, String key, Object expectedValue) throws Exception {
        this.runExpressionAndExpect(String.format("#[payload.%s]", key), expectedValue, event);
        this.runExpressionAndExpect(String.format("#[payload['%s']]", key), expectedValue, event);
        this.runExpressionAndExpect(String.format("#[payload.'%s']", key), expectedValue, event);
    }

    private void runExpressionAndExpect(String expression, Object expectedValue, MuleEvent event) {
        Object result = this.el.evaluate(expression, event);
        Assert.assertThat((String)String.format("Expression %s returned unexpected value", expression), (Object)result, (Matcher)CoreMatchers.equalTo((Object)expectedValue));
    }
}

