/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.MuleMessageCollection;
import org.mule.api.MuleSession;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.routing.outbound.AbstractMessageSplitter;
import org.mule.routing.outbound.OutboundRoutingTestEvent;
import org.mule.routing.outbound.RouterTestUtils;
import org.mule.routing.outbound.SplitMessage;
import org.mule.tck.MuleEventCheckAnswer;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class MessageSplitterRouterTestCase
extends AbstractMuleContextTestCase {
    public MessageSplitterRouterTestCase() {
        this.setStartContext(true);
    }

    @Test
    public void testMessageSplitterRouter() throws Exception {
        OutboundEndpoint endpoint1 = MessageSplitterRouterTestCase.getTestOutboundEndpoint("Test1Endpoint", "test://endpointUri.1");
        OutboundEndpoint mockendpoint1 = RouterTestUtils.createMockEndpoint(endpoint1);
        OutboundEndpoint endpoint2 = MessageSplitterRouterTestCase.getTestOutboundEndpoint("Test2Endpoint", "test://endpointUri.2");
        OutboundEndpoint mockendpoint2 = RouterTestUtils.createMockEndpoint(endpoint2);
        OutboundEndpoint endpoint3 = MessageSplitterRouterTestCase.getTestOutboundEndpoint("Test3Endpoint", "test://endpointUri.3");
        OutboundEndpoint mockendpoint3 = RouterTestUtils.createMockEndpoint(endpoint3);
        OutboundEndpoint endpoint4 = MessageSplitterRouterTestCase.getTestOutboundEndpoint("Test4Endpoint", "test://endpointUri.4?exchangePattern=request-response");
        OutboundEndpoint mockendpoint4 = RouterTestUtils.createMockEndpoint(endpoint4);
        OutboundEndpoint endpoint5 = MessageSplitterRouterTestCase.getTestOutboundEndpoint("Test5Endpoint", "test://endpointUri.5?exchangePattern=request-response");
        OutboundEndpoint mockendpoint5 = RouterTestUtils.createMockEndpoint(endpoint5);
        OutboundEndpoint endpoint6 = MessageSplitterRouterTestCase.getTestOutboundEndpoint("Test6Endpoint", "test://endpointUri.6?exchangePattern=request-response");
        OutboundEndpoint mockendpoint6 = RouterTestUtils.createMockEndpoint(endpoint6);
        AbstractMessageSplitter router = new AbstractMessageSplitter(){

            protected SplitMessage getMessageParts(MuleMessage message, List<MessageProcessor> endpoints) {
                int i = 0;
                SplitMessage splitMessage = new SplitMessage();
                StringTokenizer tokenizer = new StringTokenizer(message.getPayload().toString(), ",");
                while (tokenizer.hasMoreTokens()) {
                    String s = tokenizer.nextToken();
                    splitMessage.addPart((Object)s, (OutboundEndpoint)endpoints.get(i));
                    ++i;
                }
                return splitMessage;
            }
        };
        router.setMuleContext(muleContext);
        ArrayList<OutboundEndpoint> endpoints = new ArrayList<OutboundEndpoint>();
        endpoints.add(mockendpoint1);
        endpoints.add(mockendpoint2);
        endpoints.add(mockendpoint3);
        router.setRoutes(endpoints);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test,mule,message", muleContext);
        Assert.assertTrue((boolean)router.isMatch((MuleMessage)message));
        Mockito.when((Object)mockendpoint1.process((MuleEvent)Matchers.any(MuleEvent.class))).thenAnswer((Answer)new MuleEventCheckAnswer());
        Mockito.when((Object)mockendpoint2.process((MuleEvent)Matchers.any(MuleEvent.class))).thenAnswer((Answer)new MuleEventCheckAnswer());
        Mockito.when((Object)mockendpoint3.process((MuleEvent)Matchers.any(MuleEvent.class))).thenAnswer((Answer)new MuleEventCheckAnswer());
        MuleSession session = (MuleSession)Mockito.mock(MuleSession.class);
        router.route((MuleEvent)new OutboundRoutingTestEvent((MuleMessage)message, session, muleContext));
        endpoints = new ArrayList();
        endpoints.add(mockendpoint4);
        endpoints.add(mockendpoint5);
        endpoints.add(mockendpoint6);
        router.getRoutes().clear();
        router.setRoutes(endpoints);
        message = new DefaultMuleMessage((Object)"test,mule,message", muleContext);
        OutboundRoutingTestEvent event = new OutboundRoutingTestEvent((MuleMessage)message, null, muleContext);
        Mockito.when((Object)mockendpoint4.process((MuleEvent)Matchers.any(MuleEvent.class))).thenAnswer((Answer)new MuleEventCheckAnswer(event));
        Mockito.when((Object)mockendpoint5.process((MuleEvent)Matchers.any(MuleEvent.class))).thenAnswer((Answer)new MuleEventCheckAnswer(event));
        Mockito.when((Object)mockendpoint6.process((MuleEvent)Matchers.any(MuleEvent.class))).thenAnswer((Answer)new MuleEventCheckAnswer(event));
        MuleEvent result = router.route((MuleEvent)new OutboundRoutingTestEvent((MuleMessage)message, session, muleContext));
        Assert.assertNotNull((Object)result);
        MuleMessage resultMessage = result.getMessage();
        Assert.assertNotNull((Object)resultMessage);
        Assert.assertTrue((boolean)(resultMessage instanceof MuleMessageCollection));
        Assert.assertEquals((long)3L, (long)((MuleMessageCollection)resultMessage).size());
    }
}

