/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.journal.queue;

import com.google.common.collect.Multimap;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Random;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNot;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;
import org.mockito.Answers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.api.MuleEvent;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.util.journal.queue.LocalQueueTxJournalEntry;
import org.mule.util.journal.queue.LocalTxQueueTransactionJournal;
import org.mule.util.queue.DefaultQueueStore;
import org.mule.util.queue.QueueStore;

public class LocalTxQueueTransactionJournalTestCase
extends AbstractMuleContextTestCase {
    private static final int TX_ID = 1;
    private static final String QUEUE_NAME = "queueName";
    private static final String SOME_VALUE = "some value";
    private static final int ONE_KB = 1024;
    private static final long MAXIMUM_FILE_SIZE_EXPECTED = 626688L;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private DefaultQueueStore mockQueueInfo = (DefaultQueueStore)Mockito.mock(DefaultQueueStore.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());

    @Before
    public void setUpMocks() {
        Mockito.when((Object)this.mockQueueInfo.getName()).thenReturn((Object)QUEUE_NAME);
    }

    @Test
    public void logAddAndRetrieve() throws Exception {
        MuleEvent muleEvent = LocalTxQueueTransactionJournalTestCase.getTestEvent(SOME_VALUE);
        LocalTxQueueTransactionJournal transactionJournal = new LocalTxQueueTransactionJournal(this.temporaryFolder.getRoot().getAbsolutePath(), muleContext);
        transactionJournal.logAdd((Object)1, (QueueStore)this.mockQueueInfo, (Serializable)muleEvent);
        transactionJournal.close();
        transactionJournal = new LocalTxQueueTransactionJournal(this.temporaryFolder.getRoot().getAbsolutePath(), muleContext);
        Multimap allEntries = transactionJournal.getAllLogEntries();
        Assert.assertThat((Object)allEntries.size(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)allEntries.get((Object)1).size(), (Matcher)Is.is((Object)1));
        LocalQueueTxJournalEntry logEntry = (LocalQueueTxJournalEntry)allEntries.get((Object)1).iterator().next();
        Assert.assertThat((Object)logEntry.getQueueName(), (Matcher)Is.is((Object)QUEUE_NAME));
        Assert.assertThat((Object)((MuleEvent)logEntry.getValue()).getMessage().getPayloadAsString(), (Matcher)Is.is((Object)SOME_VALUE));
        Assert.assertThat((Object)logEntry.isAdd(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void logAddFirstAndRetrieve() throws Exception {
        MuleEvent muleEvent = LocalTxQueueTransactionJournalTestCase.getTestEvent(SOME_VALUE);
        LocalTxQueueTransactionJournal transactionJournal = new LocalTxQueueTransactionJournal(this.temporaryFolder.getRoot().getAbsolutePath(), muleContext);
        transactionJournal.logAddFirst((Object)1, (QueueStore)this.mockQueueInfo, (Serializable)muleEvent);
        transactionJournal.close();
        transactionJournal = new LocalTxQueueTransactionJournal(this.temporaryFolder.getRoot().getAbsolutePath(), muleContext);
        Multimap allEntries = transactionJournal.getAllLogEntries();
        Assert.assertThat((Object)allEntries.size(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)allEntries.get((Object)1).size(), (Matcher)Is.is((Object)1));
        LocalQueueTxJournalEntry journalEntry = (LocalQueueTxJournalEntry)allEntries.get((Object)1).iterator().next();
        Assert.assertThat((Object)journalEntry.getQueueName(), (Matcher)Is.is((Object)QUEUE_NAME));
        Assert.assertThat((Object)((MuleEvent)journalEntry.getValue()).getMessage().getPayloadAsString(), (Matcher)Is.is((Object)SOME_VALUE));
        Assert.assertThat((Object)journalEntry.isAddFirst(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void logRemoveAndRetrieve() throws Exception {
        MuleEvent muleEvent = LocalTxQueueTransactionJournalTestCase.getTestEvent(SOME_VALUE);
        LocalTxQueueTransactionJournal transactionJournal = new LocalTxQueueTransactionJournal(this.temporaryFolder.getRoot().getAbsolutePath(), muleContext);
        transactionJournal.logRemove((Object)1, (QueueStore)this.mockQueueInfo, (Serializable)muleEvent);
        transactionJournal.close();
        transactionJournal = new LocalTxQueueTransactionJournal(this.temporaryFolder.getRoot().getAbsolutePath(), muleContext);
        Multimap allEntries = transactionJournal.getAllLogEntries();
        Assert.assertThat((Object)allEntries.size(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)allEntries.get((Object)1).size(), (Matcher)Is.is((Object)1));
        LocalQueueTxJournalEntry journalEntry = (LocalQueueTxJournalEntry)allEntries.get((Object)1).iterator().next();
        Assert.assertThat((Object)journalEntry.getQueueName(), (Matcher)Is.is((Object)QUEUE_NAME));
        Assert.assertThat((Object)((MuleEvent)journalEntry.getValue()).getMessage().getPayloadAsString(), (Matcher)Is.is((Object)SOME_VALUE));
        Assert.assertThat((Object)journalEntry.isRemove(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void logCommitAndRetrieve() {
        LocalTxQueueTransactionJournal transactionJournal = new LocalTxQueueTransactionJournal(this.temporaryFolder.getRoot().getAbsolutePath(), muleContext);
        transactionJournal.logCommit((Object)1);
        transactionJournal.close();
        transactionJournal = new LocalTxQueueTransactionJournal(this.temporaryFolder.getRoot().getAbsolutePath(), muleContext);
        Multimap allEntries = transactionJournal.getAllLogEntries();
        Assert.assertThat((Object)allEntries.size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void logRollbackAndRetrieve() {
        LocalTxQueueTransactionJournal transactionJournal = new LocalTxQueueTransactionJournal(this.temporaryFolder.getRoot().getAbsolutePath(), muleContext);
        transactionJournal.logRollback((Object)1);
        transactionJournal.close();
        transactionJournal = new LocalTxQueueTransactionJournal(this.temporaryFolder.getRoot().getAbsolutePath(), muleContext);
        Multimap allEntries = transactionJournal.getAllLogEntries();
        Assert.assertThat((Object)allEntries.size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void logSeveralAddsThenCommitAndRetrieve() throws Exception {
        MuleEvent muleEvent = LocalTxQueueTransactionJournalTestCase.getTestEvent(SOME_VALUE);
        LocalTxQueueTransactionJournal transactionJournal = new LocalTxQueueTransactionJournal(this.temporaryFolder.getRoot().getAbsolutePath(), muleContext);
        int numberOfOffers = 1000;
        for (int i = 0; i < numberOfOffers; ++i) {
            transactionJournal.logAdd((Object)1, (QueueStore)this.mockQueueInfo, (Serializable)muleEvent);
        }
        transactionJournal.logCommit((Object)1);
        transactionJournal.close();
        transactionJournal = new LocalTxQueueTransactionJournal(this.temporaryFolder.getRoot().getAbsolutePath(), muleContext);
        Multimap allEntries = transactionJournal.getAllLogEntries();
        Assert.assertThat((Object)allEntries.size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void logSeveralAddsThenRetrieveAndCommit() throws Exception {
        MuleEvent muleEvent = LocalTxQueueTransactionJournalTestCase.getTestEvent(SOME_VALUE);
        LocalTxQueueTransactionJournal transactionJournal = new LocalTxQueueTransactionJournal(this.temporaryFolder.getRoot().getAbsolutePath(), muleContext);
        int numberOfOffers = 1000;
        for (int i = 0; i < numberOfOffers; ++i) {
            transactionJournal.logAdd((Object)1, (QueueStore)this.mockQueueInfo, (Serializable)muleEvent);
        }
        transactionJournal.close();
        transactionJournal = new LocalTxQueueTransactionJournal(this.temporaryFolder.getRoot().getAbsolutePath(), muleContext);
        transactionJournal.logCommit((Object)1);
        Multimap allEntries = transactionJournal.getAllLogEntries();
        Assert.assertThat((Object)allEntries.size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void logSeveralAddsAndRetrieve() throws Exception {
        MuleEvent muleEvent = LocalTxQueueTransactionJournalTestCase.getTestEvent(SOME_VALUE);
        LocalTxQueueTransactionJournal transactionJournal = new LocalTxQueueTransactionJournal(this.temporaryFolder.getRoot().getAbsolutePath(), muleContext);
        int numberOfOffers = 1000;
        for (int i = 0; i < numberOfOffers; ++i) {
            transactionJournal.logAdd((Object)1, (QueueStore)this.mockQueueInfo, (Serializable)muleEvent);
        }
        transactionJournal.close();
        transactionJournal = new LocalTxQueueTransactionJournal(this.temporaryFolder.getRoot().getAbsolutePath(), muleContext);
        Multimap allEntries = transactionJournal.getAllLogEntries();
        Assert.assertThat((Object)allEntries.size(), (Matcher)Is.is((Object)numberOfOffers));
        Assert.assertThat((Object)allEntries.get((Object)1).size(), (Matcher)Is.is((Object)numberOfOffers));
        LocalQueueTxJournalEntry journalEntry = (LocalQueueTxJournalEntry)allEntries.get((Object)1).iterator().next();
        Assert.assertThat((Object)journalEntry.getQueueName(), (Matcher)Is.is((Object)QUEUE_NAME));
        Assert.assertThat((Object)((MuleEvent)journalEntry.getValue()).getMessage().getPayloadAsString(), (Matcher)Is.is((Object)SOME_VALUE));
        Assert.assertThat((Object)journalEntry.isAdd(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void getTxEntriesReturnsACopy() throws Exception {
        LocalTxQueueTransactionJournal transactionJournal = new LocalTxQueueTransactionJournal(this.temporaryFolder.getRoot().getAbsolutePath(), muleContext);
        this.addTransactionJournalEntry(transactionJournal);
        this.addTransactionJournalEntry(transactionJournal);
        Collection logEntriesForTx = transactionJournal.getLogEntriesForTx((Object)1);
        this.addTransactionJournalEntry(transactionJournal);
        Collection modifiedLogEntries = transactionJournal.getLogEntriesForTx((Object)1);
        Assert.assertThat((Object)logEntriesForTx, (Matcher)IsNot.not((Matcher)Is.is((Object)modifiedLogEntries)));
        Assert.assertThat((Object)logEntriesForTx.size(), (Matcher)Is.is((Object)2));
    }

    @Test
    public void maximumFileSizeGreaterThanZero() throws Exception {
        this.expectedException.expect(IllegalArgumentException.class);
        new LocalTxQueueTransactionJournal(this.temporaryFolder.getRoot().getAbsolutePath(), muleContext, Integer.valueOf(0));
    }

    @Test
    public void changeFileWhenMaximumExceeded() throws Exception {
        LocalTxQueueTransactionJournal transactionJournal = new LocalTxQueueTransactionJournal(this.temporaryFolder.getRoot().getAbsolutePath(), muleContext, Integer.valueOf(1));
        for (int i = 0; i < 7; ++i) {
            this.logAddWith100kbEntry(transactionJournal, i);
        }
        File logFile1 = this.getFirstLogFile();
        File logFile2 = this.getSecondLogFile();
        this.assertLogFileIsWithinBoundaries(logFile1);
        Assert.assertThat((Object)logFile2.length(), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
        for (int i = 0; i < 7; ++i) {
            transactionJournal.logCommit((Object)i);
        }
        Assert.assertThat((Object)logFile1.length(), (Matcher)Is.is((Object)0L));
        Assert.assertThat((Object)logFile2.length(), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
    }

    @Test
    public void doNotExceedMaximumByFar() throws Exception {
        LocalTxQueueTransactionJournal transactionJournal = new LocalTxQueueTransactionJournal(this.temporaryFolder.getRoot().getAbsolutePath(), muleContext, Integer.valueOf(1));
        for (int i = 0; i < 100; ++i) {
            this.addSeveralEntriesToLogFile(transactionJournal);
            File logFile1 = this.getFirstLogFile();
            File logFile2 = this.getSecondLogFile();
            this.assertLogFileIsWithinBoundaries(logFile1);
            this.assertLogFileIsWithinBoundaries(logFile2);
        }
    }

    private void assertLogFileIsWithinBoundaries(File file) {
        Assert.assertThat((Object)file.length(), (Matcher)Matchers.lessThan((Comparable)Long.valueOf(626688L)));
    }

    private void addSeveralEntriesToLogFile(LocalTxQueueTransactionJournal transactionJournal) {
        for (int i = 0; i < 5; ++i) {
            int txId = Math.abs(new Random().nextInt());
            this.logAddWith100kbEntry(transactionJournal, txId);
            transactionJournal.logCommit((Object)txId);
        }
    }

    private void logAddWith100kbEntry(LocalTxQueueTransactionJournal transactionJournal, int txId) {
        byte[] data = new byte[102400];
        transactionJournal.logAdd((Object)txId, (QueueStore)this.mockQueueInfo, (Serializable)data);
    }

    private File getSecondLogFile() {
        return new File(this.temporaryFolder.getRoot().getAbsolutePath(), "tx2.log");
    }

    private File getFirstLogFile() {
        return new File(this.temporaryFolder.getRoot().getAbsolutePath(), "tx1.log");
    }

    private void addTransactionJournalEntry(LocalTxQueueTransactionJournal transactionJournal) {
        transactionJournal.logAdd((Object)1, (QueueStore)this.mockQueueInfo, (Serializable)((Object)"data"));
    }
}

