/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleMessage;
import org.mule.MessageExchangePattern;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.ThreadSafeAccess;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.construct.Pipeline;
import org.mule.api.context.notification.FlowCallStack;
import org.mule.api.context.notification.ProcessorsTrace;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.processor.ProcessingDescriptor;
import org.mule.api.security.Credentials;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transport.PropertyScope;
import org.mule.api.transport.ReplyToHandler;
import org.mule.api.util.CredentialsMaskUtil;
import org.mule.config.i18n.CoreMessages;
import org.mule.context.notification.DefaultFlowCallStack;
import org.mule.context.notification.DefaultProcessorsTrace;
import org.mule.management.stats.ProcessingTime;
import org.mule.processor.strategy.NonBlockingProcessingStrategy;
import org.mule.security.MuleCredentials;
import org.mule.session.DefaultMuleSession;
import org.mule.transaction.TransactionCoordination;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.transformer.types.TypedValue;
import org.mule.transport.DefaultReplyToHandler;
import org.mule.util.CopyOnWriteCaseInsensitiveMap;
import org.mule.util.store.DeserializationPostInitialisable;

public class DefaultMuleEvent
implements MuleEvent,
ThreadSafeAccess,
DeserializationPostInitialisable {
    private static final long serialVersionUID = 1L;
    private static Log logger = LogFactory.getLog(DefaultMuleEvent.class);
    public static final int DEFAULT_LENGTH_MULE_EVENT_ID = 39;
    private final String id;
    private MuleMessage message;
    private final MuleSession session;
    private transient FlowConstruct flowConstruct;
    private final Credentials credentials;
    private final String encoding;
    private final MessageExchangePattern exchangePattern;
    private final URI messageSourceURI;
    private final String messageSourceName;
    private final ReplyToHandler replyToHandler;
    private final boolean transacted;
    private final boolean synchronous;
    private boolean stopFurtherProcessing = false;
    private int timeout = Integer.MIN_VALUE;
    private transient OutputStream outputStream;
    private final ProcessingTime processingTime;
    private Object replyToDestination;
    protected String[] ignoredPropertyOverrides = new String[]{"method"};
    private boolean notificationsEnabled = true;
    private transient Map<String, Object> serializedData = null;
    private CopyOnWriteCaseInsensitiveMap<String, TypedValue> flowVariables = new CopyOnWriteCaseInsensitiveMap();
    private FlowCallStack flowCallStack = new DefaultFlowCallStack();
    private ProcessorsTrace processorsTrace = new DefaultProcessorsTrace();
    private boolean nonBlocking;

    public DefaultMuleEvent(MuleMessage message, MessageExchangePattern exchangePattern, FlowConstruct flowConstruct, MuleSession session) {
        this(message, exchangePattern, flowConstruct, session, message.getMuleContext().getConfiguration().getDefaultResponseTimeout(), null, null);
    }

    public DefaultMuleEvent(MuleMessage message, MessageExchangePattern exchangePattern, FlowConstruct flowConstruct) {
        this(message, exchangePattern, flowConstruct, (MuleSession)new DefaultMuleSession(), message.getMuleContext().getConfiguration().getDefaultResponseTimeout(), null, null);
    }

    public DefaultMuleEvent(MuleMessage message, MessageExchangePattern exchangePattern, ReplyToHandler replyToHandler, FlowConstruct flowConstruct) {
        this(message, URI.create("none"), exchangePattern, flowConstruct, new DefaultMuleSession(), message.getMuleContext().getConfiguration().getDefaultResponseTimeout(), null, null, replyToHandler);
    }

    public DefaultMuleEvent(MuleMessage message, MessageExchangePattern exchangePattern, FlowConstruct flowConstruct, MuleSession session, OutputStream outputStream) {
        this(message, exchangePattern, flowConstruct, session, message.getMuleContext().getConfiguration().getDefaultResponseTimeout(), null, outputStream);
    }

    public DefaultMuleEvent(MuleMessage message, MessageExchangePattern exchangePattern, FlowConstruct flowConstruct, MuleSession session, int timeout, Credentials credentials, OutputStream outputStream) {
        this(message, URI.create("none"), exchangePattern, flowConstruct, session, timeout, credentials, outputStream);
    }

    public DefaultMuleEvent(MuleMessage message, URI messageSourceURI, MessageExchangePattern exchangePattern, FlowConstruct flowConstruct, MuleSession session) {
        this(message, messageSourceURI, exchangePattern, flowConstruct, session, message.getMuleContext().getConfiguration().getDefaultResponseTimeout(), null, null);
    }

    public DefaultMuleEvent(MuleMessage message, URI messageSourceURI, MessageExchangePattern exchangePattern, FlowConstruct flowConstruct, MuleSession session, OutputStream outputStream) {
        this(message, messageSourceURI, exchangePattern, flowConstruct, session, message.getMuleContext().getConfiguration().getDefaultResponseTimeout(), null, outputStream);
    }

    public DefaultMuleEvent(MuleMessage message, URI messageSourceURI, MessageExchangePattern exchangePattern, FlowConstruct flowConstruct, MuleSession session, int timeout, Credentials credentials, OutputStream outputStream, ReplyToHandler replyToHandler) {
        this.id = this.generateEventId(message.getMuleContext());
        this.flowConstruct = flowConstruct;
        this.session = session;
        this.setMessage(message);
        this.exchangePattern = exchangePattern;
        this.outputStream = outputStream;
        this.credentials = null;
        this.encoding = message.getMuleContext().getConfiguration().getDefaultEncoding();
        this.messageSourceName = messageSourceURI.toString();
        this.messageSourceURI = messageSourceURI;
        this.processingTime = ProcessingTime.newInstance(this);
        this.replyToHandler = replyToHandler;
        this.replyToDestination = null;
        this.timeout = timeout;
        this.transacted = false;
        this.synchronous = this.resolveEventSynchronicity();
        this.nonBlocking = this.isFlowConstructNonBlockingProcessingStrategy();
    }

    public DefaultMuleEvent(MuleMessage message, URI messageSourceURI, MessageExchangePattern exchangePattern, FlowConstruct flowConstruct, MuleSession session, int timeout, Credentials credentials, OutputStream outputStream) {
        this(message, messageSourceURI, exchangePattern, flowConstruct, session, timeout, credentials, outputStream, null);
    }

    public DefaultMuleEvent(MuleMessage message, InboundEndpoint endpoint, FlowConstruct flowConstruct, MuleSession session) {
        this(message, endpoint, flowConstruct, session, null, null, null);
    }

    public DefaultMuleEvent(MuleMessage message, InboundEndpoint endpoint, FlowConstruct flowConstruct) {
        this(message, endpoint, flowConstruct, (MuleSession)new DefaultMuleSession(), null, null, null);
    }

    public DefaultMuleEvent(MuleMessage message, InboundEndpoint endpoint, FlowConstruct flowConstruct, MuleSession session, ReplyToHandler replyToHandler, Object replyToDestination, OutputStream outputStream) {
        this.id = this.generateEventId(message.getMuleContext());
        this.flowConstruct = flowConstruct;
        this.session = session;
        this.setMessage(message);
        this.outputStream = outputStream;
        this.processingTime = ProcessingTime.newInstance(this);
        this.replyToHandler = replyToHandler;
        this.replyToDestination = replyToDestination;
        this.credentials = this.extractCredentials(endpoint);
        this.encoding = endpoint.getEncoding();
        this.exchangePattern = endpoint.getExchangePattern();
        this.messageSourceName = endpoint.getName();
        this.messageSourceURI = endpoint.getEndpointURI().getUri();
        this.timeout = endpoint.getResponseTimeout();
        this.transacted = endpoint.getTransactionConfig().isTransacted();
        this.fillProperties(endpoint);
        this.synchronous = this.resolveEventSynchronicity();
        this.nonBlocking = this.isFlowConstructNonBlockingProcessingStrategy();
    }

    public DefaultMuleEvent(MuleMessage message, MuleEvent rewriteEvent) {
        this(message, rewriteEvent, rewriteEvent.getSession());
    }

    public DefaultMuleEvent(MuleEvent rewriteEvent, FlowConstruct flowConstruct) {
        this(rewriteEvent.getMessage(), rewriteEvent, flowConstruct, rewriteEvent.getSession(), rewriteEvent.isSynchronous());
    }

    public DefaultMuleEvent(MuleEvent rewriteEvent, ReplyToHandler replyToHandler) {
        this(rewriteEvent, rewriteEvent.getFlowConstruct(), replyToHandler, null);
    }

    public DefaultMuleEvent(MuleEvent rewriteEvent, FlowConstruct flowConstruct, ReplyToHandler replyToHandler, Object replyToDestination) {
        this(rewriteEvent.getMessage(), rewriteEvent, flowConstruct, rewriteEvent.getSession(), rewriteEvent.isSynchronous(), replyToHandler, replyToDestination, true, rewriteEvent.getExchangePattern());
    }

    public DefaultMuleEvent(MuleEvent rewriteEvent, FlowConstruct flowConstruct, ReplyToHandler replyToHandler, Object replyToDestination, boolean synchronous) {
        this(rewriteEvent.getMessage(), rewriteEvent, flowConstruct, rewriteEvent.getSession(), synchronous, replyToHandler, replyToDestination, true, rewriteEvent.getExchangePattern());
    }

    public DefaultMuleEvent(MuleMessage message, MuleEvent rewriteEvent, boolean synchronus) {
        this(message, rewriteEvent, rewriteEvent.getFlowConstruct(), rewriteEvent.getSession(), synchronus);
    }

    public DefaultMuleEvent(MuleMessage message, MuleEvent rewriteEvent, boolean synchronus, boolean shareFlowVars) {
        this(message, rewriteEvent, rewriteEvent.getFlowConstruct(), rewriteEvent.getSession(), synchronus, shareFlowVars, rewriteEvent.getExchangePattern(), rewriteEvent.getReplyToHandler());
    }

    public DefaultMuleEvent(MuleMessage message, MuleEvent rewriteEvent, boolean synchronus, boolean shareFlowVars, MessageExchangePattern messageExchangePattern) {
        this(message, rewriteEvent, rewriteEvent.getFlowConstruct(), rewriteEvent.getSession(), synchronus, shareFlowVars, messageExchangePattern, rewriteEvent.getReplyToHandler());
    }

    public DefaultMuleEvent(MuleMessage message, MuleEvent rewriteEvent, boolean synchronus, boolean shareFlowVars, MessageExchangePattern messageExchangePattern, ReplyToHandler replyToHandler) {
        this(message, rewriteEvent, rewriteEvent.getFlowConstruct(), rewriteEvent.getSession(), synchronus, shareFlowVars, messageExchangePattern, replyToHandler);
    }

    public DefaultMuleEvent(MuleMessage message, MuleEvent rewriteEvent, MuleSession session) {
        this(message, rewriteEvent, rewriteEvent.getFlowConstruct(), session, rewriteEvent.isSynchronous());
    }

    protected DefaultMuleEvent(MuleMessage message, MuleEvent rewriteEvent, FlowConstruct flowConstruct, MuleSession session, boolean synchronous) {
        this(message, rewriteEvent, flowConstruct, session, synchronous, rewriteEvent.getReplyToHandler(), rewriteEvent.getReplyToDestination(), true, rewriteEvent.getExchangePattern());
    }

    protected DefaultMuleEvent(MuleMessage message, MuleEvent rewriteEvent, FlowConstruct flowConstruct, MuleSession session, boolean synchronous, boolean shareFlowVars, MessageExchangePattern messageExchangePattern, ReplyToHandler replyToHandler) {
        this(message, rewriteEvent, flowConstruct, session, synchronous, replyToHandler, rewriteEvent.getReplyToDestination(), shareFlowVars, messageExchangePattern);
    }

    protected DefaultMuleEvent(MuleMessage message, MuleEvent rewriteEvent, FlowConstruct flowConstruct, MuleSession session, boolean synchronous, ReplyToHandler replyToHandler, Object replyToDestination, boolean shareFlowVars, MessageExchangePattern messageExchangePattern) {
        this.id = rewriteEvent.getId();
        this.flowConstruct = flowConstruct;
        this.session = session;
        this.credentials = rewriteEvent.getCredentials();
        this.encoding = rewriteEvent.getEncoding();
        this.exchangePattern = messageExchangePattern;
        this.messageSourceName = rewriteEvent.getMessageSourceName();
        this.messageSourceURI = rewriteEvent.getMessageSourceURI();
        this.outputStream = rewriteEvent.getOutputStream();
        if (rewriteEvent instanceof DefaultMuleEvent) {
            this.processingTime = ((DefaultMuleEvent)rewriteEvent).processingTime;
            if (shareFlowVars) {
                this.flowVariables = ((DefaultMuleEvent)rewriteEvent).flowVariables;
            } else {
                this.flowVariables.putAll(((DefaultMuleEvent)rewriteEvent).flowVariables);
            }
        } else {
            this.processingTime = ProcessingTime.newInstance(this);
        }
        this.setMessage(message);
        this.replyToHandler = replyToHandler;
        this.replyToDestination = replyToDestination;
        this.timeout = rewriteEvent.getTimeout();
        this.transacted = rewriteEvent.isTransacted();
        this.notificationsEnabled = rewriteEvent.isNotificationsEnabled();
        this.synchronous = synchronous;
        this.nonBlocking = rewriteEvent.isAllowNonBlocking() || this.isFlowConstructNonBlockingProcessingStrategy();
        this.flowCallStack = rewriteEvent.getFlowCallStack() == null ? new DefaultFlowCallStack() : rewriteEvent.getFlowCallStack().clone();
        this.processorsTrace = rewriteEvent.getProcessorsTrace();
    }

    public DefaultMuleEvent(MuleMessage message, URI messageSourceURI, String messageSourceName, MessageExchangePattern exchangePattern, FlowConstruct flowConstruct, MuleSession session, int timeout, Credentials credentials, OutputStream outputStream, String encoding, boolean transacted, boolean synchronous, Object replyToDestination, ReplyToHandler replyToHandler) {
        this.id = this.generateEventId(message.getMuleContext());
        this.flowConstruct = flowConstruct;
        this.session = session;
        this.setMessage(message);
        this.credentials = credentials;
        this.encoding = encoding;
        this.exchangePattern = exchangePattern;
        this.messageSourceURI = messageSourceURI;
        this.messageSourceName = messageSourceName;
        this.processingTime = ProcessingTime.newInstance(this);
        this.replyToHandler = replyToHandler;
        this.replyToDestination = replyToDestination;
        this.transacted = transacted;
        this.synchronous = synchronous;
        this.nonBlocking = this.isFlowConstructNonBlockingProcessingStrategy();
        this.timeout = timeout;
        this.outputStream = outputStream;
    }

    protected boolean resolveEventSynchronicity() {
        return this.transacted || this.isFlowConstructSynchronous() || this.exchangePattern.hasResponse() && !this.isFlowConstructNonBlockingProcessingStrategy() || this.message.getProperty("MULE_FORCE_SYNC", PropertyScope.INBOUND, Boolean.FALSE) != false;
    }

    private boolean isFlowConstructSynchronous() {
        return this.flowConstruct instanceof ProcessingDescriptor && ((ProcessingDescriptor)((Object)this.flowConstruct)).isSynchronous();
    }

    private boolean isFlowConstructNonBlockingProcessingStrategy() {
        return this.flowConstruct instanceof Pipeline && ((Pipeline)this.flowConstruct).getProcessingStrategy() instanceof NonBlockingProcessingStrategy;
    }

    protected void fillProperties(InboundEndpoint endpoint) {
        if (endpoint != null && endpoint.getProperties() != null) {
            for (String prop : endpoint.getProperties().keySet()) {
                if (this.ignoreProperty(prop)) continue;
                Object value = endpoint.getProperties().get(prop);
                this.message.setInvocationProperty(prop, value);
            }
        }
    }

    protected boolean ignoreProperty(String key) {
        if (key == null || key.startsWith("MULE_ENDPOINT__")) {
            return true;
        }
        for (int i = 0; i < this.ignoredPropertyOverrides.length; ++i) {
            if (!key.equals(this.ignoredPropertyOverrides[i])) continue;
            return false;
        }
        return null != this.message.getOutboundProperty(key);
    }

    protected Credentials extractCredentials(InboundEndpoint endpoint) {
        if (null != endpoint && null != endpoint.getEndpointURI() && null != endpoint.getEndpointURI().getUserInfo()) {
            String userName = endpoint.getEndpointURI().getUser();
            String password = endpoint.getEndpointURI().getPassword();
            if (password != null && userName != null) {
                return new MuleCredentials(userName, password.toCharArray());
            }
        }
        return null;
    }

    @Override
    public Credentials getCredentials() {
        MuleCredentials creds = (MuleCredentials)this.message.getOutboundProperty("MULE_CREDENTIALS");
        return this.credentials != null ? this.credentials : creds;
    }

    @Override
    public MuleMessage getMessage() {
        return this.message;
    }

    @Override
    public byte[] getMessageAsBytes() throws DefaultMuleException {
        try {
            return this.message.getPayloadAsBytes();
        }
        catch (Exception e) {
            throw new DefaultMuleException(CoreMessages.cannotReadPayloadAsBytes(this.message.getPayload().getClass().getName()), (Throwable)e);
        }
    }

    @Override
    public <T> T transformMessage(Class<T> outputType) throws TransformerException {
        return this.transformMessage(DataTypeFactory.create(outputType));
    }

    @Override
    public <T> T transformMessage(DataType<T> outputType) throws TransformerException {
        if (outputType == null) {
            throw new TransformerException(CoreMessages.objectIsNull("outputType"));
        }
        return this.message.getPayload(outputType);
    }

    @Override
    @Deprecated
    public byte[] transformMessageToBytes() throws TransformerException {
        return this.transformMessage(DataType.BYTE_ARRAY_DATA_TYPE);
    }

    @Override
    public String transformMessageToString() throws TransformerException {
        return this.transformMessage(DataTypeFactory.createWithEncoding(String.class, this.getEncoding()));
    }

    @Override
    public String getMessageAsString() throws MuleException {
        return this.getMessageAsString(this.getEncoding());
    }

    @Override
    public String getMessageAsString(String encoding) throws MuleException {
        try {
            return this.message.getPayloadForLogging(encoding);
        }
        catch (Exception e) {
            throw new DefaultMuleException(CoreMessages.cannotReadPayloadAsString(this.message.getClass().getName()), (Throwable)e);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    @Deprecated
    public Object getProperty(String name) {
        throw new UnsupportedOperationException("Method's behavior has changed in Mule 3, use event.getMessage() and suitable scope-aware property access methods on it");
    }

    @Override
    @Deprecated
    public Object getProperty(String name, Object defaultValue) {
        throw new UnsupportedOperationException("Method's behavior has changed in Mule 3, use event.getMessage() and suitable scope-aware property access methods on it");
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(64);
        buf.append("MuleEvent: ").append(this.getId());
        buf.append(", stop processing=").append(this.isStopFurtherProcessing());
        if (this.messageSourceURI != null) {
            buf.append(", ").append(CredentialsMaskUtil.maskUrlPassword(this.messageSourceURI.toString(), CredentialsMaskUtil.BARE_URL_PATTERN));
        }
        return buf.toString();
    }

    protected String generateEventId(MuleContext context) {
        return context.getUniqueIdString();
    }

    @Override
    public MuleSession getSession() {
        return this.session;
    }

    @Override
    public FlowConstruct getFlowConstruct() {
        return this.flowConstruct;
    }

    @Override
    public boolean isStopFurtherProcessing() {
        return this.stopFurtherProcessing;
    }

    @Override
    public void setStopFurtherProcessing(boolean stopFurtherProcessing) {
        this.stopFurtherProcessing = stopFurtherProcessing;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultMuleEvent)) {
            return false;
        }
        DefaultMuleEvent event = (DefaultMuleEvent)o;
        if (this.message != null ? !this.message.equals(event.message) : event.message != null) {
            return false;
        }
        return this.id.equals(event.id);
    }

    public int hashCode() {
        return 29 * this.id.hashCode() + (this.message != null ? this.message.hashCode() : 0);
    }

    @Override
    public int getTimeout() {
        if (this.getMuleContext().getConfiguration().isDisableTimeouts()) {
            return 0;
        }
        if (this.timeout == Integer.MIN_VALUE) {
            return this.message.getMuleContext().getConfiguration().getDefaultResponseTimeout();
        }
        return this.timeout;
    }

    @Override
    public void setTimeout(int timeout) {
        if (timeout >= 0) {
            this.timeout = timeout;
        }
    }

    @Override
    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    private void initAfterDeserialisation(MuleContext muleContext) throws MuleException {
        if (this.message instanceof DefaultMuleMessage) {
            ((DefaultMuleMessage)this.message).initAfterDeserialisation(muleContext);
            this.setMessage(this.message);
        }
        if (this.replyToHandler instanceof DefaultReplyToHandler) {
            ((DefaultReplyToHandler)this.replyToHandler).initAfterDeserialisation(muleContext);
        }
        if (this.replyToDestination instanceof DeserializationPostInitialisable) {
            try {
                DeserializationPostInitialisable.Implementation.init(this.replyToDestination, muleContext);
            }
            catch (Exception e) {
                throw new DefaultMuleException(e);
            }
        }
        if (this.serializedData == null) {
            return;
        }
        String serviceName = this.getTransientServiceName();
        if (serviceName != null) {
            this.flowConstruct = muleContext.getRegistry().lookupFlowConstruct(serviceName);
        }
        this.serializedData = null;
    }

    @Override
    public String getEncoding() {
        if (this.message.getEncoding() != null) {
            return this.message.getEncoding();
        }
        return this.encoding;
    }

    @Override
    public MuleContext getMuleContext() {
        return this.message.getMuleContext();
    }

    @Override
    public ThreadSafeAccess newThreadCopy() {
        if (this.message instanceof ThreadSafeAccess) {
            DefaultMuleEvent copy = new DefaultMuleEvent((MuleMessage)((Object)((ThreadSafeAccess)((Object)this.message)).newThreadCopy()), this);
            copy.resetAccessControl();
            return copy;
        }
        return this;
    }

    @Override
    public void resetAccessControl() {
        if (this.message instanceof ThreadSafeAccess) {
            ((ThreadSafeAccess)((Object)this.message)).resetAccessControl();
        }
    }

    @Override
    public void assertAccess(boolean write) {
        if (this.message instanceof ThreadSafeAccess) {
            ((ThreadSafeAccess)((Object)this.message)).assertAccess(write);
        }
    }

    @Override
    @Deprecated
    public Object transformMessage() throws TransformerException {
        logger.warn((Object)"Deprecation warning: MuleEvent.transformMessage does nothing in Mule 3.x.  The message is already transformed before the event reaches a component");
        return this.message.getPayload();
    }

    @Override
    public ProcessingTime getProcessingTime() {
        return this.processingTime;
    }

    @Override
    public MessageExchangePattern getExchangePattern() {
        return this.exchangePattern;
    }

    @Override
    public boolean isTransacted() {
        return this.transacted || TransactionCoordination.getInstance().getTransaction() != null;
    }

    @Override
    public URI getMessageSourceURI() {
        return this.messageSourceURI;
    }

    @Override
    public String getMessageSourceName() {
        return this.messageSourceName;
    }

    @Override
    public ReplyToHandler getReplyToHandler() {
        return this.replyToHandler;
    }

    @Override
    public Object getReplyToDestination() {
        return this.replyToDestination;
    }

    @Override
    public void captureReplyToDestination() {
    }

    @Override
    public boolean isSynchronous() {
        return this.synchronous;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        if (this.serializedData != null) {
            Object serviceName = this.serializedData.get("serviceName");
            if (serviceName != null) {
                out.writeObject(serviceName);
            }
        } else if (this.getFlowConstruct() != null) {
            out.writeObject(this.getFlowConstruct() != null ? this.getFlowConstruct().getName() : "null");
        }
        for (Map.Entry<String, TypedValue> entry : this.flowVariables.entrySet()) {
            TypedValue value = entry.getValue();
            if (value == null || value instanceof Serializable) continue;
            String message = String.format("Unable to serialize the flow variable %s, which is of type %s ", entry.getKey(), value);
            logger.error((Object)message);
            throw new IOException(message);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.serializedData = new HashMap<String, Object>();
        try {
            this.setTransientServiceName(in.readObject());
        }
        catch (OptionalDataException optionalDataException) {
            // empty catch block
        }
    }

    public void setTransientServiceName(Object serviceName) {
        if (this.serializedData == null) {
            this.serializedData = new HashMap<String, Object>();
        }
        this.serializedData.put("serviceName", serviceName);
    }

    private String getTransientServiceName() {
        return this.serializedData != null ? (String)this.serializedData.get("serviceName") : null;
    }

    @Override
    public void setMessage(MuleMessage message) {
        this.message = message;
        if (message instanceof DefaultMuleMessage) {
            this.flowVariables.putAll(((DefaultMuleMessage)message).getOrphanFlowVariables());
            ((DefaultMuleMessage)message).setInvocationProperties(this.flowVariables);
            if (this.session instanceof DefaultMuleSession) {
                ((DefaultMuleMessage)message).setSessionProperties(((DefaultMuleSession)this.session).getExtendedProperties());
            }
        }
    }

    public static MuleEvent copy(MuleEvent event) {
        MuleMessage messageCopy = (MuleMessage)((Object)((ThreadSafeAccess)((Object)event.getMessage())).newThreadCopy());
        DefaultMuleEvent eventCopy = new DefaultMuleEvent(messageCopy, event, (MuleSession)new DefaultMuleSession(event.getSession()));
        eventCopy.flowVariables = ((DefaultMuleEvent)event).flowVariables.clone();
        ((DefaultMuleMessage)messageCopy).setInvocationProperties(eventCopy.flowVariables);
        ((DefaultMuleMessage)messageCopy).resetAccessControl();
        return eventCopy;
    }

    @Override
    public Set<String> getFlowVariableNames() {
        return this.flowVariables.keySet();
    }

    @Override
    public void clearFlowVariables() {
        this.flowVariables.clear();
    }

    @Override
    public <T> T getFlowVariable(String key) {
        TypedValue typedValue = this.flowVariables.get(key);
        return (T)(typedValue == null ? null : typedValue.getValue());
    }

    @Override
    public DataType<?> getFlowVariableDataType(String key) {
        TypedValue typedValue = this.flowVariables.get(key);
        return typedValue == null ? null : typedValue.getDataType();
    }

    @Override
    public void setFlowVariable(String key, Object value) {
        this.setFlowVariable(key, value, DataTypeFactory.createFromObject(value));
    }

    @Override
    public void setFlowVariable(String key, Object value, DataType dataType) {
        this.flowVariables.put(key, new TypedValue(value, dataType));
    }

    @Override
    public void removeFlowVariable(String key) {
        this.flowVariables.remove(key);
    }

    @Override
    public <T> T getSessionVariable(String key) {
        return this.session.getProperty(key);
    }

    @Override
    public DataType<?> getSessionVariableDataType(String key) {
        return this.session.getPropertyDataType(key);
    }

    @Override
    public void setSessionVariable(String key, Object value) {
        this.session.setProperty(key, value);
    }

    @Override
    public void setSessionVariable(String key, Serializable value, DataType dataType) {
        this.session.setProperty(key, value, dataType);
    }

    @Override
    public void removeSessionVariable(String key) {
        this.session.removeProperty(key);
    }

    @Override
    public Set<String> getSessionVariableNames() {
        return this.session.getPropertyNamesAsSet();
    }

    @Override
    public void clearSessionVariables() {
        this.session.clearProperties();
    }

    @Deprecated
    public DefaultMuleEvent(MuleMessage message, MessageExchangePattern exchangePattern, MuleSession session) {
        this(message, exchangePattern, session, message.getMuleContext().getConfiguration().getDefaultResponseTimeout(), null, null);
    }

    @Deprecated
    public DefaultMuleEvent(MuleMessage message, MessageExchangePattern exchangePattern, MuleSession session, OutputStream outputStream) {
        this(message, exchangePattern, session, message.getMuleContext().getConfiguration().getDefaultResponseTimeout(), null, outputStream);
    }

    @Deprecated
    public DefaultMuleEvent(MuleMessage message, MessageExchangePattern exchangePattern, MuleSession session, int timeout, Credentials credentials, OutputStream outputStream) {
        this(message, URI.create("none"), exchangePattern, session, timeout, credentials, outputStream);
    }

    @Deprecated
    public DefaultMuleEvent(MuleMessage message, URI messageSourceURI, MessageExchangePattern exchangePattern, MuleSession session) {
        this(message, messageSourceURI, exchangePattern, session, message.getMuleContext().getConfiguration().getDefaultResponseTimeout(), null, null);
    }

    @Deprecated
    public DefaultMuleEvent(MuleMessage message, URI messageSourceURI, MessageExchangePattern exchangePattern, MuleSession session, OutputStream outputStream) {
        this(message, messageSourceURI, exchangePattern, session, message.getMuleContext().getConfiguration().getDefaultResponseTimeout(), null, outputStream);
    }

    @Deprecated
    public DefaultMuleEvent(MuleMessage message, URI messageSourceURI, MessageExchangePattern exchangePattern, MuleSession session, int timeout, Credentials credentials, OutputStream outputStream) {
        this(message, messageSourceURI, exchangePattern, session.getFlowConstruct(), session, timeout, credentials, outputStream);
    }

    @Deprecated
    public DefaultMuleEvent(MuleMessage message, InboundEndpoint endpoint, MuleSession session) {
        this(message, endpoint, session, null, null, null);
    }

    @Deprecated
    public DefaultMuleEvent(MuleMessage message, InboundEndpoint endpoint, MuleSession session, ReplyToHandler replyToHandler, OutputStream outputStream, Object replyToDestination) {
        this(message, endpoint, session.getFlowConstruct(), session, replyToHandler, replyToDestination, outputStream);
    }

    @Deprecated
    public DefaultMuleEvent(MuleMessage message, URI messageSourceURI, String messageSourceName, MessageExchangePattern exchangePattern, MuleSession session, int timeout, Credentials credentials, OutputStream outputStream, String encoding, boolean transacted, boolean synchronous, Object replyToDestination, ReplyToHandler replyToHandler) {
        this(message, messageSourceURI, messageSourceName, exchangePattern, session.getFlowConstruct(), session, timeout, credentials, outputStream, encoding, transacted, synchronous, replyToDestination, replyToHandler);
    }

    @Override
    public boolean isNotificationsEnabled() {
        return this.notificationsEnabled;
    }

    @Override
    public void setEnableNotifications(boolean enabled) {
        this.notificationsEnabled = enabled;
    }

    @Override
    public boolean isAllowNonBlocking() {
        return this.nonBlocking && !this.synchronous;
    }

    @Override
    public FlowCallStack getFlowCallStack() {
        return this.flowCallStack;
    }

    @Override
    public ProcessorsTrace getProcessorsTrace() {
        return this.processorsTrace;
    }
}

