/*
 * Decompiled with CFR 0.152.
 */
package org.mule.exception;

import org.mule.DefaultMuleEvent;
import org.mule.VoidMuleEvent;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.exception.MessagingExceptionHandler;
import org.mule.api.exception.MessagingExceptionHandlerAcceptor;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.processor.MessageProcessorChain;
import org.mule.api.transport.NonBlockingReplyToHandler;
import org.mule.context.notification.ExceptionStrategyNotification;
import org.mule.exception.AbstractExceptionListener;
import org.mule.management.stats.FlowConstructStatistics;
import org.mule.message.DefaultExceptionPayload;
import org.mule.processor.AbstractRequestResponseMessageProcessor;
import org.mule.processor.chain.DefaultMessageProcessorChainBuilder;
import org.mule.routing.requestreply.ReplyToPropertyRequestReplyReplier;
import org.mule.transaction.TransactionCoordination;

public abstract class TemplateMessagingExceptionStrategy
extends AbstractExceptionListener
implements MessagingExceptionHandlerAcceptor {
    private MessageProcessorChain configuredMessageProcessors;
    private MessageProcessor replyToMessageProcessor = new ReplyToPropertyRequestReplyReplier();
    private String when;
    private boolean handleException;

    @Override
    public final MuleEvent handleException(Exception exception, MuleEvent event) {
        try {
            return new ExceptionMessageProcessor(exception, this.muleContext, event.getFlowConstruct()).process(event);
        }
        catch (MuleException e) {
            throw new RuntimeException(e);
        }
    }

    private void markExceptionAsHandledIfRequired(Exception exception) {
        if (this.handleException) {
            this.markExceptionAsHandled(exception);
        }
    }

    protected void markExceptionAsHandled(Exception exception) {
        if (exception instanceof MessagingException) {
            ((MessagingException)exception).setHandled(true);
        }
    }

    protected void processReplyTo(MuleEvent event, Exception e) {
        try {
            this.replyToMessageProcessor.process(event);
        }
        catch (MuleException ex) {
            this.logFatal(event, ex);
        }
    }

    protected void nullifyExceptionPayloadIfRequired(MuleEvent event) {
        if (this.handleException) {
            event.getMessage().setExceptionPayload(null);
        }
    }

    private void processStatistics(MuleEvent event) {
        FlowConstructStatistics statistics = event.getFlowConstruct().getStatistics();
        if (statistics != null && statistics.isEnabled()) {
            statistics.incExecutionError();
        }
    }

    protected MuleEvent route(MuleEvent event, Exception t) {
        if (!this.getMessageProcessors().isEmpty()) {
            try {
                event.getMessage().setExceptionPayload(new DefaultExceptionPayload(t));
                MuleEvent result = this.configuredMessageProcessors.process(event);
                return result;
            }
            catch (Exception e) {
                this.logFatal(event, e);
            }
        }
        return event;
    }

    @Override
    protected void doInitialise(MuleContext muleContext) throws InitialisationException {
        super.doInitialise(muleContext);
        DefaultMessageProcessorChainBuilder defaultMessageProcessorChainBuilder = new DefaultMessageProcessorChainBuilder(this.flowConstruct);
        try {
            this.configuredMessageProcessors = defaultMessageProcessorChainBuilder.chain(this.getMessageProcessors()).build();
        }
        catch (MuleException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    public void setWhen(String when) {
        this.when = when;
    }

    @Override
    public boolean accept(MuleEvent event) {
        return this.acceptsAll() || this.acceptsEvent(event) || this.muleContext.getExpressionManager().evaluateBoolean(this.when, event);
    }

    protected boolean acceptsEvent(MuleEvent event) {
        return false;
    }

    @Override
    public boolean acceptsAll() {
        return this.when == null;
    }

    protected MuleEvent afterRouting(Exception exception, MuleEvent event) {
        return event;
    }

    protected MuleEvent beforeRouting(Exception exception, MuleEvent event) {
        return event;
    }

    @Override
    public void setMessagingExceptionHandler(MessagingExceptionHandler messagingExceptionHandler) {
    }

    public void setHandleException(boolean handleException) {
        this.handleException = handleException;
    }

    private class ExceptionMessageProcessor
    extends AbstractRequestResponseMessageProcessor {
        private Exception exception;

        public ExceptionMessageProcessor(Exception exception, MuleContext muleContext, FlowConstruct flowConstruct) {
            this.exception = exception;
            this.setMuleContext(muleContext);
            TemplateMessagingExceptionStrategy.this.setFlowConstruct(flowConstruct);
        }

        @Override
        protected MuleEvent processRequest(MuleEvent request) throws MuleException {
            if (!TemplateMessagingExceptionStrategy.this.handleException && request.getReplyToHandler() instanceof NonBlockingReplyToHandler) {
                request = new DefaultMuleEvent(request, request.getFlowConstruct(), null, null, true);
            }
            this.muleContext.getNotificationManager().fireNotification(new ExceptionStrategyNotification(request, 2001));
            TemplateMessagingExceptionStrategy.this.fireNotification(this.exception);
            TemplateMessagingExceptionStrategy.this.logException(this.exception, request);
            TemplateMessagingExceptionStrategy.this.processStatistics(request);
            request.getMessage().setExceptionPayload(new DefaultExceptionPayload(this.exception));
            TemplateMessagingExceptionStrategy.this.markExceptionAsHandledIfRequired(this.exception);
            return TemplateMessagingExceptionStrategy.this.beforeRouting(this.exception, request);
        }

        @Override
        protected MuleEvent processResponse(MuleEvent response, MuleEvent request) throws MuleException {
            TemplateMessagingExceptionStrategy.this.processOutboundRouterStatistics(TemplateMessagingExceptionStrategy.this.flowConstruct);
            response = TemplateMessagingExceptionStrategy.this.afterRouting(this.exception, response);
            if (response != null && !VoidMuleEvent.getInstance().equals(response)) {
                if (!request.isAllowNonBlocking() || !(request.getReplyToHandler() instanceof NonBlockingReplyToHandler)) {
                    TemplateMessagingExceptionStrategy.this.processReplyTo(response, this.exception);
                }
                TemplateMessagingExceptionStrategy.this.closeStream(response.getMessage());
                TemplateMessagingExceptionStrategy.this.nullifyExceptionPayloadIfRequired(response);
            }
            return response;
        }

        @Override
        protected MuleEvent processNext(MuleEvent event) throws MuleException {
            return TemplateMessagingExceptionStrategy.this.route(event, this.exception);
        }

        @Override
        protected MuleEvent processCatch(MuleEvent event, MessagingException exception) throws MessagingException {
            try {
                this.logger.error((Object)"Exception during exception strategy execution");
                TemplateMessagingExceptionStrategy.this.doLogException(exception);
                TransactionCoordination.getInstance().rollbackCurrentTransaction();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            event.getMessage().setExceptionPayload(new DefaultExceptionPayload(exception));
            return event;
        }

        @Override
        protected void processFinally(MuleEvent event, MessagingException exception) {
            this.muleContext.getNotificationManager().fireNotification(new ExceptionStrategyNotification(event, 2002));
        }
    }
}

