/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.queue;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Lifecycle;
import org.mule.util.queue.QueueConfiguration;
import org.mule.util.queue.QueueManager;
import org.mule.util.queue.QueueSession;
import org.mule.util.queue.objectstore.TransactionalQueueManager;

public class DelegateQueueManager
implements QueueManager,
Lifecycle,
MuleContextAware {
    public static final String MULE_QUEUE_OLD_MODE_KEY = "mule.queue.objectstoremode";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private QueueManager delegate;

    public DelegateQueueManager() {
        if (DelegateQueueManager.isOldModeEnabled()) {
            this.logger.info((Object)"Using old QueueManager implementation");
            this.delegate = new TransactionalQueueManager();
        } else {
            this.delegate = new org.mule.util.queue.TransactionalQueueManager();
        }
    }

    @Override
    public QueueSession getQueueSession() {
        return this.delegate.getQueueSession();
    }

    @Override
    public void setDefaultQueueConfiguration(QueueConfiguration config) {
        this.delegate.setDefaultQueueConfiguration(config);
    }

    @Override
    public void setQueueConfiguration(String queueName, QueueConfiguration config) {
        this.delegate.setQueueConfiguration(queueName, config);
    }

    @Override
    public void start() throws MuleException {
        this.delegate.start();
    }

    @Override
    public void stop() throws MuleException {
        this.delegate.stop();
    }

    @Override
    public void dispose() {
        if (this.delegate instanceof Disposable) {
            ((Disposable)((Object)this.delegate)).dispose();
        }
    }

    @Override
    public void initialise() throws InitialisationException {
        if (this.delegate instanceof Initialisable) {
            ((Initialisable)((Object)this.delegate)).initialise();
        }
    }

    @Override
    public void setMuleContext(MuleContext context) {
        if (this.delegate instanceof MuleContextAware) {
            ((MuleContextAware)((Object)this.delegate)).setMuleContext(context);
        }
    }

    public static boolean isOldModeEnabled() {
        return Boolean.getBoolean(MULE_QUEUE_OLD_MODE_KEY);
    }

    QueueManager getDelegate() {
        return this.delegate;
    }
}

