/*
 * Decompiled with CFR 0.152.
 */
package org.mule.common.query;

import java.util.Iterator;
import java.util.List;
import org.mule.common.query.DefaultOperatorVisitor;
import org.mule.common.query.DefaultQueryVisitor;
import org.mule.common.query.DsqlKeyword;
import org.mule.common.query.Field;
import org.mule.common.query.Type;
import org.mule.common.query.expression.Direction;
import org.mule.common.query.expression.OperatorVisitor;
import org.mule.common.query.expression.Value;

public class DsqlQueryVisitor
extends DefaultQueryVisitor {
    private StringBuilder stringBuilder = new StringBuilder();

    @Override
    public void visitFields(List<Field> fields) {
        StringBuilder select = new StringBuilder();
        select.append((Object)DsqlKeyword.SELECT);
        select.append(" ");
        Iterator<Field> fieldIterable = fields.iterator();
        while (fieldIterable.hasNext()) {
            String fieldName = this.addQuotesIfNeeded(fieldIterable.next().getName());
            select.append(fieldName);
            if (!fieldIterable.hasNext()) continue;
            select.append(",");
        }
        this.stringBuilder.insert(0, select);
    }

    private String addQuotesIfNeeded(String name) {
        String result = name;
        if (name.contains(" ") || DsqlKeyword.isKeywordIgnoreCase(name)) {
            result = this.addQuotes(name);
        }
        return result;
    }

    private String addQuotes(String typeName) {
        StringBuilder result = new StringBuilder(typeName);
        result.insert(0, '\'');
        result.append('\'');
        return result.toString();
    }

    @Override
    public void visitTypes(List<Type> types) {
        this.stringBuilder.append(" ");
        this.stringBuilder.append((Object)DsqlKeyword.FROM);
        this.stringBuilder.append(" ");
        Iterator<Type> typeIterator = types.iterator();
        while (typeIterator.hasNext()) {
            String typeName = this.addQuotesIfNeeded(typeIterator.next().getName());
            this.stringBuilder.append(typeName);
            if (!typeIterator.hasNext()) continue;
            this.stringBuilder.append(",");
        }
    }

    @Override
    public void visitOrderByFields(List<Field> orderByFields, Direction direction) {
        this.stringBuilder.append(" ");
        this.stringBuilder.append((Object)DsqlKeyword.ORDER);
        this.stringBuilder.append(" ");
        this.stringBuilder.append((Object)DsqlKeyword.BY);
        this.stringBuilder.append(" ");
        Iterator<Field> orderByFieldsIterator = orderByFields.iterator();
        while (orderByFieldsIterator.hasNext()) {
            String fieldName = this.addQuotesIfNeeded(orderByFieldsIterator.next().getName());
            this.stringBuilder.append(fieldName);
            if (!orderByFieldsIterator.hasNext()) continue;
            this.stringBuilder.append(",");
        }
        this.stringBuilder.append(" ");
        this.stringBuilder.append(direction.toString());
    }

    @Override
    public void visitBeginExpression() {
        this.stringBuilder.append(" ");
        this.stringBuilder.append((Object)DsqlKeyword.WHERE);
        this.stringBuilder.append(" ");
    }

    @Override
    public void visitInitPrecedence() {
        this.stringBuilder.append("(");
    }

    @Override
    public void visitEndPrecedence() {
        this.stringBuilder.append(")");
    }

    @Override
    public void visitLimit(int limit) {
        this.stringBuilder.append(" ");
        this.stringBuilder.append((Object)DsqlKeyword.LIMIT);
        this.stringBuilder.append(" ").append(limit);
    }

    @Override
    public void visitOffset(int offset) {
        this.stringBuilder.append(" ");
        this.stringBuilder.append((Object)DsqlKeyword.OFFSET);
        this.stringBuilder.append(" ").append(offset);
    }

    @Override
    public void _dont_implement_QueryVisitor___instead_extend_DefaultQueryVisitor() {
    }

    @Override
    public void visitAnd() {
        this.stringBuilder.append(" ");
        this.stringBuilder.append((Object)DsqlKeyword.AND);
        this.stringBuilder.append(" ");
    }

    @Override
    public void visitOR() {
        this.stringBuilder.append(" ");
        this.stringBuilder.append((Object)DsqlKeyword.OR);
        this.stringBuilder.append(" ");
    }

    @Override
    public void visitComparison(String operator, Field field, Value<?> value) {
        String name = this.addQuotesIfNeeded(field.getName());
        this.stringBuilder.append(name).append(operator).append(value.toString());
    }

    @Override
    public OperatorVisitor operatorVisitor() {
        return new DefaultOperatorVisitor();
    }

    public String dsqlQuery() {
        return this.stringBuilder.toString();
    }
}

