/*
 * Decompiled with CFR 0.152.
 */
package org.python.icu.text;

import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import org.python.icu.impl.ICUCache;
import org.python.icu.impl.ICUResourceBundle;
import org.python.icu.impl.SimpleCache;
import org.python.icu.text.DecimalFormat;
import org.python.icu.text.NumberingSystem;
import org.python.icu.util.ULocale;
import org.python.icu.util.UResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CompactDecimalDataCache {
    private static final String SHORT_STYLE = "short";
    private static final String LONG_STYLE = "long";
    private static final String NUMBER_ELEMENTS = "NumberElements";
    private static final String PATTERN_LONG_PATH = "patternsLong/decimalFormat";
    private static final String PATTERNS_SHORT_PATH = "patternsShort/decimalFormat";
    static final String OTHER = "other";
    static final int MAX_DIGITS = 15;
    private static final String LATIN_NUMBERING_SYSTEM = "latn";
    private final ICUCache<ULocale, DataBundle> cache = new SimpleCache<ULocale, DataBundle>();

    CompactDecimalDataCache() {
    }

    DataBundle get(ULocale locale2) {
        DataBundle result2 = this.cache.get(locale2);
        if (result2 == null) {
            result2 = CompactDecimalDataCache.load(locale2);
            this.cache.put(locale2, result2);
        }
        return result2;
    }

    private static DataBundle load(ULocale ulocale) {
        ICUResourceBundle bundle;
        NumberingSystem ns = NumberingSystem.getInstance(ulocale);
        ICUResourceBundle r = (ICUResourceBundle)UResourceBundle.getBundleInstance("org/python/icu/impl/data/icudt56b", ulocale);
        r = r.getWithFallback(NUMBER_ELEMENTS);
        String numberingSystemName = ns.getName();
        ICUResourceBundle shortDataBundle = null;
        ICUResourceBundle longDataBundle = null;
        if (!LATIN_NUMBERING_SYSTEM.equals(numberingSystemName)) {
            bundle = CompactDecimalDataCache.findWithFallback(r, numberingSystemName, UResFlags.NOT_ROOT);
            shortDataBundle = CompactDecimalDataCache.findWithFallback(bundle, PATTERNS_SHORT_PATH, UResFlags.NOT_ROOT);
            longDataBundle = CompactDecimalDataCache.findWithFallback(bundle, PATTERN_LONG_PATH, UResFlags.NOT_ROOT);
        }
        if (shortDataBundle == null) {
            bundle = CompactDecimalDataCache.getWithFallback(r, LATIN_NUMBERING_SYSTEM, UResFlags.ANY);
            shortDataBundle = CompactDecimalDataCache.getWithFallback(bundle, PATTERNS_SHORT_PATH, UResFlags.ANY);
            if (longDataBundle == null && (longDataBundle = CompactDecimalDataCache.findWithFallback(bundle, PATTERN_LONG_PATH, UResFlags.ANY)) != null && CompactDecimalDataCache.isRoot(longDataBundle) && !CompactDecimalDataCache.isRoot(shortDataBundle)) {
                longDataBundle = null;
            }
        }
        Data shortData = CompactDecimalDataCache.loadStyle(shortDataBundle, ulocale, SHORT_STYLE);
        Data longData = longDataBundle == null ? shortData : CompactDecimalDataCache.loadStyle(longDataBundle, ulocale, LONG_STYLE);
        return new DataBundle(shortData, longData);
    }

    private static ICUResourceBundle findWithFallback(ICUResourceBundle r, String path, UResFlags flags) {
        if (r == null) {
            return null;
        }
        ICUResourceBundle result2 = r.findWithFallback(path);
        if (result2 == null) {
            return null;
        }
        switch (flags) {
            case NOT_ROOT: {
                return CompactDecimalDataCache.isRoot(result2) ? null : result2;
            }
            case ANY: {
                return result2;
            }
        }
        throw new IllegalArgumentException();
    }

    private static ICUResourceBundle getWithFallback(ICUResourceBundle r, String path, UResFlags flags) {
        ICUResourceBundle result2 = CompactDecimalDataCache.findWithFallback(r, path, flags);
        if (result2 == null) {
            throw new MissingResourceException("Cannot find " + path, ICUResourceBundle.class.getName(), path);
        }
        return result2;
    }

    private static boolean isRoot(ICUResourceBundle r) {
        ULocale bundleLocale = r.getULocale();
        return bundleLocale.equals(ULocale.ROOT) || bundleLocale.toString().equals("root");
    }

    private static Data loadStyle(ICUResourceBundle r, ULocale locale2, String style) {
        int size = r.getSize();
        Data result2 = new Data(new long[15], new HashMap<String, DecimalFormat.Unit[]>());
        for (int i = 0; i < size; ++i) {
            CompactDecimalDataCache.populateData(r.get(i), locale2, style, result2);
        }
        CompactDecimalDataCache.fillInMissing(result2);
        return result2;
    }

    private static void populateData(UResourceBundle divisorData, ULocale locale2, String style, Data result2) {
        long magnitude = Long.parseLong(divisorData.getKey());
        int thisIndex = (int)Math.log10(magnitude);
        if (thisIndex >= 15) {
            return;
        }
        int size = divisorData.getSize();
        int numZeros = 0;
        boolean otherVariantDefined = false;
        for (int i = 0; i < size; ++i) {
            int nz;
            UResourceBundle pluralVariantData = divisorData.get(i);
            String pluralVariant = pluralVariantData.getKey();
            String template = pluralVariantData.getString();
            if (pluralVariant.equals(OTHER)) {
                otherVariantDefined = true;
            }
            if ((nz = CompactDecimalDataCache.populatePrefixSuffix(pluralVariant, thisIndex, template, locale2, style, result2)) == numZeros) continue;
            if (numZeros != 0) {
                throw new IllegalArgumentException("Plural variant '" + pluralVariant + "' template '" + template + "' for 10^" + thisIndex + " has wrong number of zeros in " + CompactDecimalDataCache.localeAndStyle(locale2, style));
            }
            numZeros = nz;
        }
        if (!otherVariantDefined) {
            throw new IllegalArgumentException("No 'other' plural variant defined for 10^" + thisIndex + "in " + CompactDecimalDataCache.localeAndStyle(locale2, style));
        }
        long divisor = magnitude;
        for (int i = 1; i < numZeros; ++i) {
            divisor /= 10L;
        }
        result2.divisors[thisIndex] = divisor;
    }

    private static int populatePrefixSuffix(String pluralVariant, int idx, String template, ULocale locale2, String style, Data result2) {
        int i;
        int firstIdx = template.indexOf("0");
        int lastIdx = template.lastIndexOf("0");
        if (firstIdx == -1) {
            throw new IllegalArgumentException("Expect at least one zero in template '" + template + "' for variant '" + pluralVariant + "' for 10^" + idx + " in " + CompactDecimalDataCache.localeAndStyle(locale2, style));
        }
        String prefix = CompactDecimalDataCache.fixQuotes(template.substring(0, firstIdx));
        String suffix = CompactDecimalDataCache.fixQuotes(template.substring(lastIdx + 1));
        CompactDecimalDataCache.saveUnit(new DecimalFormat.Unit(prefix, suffix), pluralVariant, idx, result2.units);
        if (prefix.trim().length() == 0 && suffix.trim().length() == 0) {
            return idx + 1;
        }
        for (i = firstIdx + 1; i <= lastIdx && template.charAt(i) == '0'; ++i) {
        }
        return i - firstIdx;
    }

    private static String fixQuotes(String prefixOrSuffix) {
        StringBuilder result2 = new StringBuilder();
        int len = prefixOrSuffix.length();
        QuoteState state = QuoteState.OUTSIDE;
        block4: for (int idx = 0; idx < len; ++idx) {
            char ch = prefixOrSuffix.charAt(idx);
            if (ch == '\'') {
                if (state == QuoteState.INSIDE_EMPTY) {
                    result2.append('\'');
                }
            } else {
                result2.append(ch);
            }
            switch (state) {
                case OUTSIDE: {
                    state = ch == '\'' ? QuoteState.INSIDE_EMPTY : QuoteState.OUTSIDE;
                    continue block4;
                }
                case INSIDE_EMPTY: 
                case INSIDE_FULL: {
                    state = ch == '\'' ? QuoteState.OUTSIDE : QuoteState.INSIDE_FULL;
                    continue block4;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        return result2.toString();
    }

    private static String localeAndStyle(ULocale locale2, String style) {
        return "locale '" + locale2 + "' style '" + style + "'";
    }

    private static void fillInMissing(Data result2) {
        long lastDivisor = 1L;
        for (int i = 0; i < result2.divisors.length; ++i) {
            if (result2.units.get(OTHER)[i] == null) {
                result2.divisors[i] = lastDivisor;
                CompactDecimalDataCache.copyFromPreviousIndex(i, result2.units);
                continue;
            }
            lastDivisor = result2.divisors[i];
            CompactDecimalDataCache.propagateOtherToMissing(i, result2.units);
        }
    }

    private static void propagateOtherToMissing(int idx, Map<String, DecimalFormat.Unit[]> units) {
        DecimalFormat.Unit otherVariantValue = units.get(OTHER)[idx];
        for (DecimalFormat.Unit[] byBase : units.values()) {
            if (byBase[idx] != null) continue;
            byBase[idx] = otherVariantValue;
        }
    }

    private static void copyFromPreviousIndex(int idx, Map<String, DecimalFormat.Unit[]> units) {
        for (DecimalFormat.Unit[] byBase : units.values()) {
            if (idx == 0) {
                byBase[idx] = DecimalFormat.NULL_UNIT;
                continue;
            }
            byBase[idx] = byBase[idx - 1];
        }
    }

    private static void saveUnit(DecimalFormat.Unit unit, String pluralVariant, int idx, Map<String, DecimalFormat.Unit[]> units) {
        DecimalFormat.Unit[] byBase = units.get(pluralVariant);
        if (byBase == null) {
            byBase = new DecimalFormat.Unit[15];
            units.put(pluralVariant, byBase);
        }
        byBase[idx] = unit;
    }

    static DecimalFormat.Unit getUnit(Map<String, DecimalFormat.Unit[]> units, String variant, int base2) {
        DecimalFormat.Unit[] byBase = units.get(variant);
        if (byBase == null) {
            byBase = units.get(OTHER);
        }
        return byBase[base2];
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum UResFlags {
        ANY,
        NOT_ROOT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum QuoteState {
        OUTSIDE,
        INSIDE_EMPTY,
        INSIDE_FULL;

    }

    static class DataBundle {
        Data shortData;
        Data longData;

        DataBundle(Data shortData, Data longData) {
            this.shortData = shortData;
            this.longData = longData;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Data {
        long[] divisors;
        Map<String, DecimalFormat.Unit[]> units;

        Data(long[] divisors, Map<String, DecimalFormat.Unit[]> units) {
            this.divisors = divisors;
            this.units = units;
        }
    }
}

