/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.pgp;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchProviderException;
import java.util.Iterator;
import org.apache.commons.lang.Validate;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPEncryptedDataList;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPOnePassSignatureList;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKeyEncryptedData;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PublicKeyDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.bc.BcPublicKeyDataDecryptorFactory;
import org.mule.module.pgp.StreamTransformer;
import org.mule.module.pgp.util.BouncyCastleUtil;

public class DecryptStreamTransformer
implements StreamTransformer {
    public static final String INVALID_KEY_ERROR_MESSAGE = "User selected private key ID %s (through secretAliasId) but message was encrypted for key ID %s";
    public static final String INVALID_PGP_MESSAGE_ERROR = "Invalid PGP message";
    public static final String INVALID_PASS_PHRASE_ERROR_MESSAGE = "PassPhrase '%s' is invalid for the private key with id '%s'";
    private static final String CHECKSUM_MESSAGE = "checksum mismatch";
    private PGPSecretKeyRingCollection secretKeys;
    private PGPSecretKey secretKey;
    private String password;
    private final boolean configuredSecretKey;
    private InputStream compressedStream;
    private InputStream clearStream;

    public DecryptStreamTransformer(PGPSecretKey secretKey, PGPSecretKeyRingCollection secretKeys, String password) throws IOException {
        Validate.notNull((Object)password, (String)"The password should not be null");
        this.configuredSecretKey = secretKey != null;
        this.secretKey = secretKey;
        this.secretKeys = secretKeys;
        this.password = password;
    }

    @Override
    public InputStream process(InputStream toBeDecrypted) throws Exception {
        InputStream decodedInputStream = PGPUtil.getDecoderStream((InputStream)toBeDecrypted);
        PGPObjectFactory pgpF = new PGPObjectFactory(decodedInputStream, (KeyFingerPrintCalculator)BouncyCastleUtil.KEY_FINGERPRINT_CALCULATOR);
        Object pgpObject = pgpF.nextObject();
        if (pgpObject == null) {
            throw new PGPException(INVALID_PGP_MESSAGE_ERROR);
        }
        PGPEncryptedDataList enc = pgpObject instanceof PGPEncryptedDataList ? (PGPEncryptedDataList)pgpObject : (PGPEncryptedDataList)pgpF.nextObject();
        Iterator it = enc.getEncryptedDataObjects();
        PGPPublicKeyEncryptedData pbe = null;
        PGPPrivateKey privateKey = null;
        while (privateKey == null && it.hasNext()) {
            pbe = (PGPPublicKeyEncryptedData)it.next();
            privateKey = this.getPrivateKey(pbe.getKeyID(), this.password);
            if (privateKey != null) continue;
            throw new PGPException("Failed to find private key with ID " + pbe.getKeyID());
        }
        this.clearStream = pbe.getDataStream((PublicKeyDataDecryptorFactory)new BcPublicKeyDataDecryptorFactory(privateKey));
        PGPObjectFactory pgpObjectFactory = new PGPObjectFactory(this.clearStream, (KeyFingerPrintCalculator)BouncyCastleUtil.KEY_FINGERPRINT_CALCULATOR);
        pgpObject = pgpObjectFactory.nextObject();
        while (!(pgpObject instanceof PGPLiteralData)) {
            if (pgpObject instanceof PGPOnePassSignatureList) {
                pgpObject = pgpObjectFactory.nextObject();
                continue;
            }
            if (pgpObject instanceof PGPCompressedData) {
                PGPCompressedData cData = (PGPCompressedData)pgpObject;
                this.compressedStream = new BufferedInputStream(cData.getDataStream());
                pgpObjectFactory = new PGPObjectFactory(this.compressedStream, (KeyFingerPrintCalculator)BouncyCastleUtil.KEY_FINGERPRINT_CALCULATOR);
                pgpObject = pgpObjectFactory.nextObject();
                continue;
            }
            throw new PGPException("input is not PGPLiteralData - type unknown.");
        }
        PGPLiteralData pgpLiteralData = (PGPLiteralData)pgpObject;
        return pgpLiteralData.getInputStream();
    }

    private PGPPrivateKey getPrivateKey(long keyID, String passPhrase) throws PGPException, NoSuchProviderException {
        PGPSecretKey pgpSecKey = this.configuredSecretKey ? this.secretKey : this.secretKeys.getSecretKey(keyID);
        if (this.configuredSecretKey && pgpSecKey.getKeyID() != keyID) {
            throw new PGPException(this.createInvalidKeyErrorMessage(pgpSecKey.getKeyID(), keyID));
        }
        try {
            PGPPrivateKey pgpPrivateKey = pgpSecKey.extractPrivateKey(BouncyCastleUtil.PBE_SECRET_KEY_DECRYPTOR_BUILDER.build(passPhrase.toCharArray()));
            return pgpPrivateKey;
        }
        catch (PGPException e) {
            throw this.wrapWrongPassPhraseException(e, passPhrase, pgpSecKey.getKeyID());
        }
    }

    private String createInvalidKeyErrorMessage(Long configuredKeyId, Long validKeyId) {
        return String.format(INVALID_KEY_ERROR_MESSAGE, Long.toHexString(configuredKeyId).toUpperCase(), Long.toHexString(validKeyId).toUpperCase());
    }

    private PGPException wrapWrongPassPhraseException(PGPException pgpException, String invalidPassPhrase, Long keyId) {
        if (pgpException.getMessage().contains(CHECKSUM_MESSAGE)) {
            return new PGPException(this.createInvalidPassPhraseErrorMessage(invalidPassPhrase, keyId));
        }
        return pgpException;
    }

    private String createInvalidPassPhraseErrorMessage(String invalidPassPhrase, long keyId) {
        return String.format(INVALID_PASS_PHRASE_ERROR_MESSAGE, invalidPassPhrase, Long.toHexString(keyId).toUpperCase());
    }
}

