/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.domain.executor;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.mule.module.db.internal.domain.autogeneratedkey.AutoGeneratedKeyStrategy;
import org.mule.module.db.internal.domain.connection.DbConnection;
import org.mule.module.db.internal.domain.executor.AbstractExecutor;
import org.mule.module.db.internal.domain.executor.QueryExecutor;
import org.mule.module.db.internal.domain.logger.SingleQueryLogger;
import org.mule.module.db.internal.domain.query.Query;
import org.mule.module.db.internal.domain.statement.StatementFactory;

public abstract class AbstractSingleQueryExecutor
extends AbstractExecutor
implements QueryExecutor {
    public AbstractSingleQueryExecutor(StatementFactory statementFactory) {
        super(statementFactory);
    }

    @Override
    public final Object execute(final DbConnection connection, final Query query) throws SQLException {
        final Statement statement = this.statementFactory.create(connection, query.getQueryTemplate());
        return this.safely(statement, new SQLDelegate(){

            @Override
            public Object run() throws SQLException {
                AbstractSingleQueryExecutor.this.prepareQuery(statement, query);
                return AbstractSingleQueryExecutor.this.doExecuteQuery(connection, statement, query);
            }
        });
    }

    @Override
    public final Object execute(final DbConnection connection, final Query query, final AutoGeneratedKeyStrategy autoGeneratedKeyStrategy) throws SQLException {
        final Statement statement = this.statementFactory.create(connection, query.getQueryTemplate(), autoGeneratedKeyStrategy);
        return this.safely(statement, new SQLDelegate(){

            @Override
            public Object run() throws SQLException {
                AbstractSingleQueryExecutor.this.prepareQuery(statement, query);
                return AbstractSingleQueryExecutor.this.doExecuteQuery(connection, statement, query, autoGeneratedKeyStrategy);
            }
        });
    }

    protected abstract Object doExecuteQuery(DbConnection var1, Statement var2, Query var3) throws SQLException;

    protected abstract Object doExecuteQuery(DbConnection var1, Statement var2, Query var3, AutoGeneratedKeyStrategy var4) throws SQLException;

    protected void prepareQuery(Statement statement, Query query) throws SQLException {
        SingleQueryLogger queryLogger = this.queryLoggerFactory.createQueryLogger(this.logger, query.getQueryTemplate());
        if (statement instanceof PreparedStatement) {
            this.doProcessParameters((PreparedStatement)statement, query.getQueryTemplate(), query.getParamValues(), queryLogger);
        }
        queryLogger.logQuery();
    }

    private Object safely(Statement statement, SQLDelegate delegate) throws SQLException {
        try {
            return delegate.run();
        }
        catch (SQLException e) {
            block4: {
                try {
                    statement.close();
                }
                catch (SQLException e2) {
                    if (!this.logger.isWarnEnabled()) break block4;
                    this.logger.warn((Object)"Could not close statement", (Throwable)e2);
                }
            }
            throw e;
        }
    }

    private static interface SQLDelegate {
        public Object run() throws SQLException;
    }
}

