/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.tcp.reactor;

import org.springframework.messaging.Message;
import org.springframework.messaging.tcp.TcpConnection;
import org.springframework.messaging.tcp.reactor.PassThroughPromiseToListenableFutureAdapter;
import org.springframework.util.concurrent.ListenableFuture;
import reactor.core.composable.Promise;
import reactor.net.NetChannel;

public class Reactor11TcpConnection<P>
implements TcpConnection<P> {
    private final NetChannel<Message<P>, Message<P>> channel;

    public Reactor11TcpConnection(NetChannel<Message<P>, Message<P>> connection) {
        this.channel = connection;
    }

    @Override
    public ListenableFuture<Void> send(Message<P> message) {
        Promise promise = this.channel.send(message);
        return new PassThroughPromiseToListenableFutureAdapter<Void>((Promise<Void>)promise);
    }

    @Override
    public void onReadInactivity(Runnable runnable, long inactivityDuration) {
        this.channel.on().readIdle(inactivityDuration, runnable);
    }

    @Override
    public void onWriteInactivity(Runnable runnable, long inactivityDuration) {
        this.channel.on().writeIdle(inactivityDuration, runnable);
    }

    @Override
    public void close() {
        this.channel.close();
    }
}

