/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.SmackInitializer;
import org.jivesoftware.smack.parsing.ExceptionThrowingCallback;
import org.jivesoftware.smack.parsing.ParsingExceptionCallback;
import org.jivesoftware.smack.util.FileUtils;
import org.xmlpull.mxp1.MXParser;
import org.xmlpull.v1.XmlPullParser;

public final class SmackConfiguration {
    private static final String SMACK_VERSION = "3.4.0";
    private static final String DEFAULT_CONFIG_FILE = "classpath:META-INF/smack-config.xml";
    private static final Logger log = Logger.getLogger(SmackConfiguration.class.getName());
    private static InputStream configFileStream;
    private static int packetReplyTimeout;
    private static int keepAliveInterval;
    private static List<String> defaultMechs;
    private static boolean localSocks5ProxyEnabled;
    private static int localSocks5ProxyPort;
    private static int packetCollectorSize;
    private static boolean initialized;
    private static ParsingExceptionCallback defaultCallback;
    private static boolean autoEnableEntityCaps;

    private SmackConfiguration() {
    }

    public static void setConfigFileUrl(String configFileUrl, ClassLoader loader) {
        try {
            configFileStream = FileUtils.getStreamForUrl(configFileUrl, loader);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to create input stream from specified file URL [" + configFileUrl + "]", e);
        }
        SmackConfiguration.initialize();
    }

    public static void setConfigFileStream(InputStream configFile) {
        configFileStream = configFile;
        SmackConfiguration.initialize();
    }

    public static String getVersion() {
        return SMACK_VERSION;
    }

    public static int getPacketReplyTimeout() {
        SmackConfiguration.initialize();
        if (packetReplyTimeout <= 0) {
            packetReplyTimeout = 5000;
        }
        return packetReplyTimeout;
    }

    public static void setPacketReplyTimeout(int timeout) {
        SmackConfiguration.initialize();
        if (timeout <= 0) {
            throw new IllegalArgumentException();
        }
        packetReplyTimeout = timeout;
    }

    public static int getKeepAliveInterval() {
        SmackConfiguration.initialize();
        return keepAliveInterval;
    }

    public static void setKeepAliveInterval(int interval) {
        SmackConfiguration.initialize();
        keepAliveInterval = interval;
    }

    public static int getPacketCollectorSize() {
        SmackConfiguration.initialize();
        return packetCollectorSize;
    }

    public static void setPacketCollectorSize(int collectorSize) {
        SmackConfiguration.initialize();
        packetCollectorSize = collectorSize;
    }

    public static void addSaslMech(String mech) {
        SmackConfiguration.initialize();
        if (!defaultMechs.contains(mech)) {
            defaultMechs.add(mech);
        }
    }

    public static void addSaslMechs(Collection<String> mechs) {
        SmackConfiguration.initialize();
        for (String mech : mechs) {
            SmackConfiguration.addSaslMech(mech);
        }
    }

    public static void removeSaslMech(String mech) {
        SmackConfiguration.initialize();
        defaultMechs.remove(mech);
    }

    public static void removeSaslMechs(Collection<String> mechs) {
        SmackConfiguration.initialize();
        defaultMechs.removeAll(mechs);
    }

    public static List<String> getSaslMechs() {
        return Collections.unmodifiableList(defaultMechs);
    }

    public static boolean isLocalSocks5ProxyEnabled() {
        SmackConfiguration.initialize();
        return localSocks5ProxyEnabled;
    }

    public static void setLocalSocks5ProxyEnabled(boolean localSocks5ProxyEnabled) {
        SmackConfiguration.initialize();
        SmackConfiguration.localSocks5ProxyEnabled = localSocks5ProxyEnabled;
    }

    public static int getLocalSocks5ProxyPort() {
        SmackConfiguration.initialize();
        return localSocks5ProxyPort;
    }

    public static void setLocalSocks5ProxyPort(int localSocks5ProxyPort) {
        SmackConfiguration.initialize();
        SmackConfiguration.localSocks5ProxyPort = localSocks5ProxyPort;
    }

    public static boolean autoEnableEntityCaps() {
        SmackConfiguration.initialize();
        return autoEnableEntityCaps;
    }

    public static void setAutoEnableEntityCaps(boolean b) {
        SmackConfiguration.initialize();
        autoEnableEntityCaps = b;
    }

    public static void setDefaultParsingExceptionCallback(ParsingExceptionCallback callback) {
        SmackConfiguration.initialize();
        defaultCallback = callback;
    }

    public static ParsingExceptionCallback getDefaultParsingExceptionCallback() {
        SmackConfiguration.initialize();
        return defaultCallback;
    }

    private static void parseClassToLoad(XmlPullParser parser) throws Exception {
        String className = parser.nextText();
        try {
            Class<?> initClass = Class.forName(className);
            if (SmackInitializer.class.isAssignableFrom(initClass)) {
                SmackInitializer initializer = (SmackInitializer)initClass.newInstance();
                initializer.initialize();
            }
        }
        catch (ClassNotFoundException cnfe) {
            log.log(Level.WARNING, "A startup class [" + className + "] specified in smack-config.xml could not be loaded: ");
        }
    }

    private static int parseIntProperty(XmlPullParser parser, int defaultValue) throws Exception {
        try {
            return Integer.parseInt(parser.nextText());
        }
        catch (NumberFormatException nfe) {
            log.log(Level.SEVERE, "Could not parse integer", nfe);
            return defaultValue;
        }
    }

    private static void initialize() {
        if (initialized) {
            return;
        }
        initialized = true;
        String configFileLocation = System.getProperty("smack.config.file");
        if (configFileLocation != null) {
            try {
                configFileStream = FileUtils.getStreamForUrl(configFileLocation, null);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Error creating input stream for config file [" + configFileLocation + "] from VM argument", e);
            }
        }
        if (configFileStream == null) {
            try {
                configFileStream = FileUtils.getStreamForUrl(DEFAULT_CONFIG_FILE, null);
            }
            catch (Exception e) {
                log.log(Level.INFO, "Could not create input stream for default config file [classpath:META-INF/smack-config.xml]", e);
            }
        }
        if (configFileStream != null) {
            SmackConfiguration.readFile(configFileStream);
        } else {
            log.log(Level.INFO, "No configuration file found");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readFile(InputStream cfgFileStream) {
        MXParser parser = new MXParser();
        try {
            parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
            parser.setInput(cfgFileStream, "UTF-8");
            int eventType = parser.getEventType();
            do {
                if (eventType != 2) continue;
                if (parser.getName().equals("className")) {
                    SmackConfiguration.parseClassToLoad(parser);
                    continue;
                }
                if (parser.getName().equals("packetReplyTimeout")) {
                    packetReplyTimeout = SmackConfiguration.parseIntProperty(parser, packetReplyTimeout);
                    continue;
                }
                if (parser.getName().equals("keepAliveInterval")) {
                    keepAliveInterval = SmackConfiguration.parseIntProperty(parser, keepAliveInterval);
                    continue;
                }
                if (parser.getName().equals("mechName")) {
                    defaultMechs.add(parser.nextText());
                    continue;
                }
                if (parser.getName().equals("localSocks5ProxyEnabled")) {
                    localSocks5ProxyEnabled = Boolean.parseBoolean(parser.nextText());
                    continue;
                }
                if (parser.getName().equals("localSocks5ProxyPort")) {
                    localSocks5ProxyPort = SmackConfiguration.parseIntProperty(parser, localSocks5ProxyPort);
                    continue;
                }
                if (parser.getName().equals("packetCollectorSize")) {
                    packetCollectorSize = SmackConfiguration.parseIntProperty(parser, packetCollectorSize);
                    continue;
                }
                if (!parser.getName().equals("autoEnableEntityCaps")) continue;
                autoEnableEntityCaps = Boolean.parseBoolean(parser.nextText());
            } while ((eventType = parser.next()) != 1);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Error occurred while reading config file", e);
        }
        finally {
            try {
                cfgFileStream.close();
            }
            catch (IOException e) {
                log.log(Level.INFO, "Error while closing config file input stream", e);
            }
        }
    }

    static {
        packetReplyTimeout = 5000;
        keepAliveInterval = 30000;
        defaultMechs = new ArrayList<String>();
        localSocks5ProxyEnabled = true;
        localSocks5ProxyPort = 7777;
        packetCollectorSize = 5000;
        initialized = false;
        defaultCallback = new ExceptionThrowingCallback();
        autoEnableEntityCaps = true;
    }
}

