/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.resource.spi.work.Work;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.util.concurrent.Latch;

public class DefaultMuleWorkManagerTestCase
extends AbstractMuleContextTestCase {
    private static final int MAX_NUMBER_OF_THREADS_ALLOWED = 2;
    @Rule
    public SystemProperty systemProperty = new SystemProperty("mule.context.workmanager.maxthreadsactive", String.valueOf(2));

    @Test
    public void contextWorkManagerCanBeConfiguredThroughSystemProperties() throws Exception {
        final Thread currentThread = Thread.currentThread();
        final AtomicBoolean workExecutedInCurrentThread = new AtomicBoolean(false);
        final Latch holdThreads = new Latch();
        for (int i = 0; i < 3; ++i) {
            muleContext.getWorkManager().scheduleWork(new Work(){

                public void release() {
                }

                public void run() {
                    if (Thread.currentThread().equals(currentThread)) {
                        workExecutedInCurrentThread.set(true);
                        return;
                    }
                    try {
                        holdThreads.await();
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        Assert.assertThat((Object)workExecutedInCurrentThread.get(), (Matcher)Is.is((Object)true));
        holdThreads.release();
    }
}

