/*
 * Decompiled with CFR 0.152.
 */
package org.mule.api.util;

import java.util.regex.Pattern;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.mule.api.util.CredentialsMaskUtil;

public class CredentialsMaskUtilTestCase {
    private static final String URL_TEST = "jdbc:sqlserver://1.1.1.1:1443;databaseName=STAGING;user=mulesoftuser;password=mulesoftpass;";
    private static final String EXPECTED_URL_TEST_MASKED = "jdbc:sqlserver://1.1.1.1:1443;databaseName=STAGING;user=<<user>>;password=<<credentials>>;";

    @Test
    public void whenUrlWithUserAndPasswordMaskUserPassword() {
        String maskedUrl = CredentialsMaskUtil.maskUrlUserAndPassword((String)URL_TEST, (Pattern)CredentialsMaskUtil.PASSWORD_PATTERN_NO_QUOTES, (Pattern)CredentialsMaskUtil.USER_PATTERN_NO_QUOTES);
        MatcherAssert.assertThat((Object)maskedUrl, (Matcher)CoreMatchers.equalTo((Object)EXPECTED_URL_TEST_MASKED));
    }
}

