/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.junit4.matcher;

import java.util.List;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.mule.api.debug.FieldDebugInfo;
import org.mule.api.debug.ObjectFieldDebugInfo;

public class ObjectDebugInfoMatcher
extends TypeSafeMatcher<FieldDebugInfo<?>> {
    private final String name;
    private final String type;
    private final List<Matcher<FieldDebugInfo<?>>> fieldMatchers;

    public ObjectDebugInfoMatcher(String name, Class<?> type, List<Matcher<FieldDebugInfo<?>>> fieldMatchers) {
        this.name = name;
        this.type = type.getName();
        this.fieldMatchers = fieldMatchers;
    }

    protected boolean matchesSafely(FieldDebugInfo<?> fieldDebugInfo) {
        if (!this.name.equals(fieldDebugInfo.getName())) {
            return false;
        }
        if (!(fieldDebugInfo instanceof ObjectFieldDebugInfo)) {
            return false;
        }
        if (this.type != null && !this.type.equals(fieldDebugInfo.getType()) || this.type == null && fieldDebugInfo.getType() != null) {
            return false;
        }
        ObjectFieldDebugInfo objectFieldDebugInfo = (ObjectFieldDebugInfo)fieldDebugInfo;
        List fieldDebugInfos = (List)objectFieldDebugInfo.getValue();
        if (this.fieldMatchers.size() != fieldDebugInfos.size()) {
            return false;
        }
        try {
            for (Matcher<FieldDebugInfo<?>> fieldMatcher : this.fieldMatchers) {
                MatcherAssert.assertThat((Object)fieldDebugInfos, (Matcher)Matchers.hasItem(fieldMatcher));
            }
            return true;
        }
        catch (AssertionError assertionError) {
            return false;
        }
    }

    public void describeTo(Description description) {
        description.appendText(String.format("an %s with name: '%s' type: '%s' and containing [ ", ObjectFieldDebugInfo.class.getSimpleName(), this.name, this.type));
        boolean firstMatcher = true;
        for (Matcher<FieldDebugInfo<?>> fieldMatcher : this.fieldMatchers) {
            if (firstMatcher) {
                firstMatcher = false;
            } else {
                description.appendText(", ");
            }
            fieldMatcher.describeTo(description);
        }
        description.appendText("]");
    }

    @Factory
    public static Matcher<FieldDebugInfo<?>> objectLike(String name, Class<?> type, List<Matcher<FieldDebugInfo<?>>> fieldMatchers) {
        return new ObjectDebugInfoMatcher(name, type, fieldMatchers);
    }
}

