/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.testmodels.mule;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleEvent;
import org.mule.api.exception.MessagingExceptionHandler;
import org.mule.api.exception.RollbackSourceCallback;
import org.mule.api.exception.SystemExceptionHandler;
import org.mule.exception.AbstractExceptionListener;

public class TestExceptionStrategy
extends AbstractExceptionListener
implements MessagingExceptionHandler,
SystemExceptionHandler {
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private Object callbackLock = new Object();
    private ExceptionCallback callback;
    private List<Exception> unhandled = new LinkedList<Exception>();
    private volatile String testProperty;

    public String getTestProperty() {
        return this.testProperty;
    }

    public void setTestProperty(String testProperty) {
        this.testProperty = testProperty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MuleEvent handleException(Exception exception, MuleEvent event, RollbackSourceCallback rollbackMethod) {
        ExceptionCallback callback = null;
        Object object = this.callbackLock;
        synchronized (object) {
            if (this.callback != null) {
                callback = this.callback;
            } else {
                this.unhandled.add(exception);
            }
        }
        this.logger.info((Object)("Handling exception: " + exception.getClass().getName()));
        if (callback != null) {
            this.logger.info((Object)"Exception caught on TestExceptionStrategy and was sent to callback.", (Throwable)exception);
            callback.onException(exception);
        } else {
            this.logger.info((Object)"Exception caught on TestExceptionStrategy but there was no callback set.", (Throwable)exception);
        }
        return event;
    }

    public MuleEvent handleException(Exception exception, MuleEvent event) {
        return this.handleException(exception, event, null);
    }

    public void handleException(Exception exception, RollbackSourceCallback rollbackMethod) {
        this.handleException(exception, null, rollbackMethod);
    }

    public void handleException(Exception exception) {
        this.handleException(exception, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExceptionCallback(ExceptionCallback exceptionCallback) {
        Object object = this.callbackLock;
        synchronized (object) {
            this.callback = exceptionCallback;
        }
        this.processUnhandled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processUnhandled() {
        ArrayList<Exception> unhandledCopies = null;
        ExceptionCallback callback = null;
        Iterator iterator = this.callbackLock;
        synchronized (iterator) {
            if (this.callback != null) {
                callback = this.callback;
                unhandledCopies = new ArrayList<Exception>(this.unhandled);
                this.unhandled.clear();
            }
        }
        if (callback != null && unhandledCopies != null) {
            for (Exception exception : unhandledCopies) {
                this.logger.info((Object)"Handling exception after setting the callback.", (Throwable)exception);
                callback.onException(exception);
            }
        }
    }

    public static interface ExceptionCallback {
        public void onException(Throwable var1);
    }
}

