/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.store;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.Mockito;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.MuleRuntimeException;
import org.mule.api.config.MuleConfiguration;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.serialization.SerializationException;
import org.mule.api.store.ObjectStoreException;
import org.mule.config.i18n.CoreMessages;
import org.mule.tck.NonSerializableObject;
import org.mule.tck.SerializationTestUtils;
import org.mule.util.FileUtils;
import org.mule.util.UUID;
import org.mule.util.queue.objectstore.QueueKey;
import org.mule.util.store.AbstractObjectStoreContractTestCase;
import org.mule.util.store.MonitoredObjectStoreWrapper;
import org.mule.util.store.QueuePersistenceObjectStore;

public class QueuePersistenceObjectStoreTestCase
extends AbstractObjectStoreContractTestCase {
    private static final String QUEUE_NAME = "the-queue";
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();
    private File persistenceFolder;
    private MuleContext mockMuleContext;

    @Override
    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.initMockMuleContext();
    }

    private void initMockMuleContext() throws IOException {
        this.persistenceFolder = this.tempFolder.newFolder("persistence");
        MuleConfiguration mockConfig = (MuleConfiguration)Mockito.mock(MuleConfiguration.class);
        Mockito.when((Object)mockConfig.getWorkingDirectory()).thenReturn((Object)this.persistenceFolder.getAbsolutePath());
        this.mockMuleContext = (MuleContext)Mockito.mock(MuleContext.class);
        Mockito.when((Object)this.mockMuleContext.getConfiguration()).thenReturn((Object)mockConfig);
        Mockito.when((Object)this.mockMuleContext.getExecutionClassLoader()).thenReturn((Object)this.getClass().getClassLoader());
        SerializationTestUtils.addJavaSerializerToMockMuleContext(this.mockMuleContext);
    }

    public QueuePersistenceObjectStore<Serializable> getObjectStore() throws ObjectStoreException {
        QueuePersistenceObjectStore store = new QueuePersistenceObjectStore(this.mockMuleContext);
        store.open();
        return store;
    }

    @Override
    public Serializable getStorableValue() {
        return new DefaultMuleMessage((Object)"Test Message", muleContext);
    }

    @Override
    protected Serializable createKey() {
        return new QueueKey("theQueue", (Serializable)((Object)UUID.getUUID()));
    }

    @Test
    public void testCreatingTheObjectStoreThrowsMuleRuntimeException() {
        MuleRuntimeException muleRuntimeException = new MuleRuntimeException(CoreMessages.createStaticMessage((String)"boom"));
        MuleContext mockContext = (MuleContext)Mockito.mock(MuleContext.class);
        Mockito.when((Object)mockContext.getConfiguration()).thenThrow(new Throwable[]{muleRuntimeException});
        QueuePersistenceObjectStore store = new QueuePersistenceObjectStore(mockContext);
        try {
            store.open();
            Assert.fail();
        }
        catch (ObjectStoreException objectStoreException) {
            // empty catch block
        }
    }

    @Test
    public void testAllKeysOnNotYetOpenedStore() throws ObjectStoreException {
        QueuePersistenceObjectStore store = new QueuePersistenceObjectStore(this.mockMuleContext);
        List allKeys = store.allKeys();
        Assert.assertEquals((long)0L, (long)allKeys.size());
    }

    @Test
    public void testListExistingFiles() throws Exception {
        QueuePersistenceObjectStore<Serializable> store = this.getObjectStore();
        String id = UUID.getUUID();
        this.createAndPopulateStoreFile(id, "Test Message");
        List allKeys = store.allKeys();
        Assert.assertEquals((long)1L, (long)allKeys.size());
        QueueKey key = (QueueKey)allKeys.get(0);
        Assert.assertEquals((Object)id, (Object)key.id);
    }

    @Test
    public void testRetrieveFileFromDisk() throws Exception {
        QueuePersistenceObjectStore<Serializable> store = this.getObjectStore();
        String id = UUID.getUUID();
        this.createAndPopulateStoreFile(id, "Test Message");
        QueueKey key = new QueueKey(QUEUE_NAME, (Serializable)((Object)id));
        Serializable value = store.retrieve((Serializable)key);
        Assert.assertEquals((Object)"Test Message", (Object)value);
    }

    @Test
    public void testRemove() throws Exception {
        QueuePersistenceObjectStore<Serializable> store = this.getObjectStore();
        String id = UUID.getUUID();
        File storeFile = this.createAndPopulateStoreFile(id, "Test Message");
        QueueKey key = new QueueKey(QUEUE_NAME, (Serializable)((Object)id));
        store.remove((Serializable)key);
        Assert.assertFalse((boolean)storeFile.exists());
    }

    @Test
    public void testMonitoredWrapper() throws Exception {
        QueuePersistenceObjectStore<Serializable> store = this.getObjectStore();
        String id = UUID.getUUID();
        QueueKey key = new QueueKey(QUEUE_NAME, (Serializable)((Object)id));
        DefaultMuleMessage msg = new DefaultMuleMessage((Object)"Hello", this.mockMuleContext);
        DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)msg, MessageExchangePattern.ONE_WAY, (FlowConstruct)null);
        MonitoredObjectStoreWrapper monitored = new MonitoredObjectStoreWrapper(store);
        monitored.store((Serializable)key, (Serializable)event);
        MonitoredObjectStoreWrapper.StoredObject retrieved = (MonitoredObjectStoreWrapper.StoredObject)store.retrieve((Serializable)key);
        Object item = retrieved.getItem();
        Assert.assertTrue((boolean)(item instanceof MuleEvent));
        MuleEvent newEvent = (MuleEvent)item;
        MuleMessage newMessage = newEvent.getMessage();
        Assert.assertNotNull((Object)newMessage);
        Assert.assertEquals((Object)this.mockMuleContext, (Object)newMessage.getMuleContext());
        Assert.assertEquals((Object)"Hello", (Object)newMessage.getPayload());
    }

    @Test
    public void queueFilesAreRemovedWhenSerializationFails() throws ObjectStoreException {
        QueuePersistenceObjectStore<Serializable> store = this.getObjectStore();
        String id = UUID.getUUID();
        SerializableWrapper value = new SerializableWrapper(new NonSerializableObject());
        File queueFile = this.createStoreFile(id);
        try {
            store.store((Serializable)new QueueKey(QUEUE_NAME, (Serializable)((Object)id)), (Serializable)value);
            Assert.fail();
        }
        catch (ObjectStoreException e) {
            Assert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(SerializationException.class));
            Assert.assertThat((Object)queueFile.exists(), (Matcher)CoreMatchers.is((Object)false));
        }
    }

    private File createAndPopulateStoreFile(String id, String payload) throws IOException {
        File storeFile = this.createStoreFile(id);
        storeFile.getParentFile().mkdir();
        FileOutputStream fos = new FileOutputStream(storeFile);
        muleContext.getObjectSerializer().serialize((Object)payload, (OutputStream)fos);
        return storeFile;
    }

    private File createStoreFile(String id) {
        String path = String.format("%1s/%2s/%3s/%4s.msg", this.persistenceFolder.getAbsolutePath(), "queuestore", QUEUE_NAME, id);
        return FileUtils.newFile((String)path);
    }

    private static class SerializableWrapper
    implements Serializable {
        Object data;

        SerializableWrapper(Object data) {
            this.data = data;
        }
    }
}

