/*
 * Decompiled with CFR 0.152.
 */
package org.drools.common;

import java.io.Serializable;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.drools.base.ClassObjectType;
import org.drools.common.InternalRuleBase;
import org.drools.facttemplates.Fact;
import org.drools.reteoo.ClassObjectTypeConf;
import org.drools.reteoo.FactTemplateTypeConf;
import org.drools.reteoo.ObjectTypeConf;
import org.drools.rule.EntryPoint;
import org.drools.spi.Activation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectTypeConfigurationRegistry
implements Serializable {
    private static final long serialVersionUID = 510L;
    private InternalRuleBase ruleBase;
    private ConcurrentMap<Object, ObjectTypeConf> typeConfMap;

    public ObjectTypeConfigurationRegistry(InternalRuleBase ruleBase) {
        this.ruleBase = ruleBase;
        this.typeConfMap = new ConcurrentHashMap<Object, ObjectTypeConf>();
    }

    public ObjectTypeConf getObjectTypeConf(EntryPoint entrypoint, Object object) {
        ObjectTypeConf existing;
        ObjectTypeConf objectTypeConf = null;
        Class<?> cls = object instanceof Activation ? ClassObjectType.Activation_ObjectType.getClassType() : object.getClass();
        Object key = object instanceof Fact ? ((Fact)object).getFactTemplate().getName() : cls;
        objectTypeConf = (ObjectTypeConf)this.typeConfMap.get(key);
        if (objectTypeConf == null) {
            objectTypeConf = object instanceof Fact ? new FactTemplateTypeConf(entrypoint, ((Fact)object).getFactTemplate(), this.ruleBase) : new ClassObjectTypeConf(entrypoint, (Class<?>)key, this.ruleBase);
        }
        if ((existing = this.typeConfMap.putIfAbsent(key, objectTypeConf)) != null) {
            objectTypeConf = existing;
        }
        return objectTypeConf;
    }

    public Collection<ObjectTypeConf> values() {
        return this.typeConfMap.values();
    }
}

