/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.drools.RuntimeDroolsException;
import org.drools.WorkingMemory;
import org.drools.rule.ConditionalElement;
import org.drools.rule.Declaration;
import org.drools.spi.CompiledInvoker;
import org.drools.spi.EvalExpression;
import org.drools.spi.Tuple;
import org.drools.spi.Wireable;

public class EvalCondition
extends ConditionalElement
implements Externalizable,
Wireable {
    private static final long serialVersionUID = 510L;
    private EvalExpression expression;
    private Declaration[] requiredDeclarations;
    private static final Declaration[] EMPTY_DECLARATIONS = new Declaration[0];
    private List<EvalCondition> cloned = Collections.emptyList();

    public EvalCondition() {
        this(null);
    }

    public EvalCondition(Declaration[] requiredDeclarations) {
        this(null, requiredDeclarations);
    }

    public EvalCondition(EvalExpression eval, Declaration[] requiredDeclarations) {
        this.expression = eval;
        this.requiredDeclarations = requiredDeclarations == null ? EMPTY_DECLARATIONS : requiredDeclarations;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.expression = (EvalExpression)in.readObject();
        this.requiredDeclarations = (Declaration[])in.readObject();
        this.cloned = (List)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        if (this.expression instanceof CompiledInvoker) {
            out.writeObject(null);
        } else {
            out.writeObject(this.expression);
        }
        out.writeObject(this.requiredDeclarations);
        out.writeObject(this.cloned);
    }

    public EvalExpression getEvalExpression() {
        return this.expression;
    }

    public void wire(Object object) {
        this.setEvalExpression((EvalExpression)object);
        for (EvalCondition clone : this.cloned) {
            clone.wire(object);
        }
    }

    public void setEvalExpression(EvalExpression expression) {
        this.expression = expression;
    }

    public Declaration[] getRequiredDeclarations() {
        return this.requiredDeclarations;
    }

    public Object createContext() {
        return this.expression.createContext();
    }

    public boolean isAllowed(Tuple tuple, WorkingMemory workingMemory, Object context) {
        try {
            return this.expression.evaluate(tuple, this.requiredDeclarations, workingMemory, context);
        }
        catch (Exception e) {
            throw new RuntimeDroolsException(this.getEvalExpression() + " : " + e, e);
        }
    }

    public Object clone() {
        EvalCondition clone = new EvalCondition(this.expression.clone(), (Declaration[])this.requiredDeclarations.clone());
        if (this.cloned == Collections.EMPTY_LIST) {
            this.cloned = new ArrayList<EvalCondition>(1);
        }
        this.cloned.add(clone);
        return clone;
    }

    public int hashCode() {
        return this.expression.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || object.getClass() != EvalCondition.class) {
            return false;
        }
        EvalCondition other = (EvalCondition)object;
        if (this.requiredDeclarations.length != other.requiredDeclarations.length) {
            return false;
        }
        int length = this.requiredDeclarations.length;
        for (int i = 0; i < length; ++i) {
            if (this.requiredDeclarations[i].getPattern().getOffset() != other.requiredDeclarations[i].getPattern().getOffset()) {
                return false;
            }
            if (this.requiredDeclarations[i].getExtractor().equals(other.requiredDeclarations[i].getExtractor())) continue;
            return false;
        }
        return this.expression.equals(other.expression);
    }

    public Map getInnerDeclarations() {
        return Collections.EMPTY_MAP;
    }

    public Map getOuterDeclarations() {
        return Collections.EMPTY_MAP;
    }

    public List getNestedElements() {
        return Collections.EMPTY_LIST;
    }

    public boolean isPatternScopeDelimiter() {
        return true;
    }

    public Declaration resolveDeclaration(String identifier) {
        return null;
    }

    public void replaceDeclaration(Declaration declaration, Declaration resolved) {
        for (int i = 0; i < this.requiredDeclarations.length; ++i) {
            if (!this.requiredDeclarations[i].equals(declaration)) continue;
            this.requiredDeclarations[i] = resolved;
        }
        this.expression.replaceDeclaration(declaration, resolved);
    }

    public String toString() {
        return this.expression.toString();
    }
}

