/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.internal.domain.response;

import java.util.Collection;
import org.apache.commons.collections.MultiMap;
import org.apache.commons.collections.map.MultiValueMap;
import org.mule.module.http.internal.domain.BaseHttpMessage;
import org.mule.module.http.internal.domain.HttpEntity;
import org.mule.module.http.internal.domain.response.HttpResponse;
import org.mule.module.http.internal.domain.response.ResponseStatus;

public class DefaultHttpResponse
extends BaseHttpMessage
implements HttpResponse {
    private final HttpEntity body;
    private ResponseStatus responseStatus = new ResponseStatus();
    private MultiMap headers = new MultiValueMap();

    public DefaultHttpResponse(ResponseStatus responseStatus, MultiMap headers, HttpEntity body) {
        this.responseStatus = responseStatus;
        this.headers = headers;
        this.body = body;
    }

    @Override
    public HttpEntity getEntity() {
        return this.body;
    }

    @Override
    public Collection<String> getHeaderNames() {
        return this.headers.keySet();
    }

    @Override
    public String getHeaderValue(String headerName) {
        Object value = this.headers.get((Object)headerName);
        if (value == null) {
            return null;
        }
        return (String)((Collection)value).iterator().next();
    }

    @Override
    public Collection<String> getHeaderValues(String headerName) {
        return (Collection)this.headers.get((Object)headerName);
    }

    @Override
    public int getStatusCode() {
        return this.responseStatus.getStatusCode();
    }

    @Override
    public void setStatusCode(int statusCode) {
        this.responseStatus.setStatusCode(statusCode);
    }

    @Override
    public String getReasonPhrase() {
        return this.responseStatus.getReasonPhrase();
    }

    @Override
    public void setReasonPhrase(String reasonPhrase) {
        this.responseStatus.setReasonPhrase(reasonPhrase);
    }
}

